/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.table.LabeledImageResource;
import com.mathworks.mwt.table.Table;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class MWListbox
extends Table {
    public MWListbox() {
        super(0, 1);
        this.setPreferredTableSize(8, 2);
        this.getHScrollbarOptions().setOverlappingHeader(false);
        this.getHScrollbarOptions().setMode(1);
        this.getVScrollbarOptions().setOverlappingHeader(false);
        this.getColumnOptions().setHeaderVisible(false);
        this.getColumnOptions().setAutoLabel(0);
        this.getRowOptions().setHeaderVisible(false);
        this.setTableBackground(Decorations.getColor(2));
        this.setCursorType(0);
        this.getTableStyle().setBackground(Decorations.getColor(2));
        this.getTableStyle().setForeground(Decorations.getColor(12));
        this.getTableStyle().setHGridVisible(false);
        this.getTableStyle().setVGridVisible(false);
        this.getSelectionOptions().setSelectBy(1);
        this.setAutoExpandColumn(-2);
        if (PlatformInfo.getAppearance() == 1) {
            this.setWindowsNoSelectionFocus(true);
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return this.isEnabled() && this.getSelectionOptions().getMode() != 0;
    }

    public int getExpandColumn() {
        return this.getAutoExpandColumn();
    }

    public void setExpandColumn(int n) {
        this.setAutoExpandColumn(n);
    }

    public boolean isEditable() {
        return this.getTableStyle().isEditable();
    }

    public void setEditable(boolean bl) {
        this.getTableStyle().setEditable(bl);
    }

    public boolean isHeaderVisible() {
        return this.getColumnOptions().isHeaderVisible();
    }

    public void setHeaderVisible(boolean bl) {
        this.getColumnOptions().setHeaderVisible(bl);
    }

    public String[] getHeaders() {
        String[] stringArray = new String[this.getColumnCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = this.getColumnHeaderData(i);
            stringArray[i] = object instanceof String ? (String)object : "";
        }
        return stringArray;
    }

    public void setHeaders(String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length && i < this.getColumnCount(); ++i) {
                this.setColumnHeaderData(i, stringArray[i]);
            }
        }
    }

    public int getColumnCount() {
        return this.getData().getWidth();
    }

    public void setColumnCount(int n) {
        if (n > 0 && n != this.getData().getWidth()) {
            this.getData().setWidth(n);
        }
    }

    public boolean getMultiSelection() {
        boolean bl = false;
        switch (this.getSelectionOptions().getMode()) {
            case 0: 
            case 1: {
                bl = false;
                break;
            }
            case 2: 
            case 3: {
                bl = true;
            }
        }
        return bl;
    }

    public void setMultiSelection(boolean bl) {
        if (bl) {
            this.getSelectionOptions().setMode(3);
        } else {
            this.getSelectionOptions().setMode(1);
        }
    }

    public void addItem(String string) {
        this.addItem((Object)string, -1);
    }

    public void addItem(String string, int n) {
        this.addItem((Object)string, n);
    }

    public void addItem(Object object) {
        this.addItem(object, -1);
    }

    public void addItem(Object object, int n) {
        Object[] objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        this.addItem(objectArray, n);
    }

    public void addItem(Object[] objectArray) {
        this.addItem(objectArray, -1);
    }

    public void addItem(Object[] objectArray, int n) {
        int n2 = this.getData().getWidth();
        if (n == -1) {
            n = this.getData().getHeight();
        }
        this.getData().addRows(n, 1);
        for (int i = 0; i < n2 && i < objectArray.length; ++i) {
            this.getData().setData(n, i, objectArray[i]);
        }
    }

    public void removeItem(int n) {
        this.getData().removeRows(n, 1);
    }

    public void removeItem(String string) {
        if (string != null) {
            for (int i = 0; i < this.getData().getHeight(); ++i) {
                String string2 = this.getData().getDataAsText(i, 0);
                if (!string.equals(string2)) continue;
                this.removeItem(i);
            }
        }
    }

    public void removeAllItems() {
        this.deselectAll();
        this.getData().setHeight(0);
    }

    public int getItemCount() {
        return this.getData().getHeight();
    }

    public String getItem(int n, int n2) {
        String string = null;
        if (n >= 0 && n < this.getItemCount() && n2 >= 0 && n2 < this.getColumnCount()) {
            Object object = this.getCellData(n, n2);
            if (object instanceof String) {
                string = (String)object;
            } else if (object instanceof Character) {
                string = ((Character)object).toString();
            } else if (object instanceof LabeledImageResource) {
                string = ((LabeledImageResource)object).getLabel();
            }
        }
        return string;
    }

    public String getItem(int n) {
        return this.getItem(n, 0);
    }

    public String[] getItems() {
        int n = this.getData().getHeight();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            Object object = this.getCellData(i, 0);
            stringArray[i] = object instanceof String ? (String)object : (object instanceof Character ? ((Character)object).toString() : "");
        }
        return stringArray;
    }

    public void setItems(String[] stringArray) {
        int n = stringArray.length;
        int n2 = this.getData().getHeight();
        if (n != n2) {
            this.getData().setHeight(n);
        }
        for (int i = 0; i < n; ++i) {
            this.getData().setData(i, 0, stringArray[i]);
        }
        this.layoutScrollbars();
    }

    public int getSelectedIndex() {
        return this.getFirstSelectedRow();
    }

    public void setSelectedIndex(int n) {
        this.select(n, 0);
    }

    public int[] getSelectedIndexes() {
        return this.getSelectedRows();
    }

    public void setSelectedIndexes(int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            this.sortInts(nArray);
            Vector<Rectangle> vector = new Vector<Rectangle>();
            Rectangle rectangle = null;
            for (int i = 0; i < nArray.length; ++i) {
                if (rectangle == null) {
                    rectangle = new Rectangle(0, nArray[i], 1, 1);
                    vector.addElement(rectangle);
                    continue;
                }
                if (nArray[i] == rectangle.y + rectangle.height) {
                    ++rectangle.height;
                    continue;
                }
                if (nArray[i] <= rectangle.y + rectangle.height) continue;
                rectangle = new Rectangle(0, nArray[i], 1, 1);
                vector.addElement(rectangle);
            }
            Object[] objectArray = new Rectangle[vector.size()];
            vector.copyInto(objectArray);
            this.select((Rectangle[])objectArray);
        } else {
            this.deselectAll();
        }
    }

    public String getSelectedItem() {
        String string = null;
        int n = this.getSelectedIndex();
        if (n != -2) {
            string = this.getItem(n);
        }
        return string;
    }

    public String[] getSelectedItems() {
        int[] nArray = this.getSelectedIndexes();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == -2) continue;
            stringArray[i] = this.getItem(nArray[i]);
        }
        return stringArray;
    }

    public int getVisibleIndex() {
        return this.getFirstRow();
    }

    private void sortInts(int[] nArray) {
        this.qsortInts(nArray, 0, nArray.length - 1);
    }

    private void qsortInts(int[] nArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            int n5 = nArray[(n + n2) / 2];
            while (n3 <= n4) {
                while (n3 < n2 && nArray[n3] < n5) {
                    ++n3;
                }
                while (n4 > n && nArray[n4] > n5) {
                    --n4;
                }
                if (n3 > n4) continue;
                int n6 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n6;
                ++n3;
                --n4;
            }
            if (n < n4) {
                this.qsortInts(nArray, n, n4);
            }
            if (n3 < n2) {
                this.qsortInts(nArray, n3, n2);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            MWListbox mWListbox = new MWListbox();
            MWFrame mWFrame = new MWFrame("MWListbox Test");
            mWListbox.setActionCommand("test action");
            mWListbox.addItemListener(new MyItemListener());
            mWListbox.addActionListener(new MyActionListener());
            mWListbox.getSelectionOptions().setMode(3);
            mWListbox.setColumnCount(4);
            mWListbox.setExpandColumn(-2);
            mWListbox.setAnchorVisible(true);
            mWListbox.getColumnOptions().setHeaderVisible(true);
            mWListbox.getColumnOptions().setResizable(true);
            mWListbox.setColumnWidth(0, 150);
            mWListbox.getTableStyle().setEditable(true);
            for (int i = 0; i < 20; ++i) {
                object = new String[4];
                for (int j = 0; j < 4; ++j) {
                    object[j] = "Item " + i + ", Col " + j;
                }
                mWListbox.addItem((Object[])object);
            }
            mWFrame.add((Component)mWListbox, "Center");
            MWPanel mWPanel = new MWPanel(new FlowLayout());
            object = new MWButton("Select Row 3");
            ((MWButton)object).setActionCommand("SelectRow");
            ((MWButton)object).addActionListener(new MyActionListener(mWListbox));
            mWPanel.add((Component)object);
            mWFrame.add((Component)mWPanel, "South");
            mWFrame.add((Component)new MWCanvas(8, 8), "North");
            mWFrame.add((Component)new MWCanvas(8, 8), "East");
            mWFrame.add((Component)new MWCanvas(8, 8), "West");
            mWFrame.setContentSize(new Dimension(400, 300));
            mWFrame.setVisible(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static class MyItemListener
    implements ItemListener {
        private MyItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            MWListbox mWListbox = (MWListbox)itemEvent.getItemSelectable();
            String[] stringArray = mWListbox.getSelectedItems();
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("\"" + stringArray[i] + "\"");
            }
            System.out.println("----------------------------------");
        }
    }

    private static class MyActionListener
    implements ActionListener {
        MWListbox fList;

        MyActionListener(MWListbox mWListbox) {
            this.fList = mWListbox;
        }

        MyActionListener() {
            this(null);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int[] nArray = new int[]{4, 6, 2, 1, 7};
            if (string == null) {
                System.out.println("Null action command");
            } else if (string.equals("SelectRow")) {
                this.fList.setSelectedIndexes(nArray);
            } else {
                System.out.println("actionPerformed: \"" + string + "\"");
            }
        }
    }
}

