/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWPopupList;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.dialog.MWDialog;
import com.mathworks.mwt.floater.DragForwarder;
import com.mathworks.mwt.floater.Floater;
import com.mathworks.mwt.floater.FloaterOwner;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class MWCombobox
extends MWPanel
implements FloaterOwner {
    public static final int NO_ITEM = -1;
    private MWPopupList fList;
    private MWTextField fTextField;
    private EventHandler fEventHandler;
    private TextListener fTextListener;
    private ActionListener fActionListener;
    private String fActionCommand;
    private boolean fTextEditable;
    private boolean fHasRollover;
    private Rectangle fRolloverRect;
    private Rectangle fWorkRect;

    public MWCombobox(String string, String[] stringArray) {
        this.setLayout(new BorderLayout());
        this.setOpaqueInsets(false);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (string == null) {
            string = "";
        }
        this.fList = new MWPopupList(true);
        this.fList.setFloaterOwner(this);
        DragForwarder dragForwarder = new DragForwarder(this.fList);
        this.addMouseListener(dragForwarder);
        this.addMouseMotionListener(dragForwarder);
        for (int i = 0; i < stringArray.length; ++i) {
            this.fList.addItem(stringArray[i]);
        }
        this.fTextField = new MWTextField(string, 10);
        this.fTextField.getView().setSelFocusOverride(8);
        if (PlatformInfo.getAppearance() == 1) {
            this.fTextField.setBevelOn(false);
        }
        this.fEventHandler = new EventHandler();
        this.addMouseListener(this.fEventHandler);
        this.fList.addItemListener(this.fEventHandler);
        this.fTextField.addActionListener(this.fEventHandler);
        this.fTextField.addMouseListener(this.fEventHandler);
        this.fTextField.addTextListener(this.fEventHandler);
        this.fTextField.addKeyListener(this.fEventHandler);
        this.fActionCommand = null;
        this.fActionListener = null;
        this.fTextListener = null;
        this.setFont(Decorations.getFont(0));
        this.setTextEditable(true);
        this.add((Component)this.fTextField, "Center");
    }

    public MWCombobox() {
        this("", new String[0]);
    }

    public String getText() {
        return this.fTextField.getText();
    }

    public void setText(String string) {
        this.fTextField.setText(string);
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.fTextField.setName(string + "TextField");
    }

    public void addItem(String string) {
        this.fList.addItem(string);
    }

    public void insertItem(String string, int n) {
        this.fList.insertItem(string, n);
    }

    public void removeItem(int n) {
        this.fList.removeItem(n);
    }

    public void removeItem(String string) {
        this.removeItem(string, false);
    }

    public void removeItem(String string, boolean bl) {
        this.removeItem(this.findIndexOf(string, bl));
    }

    public void removeAllItems() {
        this.fList.removeAllItems();
    }

    public String[] getItems() {
        String[] stringArray = new String[this.fList.getItemCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.fList.getItem(i);
        }
        return stringArray;
    }

    public void setItems(String[] stringArray) {
        this.fList.removeAllItems();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.fList.addItem(stringArray[i]);
            }
        }
    }

    public void selectItem(int n) {
        this.setSelectedIndex(n);
    }

    public void selectItem(String string) {
        this.selectItem(string, false);
    }

    public void selectItem(String string, boolean bl) {
        this.selectItem(this.findIndexOf(string, bl));
    }

    public int getSelectedIndex() {
        int n = this.findIndexOf(this.getText(), false);
        return n;
    }

    public void setSelectedIndex(int n) {
        this.fList.setSelectedIndex(n);
        if (this.fList.getSelectedIndex() != -1) {
            this.updateTextFieldText();
        }
    }

    public boolean getTextEditable() {
        return this.fTextEditable;
    }

    public void setTextEditable(boolean bl) {
        this.fTextEditable = bl;
        this.updateTextFieldState();
    }

    public boolean getSuppressTemporarySelections() {
        return this.fList.getSuppressTemporarySelections();
    }

    public void setSuppressTemporarySelections(boolean bl) {
        this.fList.setSuppressTemporarySelections(bl);
    }

    public boolean contains(String string) {
        return this.contains(string, false);
    }

    public boolean contains(String string, boolean bl) {
        boolean bl2 = false;
        int n = 0;
        while (n < this.fList.getItemCount() && !bl2) {
            if (bl) {
                bl2 = string.equalsIgnoreCase(this.fList.getItem(n++));
                continue;
            }
            bl2 = string.equals(this.fList.getItem(n++));
        }
        return bl2;
    }

    public void setGutterWidth(int n) {
        this.fTextField.setGutterWidth(n);
    }

    public void setRestrictWidth(boolean bl) {
        this.fList.setUseOwnersWidth(bl);
    }

    public String getActionCommand() {
        return this.fActionCommand;
    }

    public void setActionCommand(String string) {
        this.fActionCommand = string;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            super.setEnabled(bl);
            if (this.isShowing()) {
                this.repaint();
            }
        }
        this.updateTextFieldState();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fTextField.setFont(font);
        this.invalidate();
    }

    @Override
    public void requestFocus() {
        this.fTextField.requestFocus();
    }

    public Object getPopupForQE() {
        return this.fList;
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.fTextField.addKeyListener(keyListener);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        this.fTextField.removeKeyListener(keyListener);
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        this.fTextField.getView().addFocusListener(focusListener);
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this.fTextField.getView().removeFocusListener(focusListener);
    }

    public void addTextListener(TextListener textListener) {
        this.fTextListener = AWTEventMulticaster.add(this.fTextListener, textListener);
    }

    public void removeTextListener(TextListener textListener) {
        this.fTextListener = AWTEventMulticaster.remove(this.fTextListener, textListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.fActionListener = AWTEventMulticaster.add(this.fActionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.fActionListener = AWTEventMulticaster.remove(this.fActionListener, actionListener);
    }

    @Override
    public void floaterAutoCollapsed(Floater floater) {
        Window window = MWUtils.getTopLevelWindow(this.fTextField);
        boolean bl = false;
        if (window != null) {
            if (window instanceof MWFrame) {
                bl = ((MWFrame)window).isFrameActive();
            } else if (window instanceof MWDialog) {
                bl = ((MWDialog)window).isFrameActive();
            }
        }
        this.fTextField.getView().setSelFocusOverride(0);
        if (bl) {
            this.requestFocus();
        } else {
            this.fTextField.setSel(this.fTextField.getCaretPosition(), this.fTextField.getCaretPosition());
        }
        this.repaint();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.fTextField.getPreferredSize();
        Insets insets = this.fTextField.getInsets();
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            dimension.width = fontMetrics.stringWidth("333");
            for (int i = 0; i < this.fList.getItemCount(); ++i) {
                dimension.width = Math.max(dimension.width, fontMetrics.stringWidth(this.fList.getItem(i)));
            }
            dimension.width += insets.left + insets.right;
        }
        if (PlatformInfo.getAppearance() == 1) {
            dimension.width = (dimension.height & 1) != 0 ? (dimension.width += dimension.height + 3) : (dimension.width += dimension.height + 4);
            dimension.height += 4;
            if (PlatformInfo.useWindowsXPAppearance()) {
                dimension.width -= 2;
                dimension.height -= 2;
            }
        } else {
            dimension.width += dimension.height + 2;
        }
        return dimension;
    }

    @Override
    public Insets getInsets() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getPreferredSize();
        Insets insets = PlatformInfo.getAppearance() == 1 ? new Insets(2, 2, dimension.height - dimension2.height + 2, (dimension2.height & 1) != 0 ? dimension2.height - 3 : dimension2.height - 2) : new Insets(0, 0, dimension.height - dimension2.height, dimension2.height + 2);
        if (PlatformInfo.useWindowsXPAppearance()) {
            insets = new Insets(1, 1, dimension.height - dimension2.height + 1, (dimension2.height & 1) != 0 ? dimension2.height - 1 : dimension2.height - 0);
        }
        return insets;
    }

    @Override
    public void bufferedPaint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getPreferredSize().height;
        int n3 = this.getSize().height;
        Component component = MWUtils.getTopLevelWindow(this.fTextField).getFocusOwner();
        if (component != null && this.fTextField.isEnabled() && !this.fTextField.getView().hasFocus()) {
            Container container;
            for (container = component.getParent(); container != null && container != this.fTextField; container = container.getParent()) {
            }
            if (container != null) {
                component.requestFocus();
                component.dispatchEvent(new FocusEvent(this.fTextField.getView(), 1004));
            }
        }
        super.bufferedPaint(graphics);
        if (this.fWorkRect == null) {
            this.fWorkRect = new Rectangle(0, 0, n, n2);
        } else {
            this.fWorkRect.setBounds(0, 0, n, n2);
        }
        if (PlatformInfo.useWindowsXPAppearance()) {
            if (this.fRolloverRect == null) {
                this.fRolloverRect = new Rectangle();
            }
            this.fRolloverRect.x = this.fTextField.getSize().width + 1;
            this.fRolloverRect.width = n - this.fRolloverRect.x;
            this.fRolloverRect.height = n2;
        }
        Decorations.drawComboControl(graphics, this.fWorkRect, this.fList.isVisible(), this.isEnabled(), this.fHasRollover);
        if (n2 < n3) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, n2, n, n3 - n2);
        }
        this.fTextField.getView().setTopLine(0);
    }

    protected MWTextField getTextField() {
        return this.fTextField;
    }

    protected void preprocessMousePressed(MouseEvent mouseEvent) {
    }

    protected int findIndexOf(String string, boolean bl) {
        int n = -1;
        if (string != null) {
            for (int i = 0; i < this.fList.getItemCount() && n == -1; ++i) {
                if (bl && string.equalsIgnoreCase(this.fList.getItem(i))) {
                    n = i;
                    continue;
                }
                if (bl || !string.equals(this.fList.getItem(i))) continue;
                n = i;
            }
        }
        return n;
    }

    private void updateTextFieldText() {
        if (this.fList.getSelectedIndex() != -1) {
            this.fTextField.setVisible(false);
            this.setText(this.fList.getSelectedItem());
            this.fTextField.getView().setHScrollAmount(0);
            this.fTextField.selectAll();
            this.fTextField.setVisible(true);
        }
    }

    private void updateTextFieldState() {
        if (this.isEnabled()) {
            this.fTextField.setDimBGWhenDisabled(false);
            this.fTextField.setDimFGWhenDisabled(false);
            this.fTextField.setEnabled(this.fTextEditable);
        } else {
            this.fTextField.setDimBGWhenDisabled(true);
            this.fTextField.setDimFGWhenDisabled(true);
            this.fTextField.setEnabled(false);
        }
    }

    private void popupList() {
        int n = this.findIndexOf(this.fTextField.getText(), false);
        int n2 = this.getSize().width;
        int n3 = this.getPreferredSize().height;
        this.fTextField.getView().setSelFocusOverride(1);
        this.setSelectedIndex(n);
        this.fList.setFont(this.getFont());
        this.fList.show(this, 0, 0, n2, n3);
    }

    private class EventHandler
    extends MouseAdapter
    implements ItemListener,
    ActionListener,
    TextListener,
    KeyListener,
    MouseMotionListener {
        private EventHandler() {
        }

        @Override
        public void textValueChanged(TextEvent textEvent) {
            if (MWCombobox.this.fTextListener != null) {
                TextEvent textEvent2 = new TextEvent(MWCombobox.this, 900);
                MWCombobox.this.fTextListener.textValueChanged(textEvent2);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            MWCombobox.this.updateTextFieldText();
            if (MWCombobox.this.fActionListener != null) {
                ActionEvent actionEvent = new ActionEvent(MWCombobox.this, 1001, MWCombobox.this.getActionCommand());
                MWCombobox.this.fActionListener.actionPerformed(actionEvent);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MWCombobox.this.fTextField.getView().setHScrollAmount(0);
            MWCombobox.this.fTextField.selectAll();
            if (MWCombobox.this.fActionListener != null) {
                ActionEvent actionEvent2 = new ActionEvent(MWCombobox.this, 1001, MWCombobox.this.getActionCommand());
                MWCombobox.this.fActionListener.actionPerformed(actionEvent2);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == MWCombobox.this || mouseEvent.getSource() == MWCombobox.this.fTextField && !MWCombobox.this.fTextField.isEnabled()) {
                MWCombobox.this.preprocessMousePressed(mouseEvent);
                int n = MWCombobox.this.getPreferredSize().height;
                if (MWCombobox.this.fList.isVisible()) {
                    this.collapseList();
                    MWCombobox.this.requestFocus();
                } else if (MWCombobox.this.isEnabled() && mouseEvent.getY() < n) {
                    MWCombobox.this.requestFocus();
                    MWCombobox.this.popupList();
                }
                MWCombobox.this.repaint();
            } else if (mouseEvent.getSource() == MWCombobox.this.fTextField && MWCombobox.this.fTextField.isEnabled() && MWCombobox.this.fList.isVisible()) {
                this.collapseList();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (PlatformInfo.useWindowsXPAppearance()) {
                Dimension dimension = MWCombobox.this.fTextField.getSize();
                if (MWCombobox.this.fRolloverRect != null && (!MWCombobox.this.fTextEditable || MWCombobox.this.fRolloverRect.contains(mouseEvent.getPoint()))) {
                    MWCombobox.this.fHasRollover = true;
                    if (MWCombobox.this.isEnabled()) {
                        MWCombobox.this.repaint(((MWCombobox)MWCombobox.this).fRolloverRect.x, ((MWCombobox)MWCombobox.this).fRolloverRect.y, ((MWCombobox)MWCombobox.this).fRolloverRect.width, ((MWCombobox)MWCombobox.this).fRolloverRect.height);
                    }
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (MWCombobox.this.fHasRollover && PlatformInfo.useWindowsXPAppearance()) {
                MWCombobox.this.fHasRollover = false;
                if (MWCombobox.this.isEnabled()) {
                    MWCombobox.this.repaint(((MWCombobox)MWCombobox.this).fRolloverRect.x, ((MWCombobox)MWCombobox.this).fRolloverRect.y, ((MWCombobox)MWCombobox.this).fRolloverRect.width, ((MWCombobox)MWCombobox.this).fRolloverRect.height);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (PlatformInfo.useWindowsXPAppearance() && MWCombobox.this.fTextEditable) {
                if (MWCombobox.this.fHasRollover) {
                    if (!MWCombobox.this.fRolloverRect.contains(mouseEvent.getPoint())) {
                        MWCombobox.this.fHasRollover = false;
                        if (MWCombobox.this.isEnabled()) {
                            MWCombobox.this.repaint(((MWCombobox)MWCombobox.this).fRolloverRect.x, ((MWCombobox)MWCombobox.this).fRolloverRect.y, ((MWCombobox)MWCombobox.this).fRolloverRect.width, ((MWCombobox)MWCombobox.this).fRolloverRect.height);
                        }
                    }
                } else if (MWCombobox.this.fRolloverRect.contains(mouseEvent.getPoint())) {
                    MWCombobox.this.fHasRollover = true;
                    if (MWCombobox.this.isEnabled()) {
                        MWCombobox.this.repaint(((MWCombobox)MWCombobox.this).fRolloverRect.x, ((MWCombobox)MWCombobox.this).fRolloverRect.y, ((MWCombobox)MWCombobox.this).fRolloverRect.width, ((MWCombobox)MWCombobox.this).fRolloverRect.height);
                    }
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (MWCombobox.this.isEnabled() && !MWCombobox.this.fList.isShowing() && (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40)) {
                MWCombobox.this.popupList();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        private void collapseList() {
            MWCombobox.this.fList.collapse();
            if (MWCombobox.this.fList.getFloaterOwner() != null) {
                MWCombobox.this.fList.getFloaterOwner().floaterAutoCollapsed(MWCombobox.this.fList);
            }
        }
    }
}

