/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWClipboardListener;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Timer;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class MWClipboardMonitor
implements ActionListener {
    private boolean fHasText = false;
    private Vector fListeners = new Vector();
    private static MWClipboardMonitor sTheMonitor = new MWClipboardMonitor();
    private static final int POLL_PERIOD = 500;
    private static final DataFlavor[] sStringFlavor = new DataFlavor[]{DataFlavor.stringFlavor};

    private MWClipboardMonitor() {
        if (!PlatformInfo.isUnix()) {
            new Timer(500, (ActionListener)this, "Clipboard Monitoring").start();
        }
    }

    public static void addListener(MWClipboardListener mWClipboardListener) {
        MWClipboardMonitor.sTheMonitor.fListeners.addElement(mWClipboardListener);
    }

    public static void removeListener(MWClipboardListener mWClipboardListener) {
        MWClipboardMonitor.sTheMonitor.fListeners.removeElement(mWClipboardListener);
    }

    public static DataFlavor[] getFlavors() {
        return MWClipboardMonitor.sTheMonitor.fHasText ? sStringFlavor : null;
    }

    public static void dataPlacedOnClipboard() {
        if (PlatformInfo.isUnix()) {
            return;
        }
        sTheMonitor.actionPerformed(null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = NativeJava.winClipboardHasText();
        if (bl != this.fHasText || actionEvent == null) {
            this.fHasText = bl;
            this.notifyListeners();
        }
    }

    private void notifyListeners() {
        int n = this.fListeners.size();
        for (int i = 0; i < n; ++i) {
            ((MWClipboardListener)this.fListeners.elementAt(i)).clipboardContentTypeChanged(MWClipboardMonitor.getFlavors());
        }
    }
}

