/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWExclusiveGroup;
import com.mathworks.mwt.MWExclusiveGroupItem;
import com.mathworks.mwt.command.MWCommandSource;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Locale;

public class MWCheckbox
extends MWCanvas
implements ItemSelectable,
MWExclusiveGroupItem,
MWCommandSource {
    public static final int CHECKBOX = 0;
    public static final int RADIO_BUTTON = 1;
    private static final int LABEL_OFFSET = 18;
    private static final int DELAY = 5;
    private String fLabel;
    private boolean fState;
    private boolean fMixedState;
    private int fAppearance;
    private int fBehavior;
    private MWExclusiveGroup fGroup;
    private int fCheckSize;
    private boolean fMouseIn;
    private boolean fTracking;
    private boolean fHasFocus;
    transient ItemListener fItemListener;
    transient boolean fHasRollover;
    transient Rectangle fRolloverRect;
    private MWCommandTarget fTarget;
    private int fCommand;

    public MWCheckbox(String string, boolean bl, MWExclusiveGroup mWExclusiveGroup) {
        this.fLabel = string;
        this.fGroup = mWExclusiveGroup;
        if (mWExclusiveGroup != null) {
            this.fAppearance = 1;
            this.fBehavior = 1;
        } else {
            this.fAppearance = 0;
            this.fBehavior = 0;
        }
        this.setState(bl);
        this.setMixedState(false);
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.setFont(Decorations.getFont(0));
    }

    public MWCheckbox(String string, MWExclusiveGroup mWExclusiveGroup, boolean bl) {
        this(string, bl, mWExclusiveGroup);
    }

    public MWCheckbox(String string, boolean bl) {
        this(string, bl, null);
    }

    public MWCheckbox(String string) {
        this(string, false, null);
    }

    public MWCheckbox() {
        this("", false, null);
    }

    @Override
    public void paint(Graphics graphics) {
        this.drawCheckbox(graphics);
    }

    private void drawCheckbox(Graphics graphics) {
        boolean bl;
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
        int n = (this.getSize().height - Decorations.getChecksize()) / 2;
        boolean bl2 = bl = this.fTracking && this.fMouseIn;
        if (this.fAppearance == 1) {
            Decorations.drawRadiobutton(graphics, 0, n, bl, this.fState, this.fMixedState, this.isEnabled(), this.fHasRollover);
        } else {
            Decorations.drawCheckbox(graphics, 0, n, bl, this.fState, this.fMixedState, this.isEnabled(), this.fHasRollover);
        }
        Point point = this.calcLabelPos();
        graphics.setFont(this.getFont());
        Decorations.drawLabel(graphics, this.fLabel, point.x, point.y, false, this.isEnabled());
        if (PlatformInfo.getAppearance() == 1) {
            Rectangle rectangle = this.calcFocusRect(point);
            Decorations.drawFocusRect(graphics, rectangle);
        }
    }

    private Rectangle calcFocusRect(Point point) {
        Font font;
        Rectangle rectangle = null;
        if (this.fHasFocus && (font = this.getFont()) != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            if (PlatformInfo.getAppearance() == 1) {
                rectangle = new Rectangle();
                rectangle.x = point.x;
                rectangle.y = point.y - (fontMetrics.getAscent() + fontMetrics.getLeading());
                rectangle.height = fontMetrics.getHeight() - 1;
                rectangle.width = fontMetrics.stringWidth(this.fLabel) - 1;
            }
        }
        return rectangle;
    }

    private Point calcLabelPos() {
        int n;
        Serializable serializable;
        int n2 = 0;
        int n3 = 0;
        Font font = this.getFont();
        if (font != null) {
            serializable = this.getFontMetrics(font);
            n = 0;
            if (PlatformInfo.isMacintosh() && ((FontMetrics)serializable).getLeading() > ((FontMetrics)serializable).getMaxAscent() >> 1 && (Locale.getDefault().equals(Locale.JAPAN) || Locale.getDefault().equals(Locale.JAPANESE))) {
                n = (((FontMetrics)serializable).getMaxAscent() >> 3) - ((FontMetrics)serializable).getLeading();
            }
            n2 = ((FontMetrics)serializable).getAscent() + ((FontMetrics)serializable).getLeading() + n;
            n3 = ((FontMetrics)serializable).getHeight() + n;
        }
        serializable = new Point();
        n = Decorations.getChecksize();
        ((Point)serializable).y = (this.getSize().height - n3) / 2;
        ((Point)serializable).y += n2;
        ((Point)serializable).x = n > 15 ? n + 5 : 18;
        return serializable;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public String getLabel() {
        return this.fLabel;
    }

    public void setLabel(String string) {
        this.fLabel = string;
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public int getBehavior() {
        return this.fBehavior;
    }

    public void setBehavior(int n) {
        if (this.fGroup == null && (n == 1 || n == 0)) {
            this.fBehavior = n;
        }
    }

    public int getAppearance() {
        return this.fAppearance;
    }

    public void setAppearance(int n) {
        if (n == 1 || n == 0) {
            this.fAppearance = n;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        Font font = this.getFont();
        Point point = this.calcLabelPos();
        int n = Decorations.getChecksize();
        if (font != null && this.fLabel != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            dimension.width = fontMetrics.stringWidth(this.fLabel);
            dimension.height = fontMetrics.getHeight();
            if (PlatformInfo.isMacintosh() && fontMetrics.getLeading() > fontMetrics.getMaxAscent() >> 1 && (Locale.getDefault().equals(Locale.JAPAN) || Locale.getDefault().equals(Locale.JAPANESE))) {
                dimension.height -= fontMetrics.getLeading() - (fontMetrics.getMaxAscent() >> 3);
            }
        } else {
            dimension.width = 0;
            dimension.height = 0;
        }
        dimension.width += point.x;
        if (dimension.height < n) {
            dimension.height = n;
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean getState() {
        return this.fState;
    }

    @Override
    public void setState(boolean bl) {
        if (this.fGroup != null) {
            if (bl) {
                this.fGroup.setSelectedItem(this);
            } else if (this.fGroup.getSelectedItem() == this) {
                bl = true;
            }
        }
        if (this.fState != bl) {
            this.fState = bl;
            if (this.isShowing()) {
                this.repaint(0, 0, this.calcLabelPos().x, this.getSize().height);
            }
        }
    }

    public boolean isMixedState() {
        return this.fMixedState;
    }

    public void setMixedState(boolean bl) {
        if (bl != this.fMixedState) {
            this.fMixedState = bl;
            if (this.isShowing()) {
                this.repaint(0, 0, this.calcLabelPos().x, this.getSize().height);
            }
        }
    }

    @Override
    public MWExclusiveGroup getGroup() {
        return this.fGroup;
    }

    @Override
    public void setGroup(MWExclusiveGroup mWExclusiveGroup) {
        if (this.fGroup != null) {
            this.fGroup.setSelectedItem(null);
        }
        this.fGroup = mWExclusiveGroup;
    }

    @Override
    public boolean isFocusTraversable() {
        if (PlatformInfo.getAppearance() == 0) {
            return false;
        }
        return this.isEnabled();
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getModifiers() == 0 && keyEvent.getKeyCode() == 32) {
            this.toggleState();
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    @Override
    public void processFocusEvent(FocusEvent focusEvent) {
        boolean bl = focusEvent.getID() != 1005;
        if (bl != this.fHasFocus) {
            this.fHasFocus = bl;
            this.repaint(5L);
        }
        super.processFocusEvent(focusEvent);
    }

    private void toggleState() {
        boolean bl = this.fMixedState || this.fBehavior == 1 ? true : (this.fBehavior == 0 ? !this.fState : this.fState);
        if (this.fMixedState || bl != this.fState) {
            this.setState(bl);
            if (this.fMixedState) {
                this.fMixedState = false;
            }
            if (this.fItemListener != null) {
                int n = bl ? 1 : 2;
                ItemEvent itemEvent = new ItemEvent(this, 701, this, n);
                this.fItemListener.itemStateChanged(itemEvent);
            }
            if (this.fTarget != null) {
                this.fTarget.doCommand(this.fCommand);
            }
        }
        this.repaint(5L);
    }

    @Override
    public Object[] getSelectedObjects() {
        if (this.fState) {
            Object[] objectArray = new Object[]{this};
            return objectArray;
        }
        return null;
    }

    @Override
    public synchronized void addItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.add(this.fItemListener, itemListener);
    }

    @Override
    public synchronized void removeItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.remove(this.fItemListener, itemListener);
    }

    @Override
    public void setTarget(MWCommandTarget mWCommandTarget) {
        this.fTarget = mWCommandTarget;
    }

    @Override
    public final MWCommandTarget getTarget() {
        return this.fTarget;
    }

    @Override
    public void setCommand(int n) {
        this.fCommand = n;
    }

    @Override
    public final int getCommand() {
        return this.fCommand;
    }

    @Override
    public void enableCommand(boolean bl) {
        if (bl != this.isEnabled()) {
            this.setEnabled(bl);
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl;
            if (PlatformInfo.getPlatform() == 0) {
                bl = (mouseEvent.getModifiers() & 2) == 0;
            } else {
                boolean bl2 = bl = (mouseEvent.getModifiers() & 4) == 0;
            }
            if (MWCheckbox.this.isEnabled() && bl) {
                MWCheckbox.this.fTracking = true;
                MWCheckbox.this.fMouseIn = true;
                MWCheckbox.this.requestFocus();
                MWCheckbox.this.repaint(0, 0, ((MWCheckbox)MWCheckbox.this).calcLabelPos().x, MWCheckbox.this.getSize().height);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Rectangle rectangle = new Rectangle(0, 0, MWCheckbox.this.getSize().width, MWCheckbox.this.getSize().height);
            if (MWCheckbox.this.fTracking) {
                MWCheckbox.this.fTracking = false;
                if (MWCheckbox.this.fMouseIn != rectangle.contains(mouseEvent.getPoint())) {
                    MWCheckbox.this.fMouseIn = rectangle.contains(mouseEvent.getPoint());
                    MWCheckbox.this.repaint(5L);
                }
                if (MWCheckbox.this.fMouseIn) {
                    MWCheckbox.this.toggleState();
                } else {
                    this.mouseExited(mouseEvent);
                }
            }
            MWCheckbox.this.fMouseIn = false;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (PlatformInfo.useWindowsXPAppearance() && !MWCheckbox.this.fHasRollover) {
                MWCheckbox.this.fRolloverRect = MWCheckbox.this.getBounds();
                MWCheckbox.this.fRolloverRect.translate(-MWCheckbox.this.fRolloverRect.x, -MWCheckbox.this.fRolloverRect.y);
                if (MWCheckbox.this.fRolloverRect.contains(mouseEvent.getPoint())) {
                    MWCheckbox.this.fHasRollover = true;
                    MWCheckbox.this.repaint(0, (MWCheckbox.this.fRolloverRect.height - Decorations.getChecksize()) / 2, Decorations.getChecksize(), Decorations.getChecksize());
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            MWCheckbox.this.fHasRollover = true;
            if (PlatformInfo.useWindowsXPAppearance() && MWCheckbox.this.isEnabled()) {
                if (!MWCheckbox.this.fTracking && (mouseEvent.getModifiers() & 0x10) != 0) {
                    MWCheckbox.this.fHasRollover = false;
                } else {
                    MWCheckbox.this.repaint(0, (MWCheckbox.this.getSize().height - Decorations.getChecksize()) / 2, Decorations.getChecksize(), Decorations.getChecksize());
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (MWCheckbox.this.fHasRollover) {
                MWCheckbox.this.fHasRollover = false;
                if (PlatformInfo.useWindowsXPAppearance() && MWCheckbox.this.isEnabled()) {
                    if (MWCheckbox.this.fTracking) {
                        MWCheckbox.this.fHasRollover = true;
                    }
                    MWCheckbox.this.repaint(0, (MWCheckbox.this.getSize().height - Decorations.getChecksize()) / 2, Decorations.getChecksize(), Decorations.getChecksize());
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (MWCheckbox.this.fTracking) {
                boolean bl;
                Point point = mouseEvent.getPoint();
                Dimension dimension = MWCheckbox.this.getSize();
                boolean bl2 = bl = point.x >= 0 && point.x <= dimension.width && point.y >= 0 && point.y <= dimension.height;
                if (MWCheckbox.this.fMouseIn != bl) {
                    MWCheckbox.this.fMouseIn = bl;
                    if (!bl && PlatformInfo.useWindowsXPAppearance() && MWCheckbox.this.isEnabled()) {
                        this.mouseExited(mouseEvent);
                    }
                    MWCheckbox.this.repaint(0, 0, ((MWCheckbox)MWCheckbox.this).calcLabelPos().x, MWCheckbox.this.getSize().height);
                }
            }
        }
    }
}

