/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.xml;

import com.mathworks.xml.EncodingParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLUtils {
    public static final String UTF_8_ENCODING = "utf-8";
    private static DocumentBuilder sDocBuilder = null;

    private XMLUtils() {
    }

    public static void serializeXML(Object object, Object object2) throws Exception {
        XMLUtils.serializeXML(object, object2, null);
    }

    public static String modifiedIdentityTransformation(String string) {
        return "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:output method=\"xml\" /><xsl:template match=\"@*|node()\"><xsl:copy><xsl:apply-templates select=\"@*|node()\"/></xsl:copy></xsl:template>" + string + "</xsl:stylesheet>";
    }

    public static String transform(String string, String string2) throws IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(new StringReader(string2)));
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new StreamSource(new StringReader(string)), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (TransformerException transformerException) {
            throw new IllegalStateException(transformerException);
        }
    }

    public static void transform(File file, String string, File file2) throws IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(new StringReader(string)));
            transformer.transform(new StreamSource(file.getAbsolutePath()), new StreamResult(file2));
        }
        catch (TransformerException transformerException) {
            throw new IllegalStateException(transformerException);
        }
    }

    public static void transform(File file, File file2, File file3) throws IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(file2.getAbsolutePath()));
            transformer.transform(new StreamSource(file.getAbsolutePath()), new StreamResult(file3));
        }
        catch (TransformerException transformerException) {
            throw new IllegalStateException(transformerException);
        }
    }

    public static void serializeXML(Object object, Object object2, String string) throws Exception {
        Document document;
        DocumentType documentType;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        if (string != null) {
            transformer.setOutputProperty("encoding", string);
        }
        if (object instanceof Document && (documentType = (document = (Document)object).getDoctype()) != null) {
            String string2 = documentType.getSystemId();
            String string3 = documentType.getPublicId();
            if (string2 != null) {
                transformer.setOutputProperty("doctype-system", string2);
            }
            if (string3 != null) {
                transformer.setOutputProperty("doctype-public", string3);
            }
        }
        transformer.transform(XMLUtils.transformSourceFactory(object), XMLUtils.transformResultFactory(object2));
    }

    public static Source transformSourceFactory(Object object) throws Exception {
        if (object instanceof Source) {
            return (Source)object;
        }
        if (object instanceof String) {
            return new StreamSource((String)object);
        }
        if (object instanceof Node) {
            return new DOMSource((Node)object);
        }
        if (object instanceof InputSource) {
            return new SAXSource((InputSource)object);
        }
        if (object instanceof InputStream) {
            return new StreamSource((InputStream)object);
        }
        if (object instanceof Reader) {
            return new StreamSource((Reader)object);
        }
        if (object instanceof File) {
            return new StreamSource((File)object);
        }
        throw new Exception("Unrecognized XSLT Source type");
    }

    public static Result transformResultFactory(Object object) throws Exception {
        if (object instanceof Result) {
            return (Result)object;
        }
        if (object instanceof String) {
            return new StreamResult((String)object);
        }
        if (object instanceof Node) {
            return new DOMResult((Node)object);
        }
        if (object instanceof ContentHandler) {
            return new SAXResult((ContentHandler)object);
        }
        if (object instanceof File) {
            return new StreamResult((File)object);
        }
        if (object instanceof OutputStream) {
            return new StreamResult((OutputStream)object);
        }
        if (object instanceof Writer) {
            return new StreamResult((Writer)object);
        }
        throw new Exception("Unrecognized XSLT Result type");
    }

    public static Document createDocument(String string) throws Exception {
        return XMLUtils.createDocument("", string);
    }

    public static Document createDocument(String string, String string2) throws Exception {
        return XMLUtils.getDOMImpl().createDocument(string, string2, null);
    }

    public static Document createDocument(String string, String string2, DocumentType documentType) throws Exception {
        return XMLUtils.getDOMImpl().createDocument(string, string2, documentType);
    }

    public static Document createDocument(String string, String string2, String string3, String string4) throws Exception {
        return XMLUtils.getDOMImpl().createDocument(string, string2, XMLUtils.getDOMImpl().createDocumentType(string2, string3, string4));
    }

    public static DocumentType createDocumentType(String string, String string2, String string3) throws Exception {
        return XMLUtils.getDOMImpl().createDocumentType(string, string2, string3);
    }

    private static DocumentBuilder getDocBuilder() throws ParserConfigurationException {
        if (sDocBuilder == null) {
            sDocBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        return sDocBuilder;
    }

    private static DOMImplementation getDOMImpl() throws ParserConfigurationException {
        return XMLUtils.getDocBuilder().getDOMImplementation();
    }

    public static Document parse(Object object) throws SAXException, IOException, ParserConfigurationException {
        return XMLUtils.parse(object, XMLUtils.getDocBuilder());
    }

    public static Document parse(Object object, DocumentBuilder documentBuilder) throws SAXException, IOException, ParserConfigurationException {
        if (object instanceof File) {
            return documentBuilder.parse(new InputSource(new FileReader((File)object)));
        }
        if (object instanceof String) {
            return documentBuilder.parse((String)object);
        }
        if (object instanceof InputSource) {
            return documentBuilder.parse((InputSource)object);
        }
        if (object instanceof InputStream) {
            return documentBuilder.parse((InputStream)object);
        }
        throw new SAXException("Invalid parser input type");
    }

    public static String filePathAsUrl(String string) {
        String string2 = string.substring(0, 2);
        String string3 = string2.equals("\\\\") || string2.equals("//") ? "file:///\\" : (string.substring(1, 2).equals(":") ? "file:///" : "file://");
        return string3 + string;
    }

    public static String getEncoding(InputStream inputStream) {
        return EncodingParser.getEncoding(inputStream);
    }

    public static String getEncoding(Reader reader) {
        return EncodingParser.getEncoding(reader);
    }

    public static void replaceTextRecursively(Document document, Node node, String string, String string2, String string3) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeName() != null && node2.getNodeName().equals(string)) {
                    String string4 = node2.getTextContent().trim();
                    if (string4 == null || !string4.equals(string2.trim())) continue;
                    XMLUtils.replaceText(document, (Element)node2, string3);
                    continue;
                }
                XMLUtils.replaceTextRecursively(document, node2, string, string2, string3);
            }
        }
    }

    public static void replaceText(Document document, Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                element.removeChild(nodeList.item(i));
            }
        }
        Text text = document.createTextNode(string);
        element.appendChild(text);
    }

    public static boolean startsWithElement(String string, InputStream inputStream) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Tag cannot be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream cannot be null");
        }
        ElementFinder elementFinder = new ElementFinder(string);
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(elementFinder);
            xMLReader.setErrorHandler(elementFinder);
            xMLReader.setEntityResolver(elementFinder);
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return elementFinder.fFoundElement;
    }

    private static class ElementFinder
    extends DefaultHandler {
        private boolean fFoundElement = false;
        private final String fElementName;

        private ElementFinder(String string) {
            this.fElementName = string;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.fElementName.equals(string2)) {
                this.fFoundElement = true;
            }
            throw new SAXException("Parsed first element, terminate parsing.");
        }

        @Override
        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            throw new SAXException("XML should not include external entities. Found '" + string2 + "'.");
        }
    }
}

