/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.text;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseEvent;
import javax.swing.text.JTextComponent;

public class TextDragRecognizer
extends MouseDragGestureRecognizer {
    protected MouseEvent fSuppressedMousePress;
    protected Cursor fNonSelectedCursor;
    protected static final int fButtonMask = 16;
    protected static final int fKeyMask = 3;
    protected static final int fMotionThreshold = TextDragRecognizer.getMotionThreshold();

    private static int getMotionThreshold() {
        try {
            return (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.gestureMotionThreshold");
        }
        catch (Exception exception) {
            return 5;
        }
    }

    public TextDragRecognizer(DragSource dragSource, JTextComponent jTextComponent, int n, DragGestureListener dragGestureListener) {
        super(dragSource, jTextComponent, n, dragGestureListener);
    }

    protected int mapDragOperationFromModifiers(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 0x10) == 0) {
            return 0;
        }
        if ((n &= 3) == 0) {
            return 2;
        }
        if (n == 3) {
            return 0x40000000;
        }
        if (n == 2) {
            return 1;
        }
        return 1;
    }

    protected boolean selectionContains(JTextComponent jTextComponent, Point point) {
        int n;
        int n2 = jTextComponent.getSelectionStart();
        if (n2 == (n = jTextComponent.getSelectionEnd())) {
            return false;
        }
        int n3 = jTextComponent.viewToModel(point);
        return n2 <= n3 && n3 <= n;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent == this.fSuppressedMousePress) {
            return;
        }
        this.fSuppressedMousePress = null;
        if (this.mapDragOperationFromModifiers(mouseEvent) != 0 && this.selectionContains((JTextComponent)mouseEvent.getSource(), mouseEvent.getPoint())) {
            this.events.clear();
            this.appendEvent(mouseEvent);
            this.fSuppressedMousePress = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.events.clear();
        if (this.fSuppressedMousePress != null) {
            ((Component)mouseEvent.getSource()).dispatchEvent(this.fSuppressedMousePress);
            this.fSuppressedMousePress = null;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.events.clear();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.events.isEmpty()) {
            int n = this.mapDragOperationFromModifiers(mouseEvent);
            if (n != 0) {
                this.appendEvent(mouseEvent);
                this.fireDragGestureRecognized(n, ((MouseEvent)this.getTriggerEvent()).getPoint());
            } else {
                this.events.clear();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.events.isEmpty()) {
            int n = this.mapDragOperationFromModifiers(mouseEvent);
            if (n == 0) {
                return;
            }
            MouseEvent mouseEvent2 = (MouseEvent)this.events.get(0);
            Point point = mouseEvent2.getPoint();
            Point point2 = mouseEvent.getPoint();
            int n2 = Math.abs(point.x - point2.x);
            int n3 = Math.abs(point.y - point2.y);
            if (n2 > fMotionThreshold || n3 > fMotionThreshold) {
                this.fireDragGestureRecognized(n, ((MouseEvent)this.getTriggerEvent()).getPoint());
            } else {
                this.appendEvent(mouseEvent);
            }
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
        Cursor cursor = jTextComponent.getCursor();
        if (cursor == Cursor.getPredefinedCursor(3)) {
            return;
        }
        if (this.selectionContains(jTextComponent, mouseEvent.getPoint())) {
            if (cursor != Cursor.getDefaultCursor()) {
                this.fNonSelectedCursor = cursor;
                jTextComponent.setCursor(Cursor.getDefaultCursor());
            }
        } else if (cursor != this.fNonSelectedCursor) {
            if (this.fNonSelectedCursor != null) {
                jTextComponent.setCursor(this.fNonSelectedCursor);
            } else if (cursor != Cursor.getPredefinedCursor(2)) {
                jTextComponent.setCursor(Cursor.getPredefinedCursor(2));
            }
        }
    }
}

