/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.modality;

import com.mathworks.mwswing.modality.ModalLevel;
import com.mathworks.mwswing.modality.ModalParticipant;
import com.mathworks.mwswing.modality.ModalStack;
import java.util.Stack;

class ModalStackImpl
implements ModalStack {
    private Stack fLevelStack = new Stack();
    private ModalLevel fCurrentLevel = null;

    public ModalStackImpl() {
        this.addNewLevel(null);
    }

    @Override
    public int modalLevels() {
        return this.fLevelStack.size();
    }

    @Override
    public void push(ModalParticipant modalParticipant, boolean bl) {
        if (bl) {
            assert (this.fCurrentLevel != null);
            this.addNewLevel(modalParticipant);
        } else {
            this.fCurrentLevel.add(modalParticipant);
        }
    }

    @Override
    public void pop(ModalParticipant modalParticipant) {
        int n;
        ModalLevel modalLevel = null;
        int n2 = this.fLevelStack.size();
        for (n = 0; n < n2; ++n) {
            ModalLevel modalLevel2 = (ModalLevel)this.fLevelStack.elementAt(n);
            if (!modalLevel2.contains(modalParticipant)) continue;
            modalLevel = modalLevel2;
            break;
        }
        if (modalLevel != null) {
            if (modalParticipant == modalLevel.getOwner()) {
                assert (n > 0);
                modalLevel.remove(modalParticipant);
                this.removeLevel(n);
            } else {
                modalLevel.remove(modalParticipant);
            }
        }
    }

    @Override
    public ModalParticipant peek() {
        return this.fCurrentLevel.getOwner();
    }

    @Override
    public boolean canKeepFocus(ModalParticipant modalParticipant) {
        return this.fCurrentLevel.contains(modalParticipant);
    }

    @Override
    public void modalize(ModalParticipant modalParticipant) {
        if (this.isCurrentlyModal(modalParticipant)) {
            return;
        }
        ModalLevel modalLevel = this.getParticipantLevel(modalParticipant);
        if (modalLevel != null) {
            modalLevel.remove(modalParticipant);
            this.addNewLevel(modalParticipant);
        }
    }

    @Override
    public void demodalize(ModalParticipant modalParticipant) {
        int n;
        boolean bl = false;
        int n2 = this.fLevelStack.size();
        for (n = 0; n < n2; ++n) {
            ModalLevel modalLevel = (ModalLevel)this.fLevelStack.elementAt(n);
            if (modalLevel.getOwner() != modalParticipant) continue;
            bl = true;
            break;
        }
        if (bl) {
            assert (n > 0);
            this.removeLevel(n);
        }
    }

    private void addNewLevel(ModalParticipant modalParticipant) {
        if (this.fCurrentLevel != null) {
            this.fCurrentLevel.setEnabled(false);
        }
        this.fCurrentLevel = new ModalLevel(modalParticipant);
        this.fLevelStack.push(this.fCurrentLevel);
        this.fCurrentLevel.setEnabled(true);
    }

    private void removeLevel(int n) {
        assert (n > 0);
        ModalLevel modalLevel = (ModalLevel)this.fLevelStack.elementAt(n);
        ModalLevel modalLevel2 = (ModalLevel)this.fLevelStack.elementAt(n - 1);
        modalLevel2.addAll(modalLevel);
        this.fLevelStack.remove(modalLevel);
        if (this.fCurrentLevel == modalLevel) {
            this.fCurrentLevel = modalLevel2;
            this.fCurrentLevel.setEnabled(true);
        }
    }

    private boolean isCurrentlyModal(ModalParticipant modalParticipant) {
        boolean bl = false;
        for (ModalLevel modalLevel : this.fLevelStack) {
            if (modalParticipant != modalLevel.getOwner()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private ModalLevel getParticipantLevel(ModalParticipant modalParticipant) {
        ModalLevel modalLevel = null;
        for (ModalLevel modalLevel2 : this.fLevelStack) {
            if (!modalLevel2.contains(modalParticipant)) continue;
            modalLevel = modalLevel2;
            break;
        }
        return modalLevel;
    }
}

