/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.modality;

import com.mathworks.mwswing.modality.ModalManager;
import com.mathworks.mwswing.modality.ModalParticipant;
import com.mathworks.mwswing.modality.ModalStack;
import com.mathworks.mwswing.modality.ModalStackImpl;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import javax.swing.SwingUtilities;

public class ModalManagerImpl
implements ModalManager {
    private static ModalManagerImpl fUniqueInstance = new ModalManagerImpl();
    private ModalStack fModalStack = null;
    private boolean fEventFiltering = false;
    private ModalParticipant fLastFocusedParticipant = null;
    private ModalityManagerAWTEventListener fEventListener = new ModalityManagerAWTEventListener();
    private Hashtable<Integer, WeakReference<ModalParticipant>> fParticipants = new Hashtable();

    private ModalManagerImpl() {
        this.fModalStack = this.createModalStack();
    }

    public static synchronized ModalManager getInstance() {
        return fUniqueInstance;
    }

    protected ModalStack createModalStack() {
        return new ModalStackImpl();
    }

    private boolean modalExists() {
        return this.fModalStack.modalLevels() > 1;
    }

    @Override
    public void updateFocus(ModalParticipant modalParticipant) {
        if (!this.fParticipants.containsKey(new Integer(modalParticipant.hashCode()))) {
            return;
        }
        if (!this.modalExists() || this.fModalStack.canKeepFocus(modalParticipant)) {
            this.fLastFocusedParticipant = modalParticipant;
            return;
        }
        Toolkit.getDefaultToolkit().beep();
        ModalParticipant modalParticipant2 = this.fLastFocusedParticipant;
        if (!this.fModalStack.canKeepFocus(modalParticipant2)) {
            modalParticipant2 = this.fModalStack.peek();
        }
        if (modalParticipant2 != null) {
            assert (modalParticipant2 instanceof Window);
            if (modalParticipant2 instanceof Window) {
                Window window = (Window)((Object)modalParticipant2);
                window.toFront();
                window.requestFocusInWindow();
            }
        }
    }

    @Override
    public void addParticipant(ModalParticipant modalParticipant, boolean bl) {
        this.fParticipants.put(new Integer(modalParticipant.hashCode()), new WeakReference<ModalParticipant>(modalParticipant));
        this.fModalStack.push(modalParticipant, bl);
    }

    @Override
    public void removeParticipant(ModalParticipant modalParticipant) {
        this.fParticipants.remove(new Integer(modalParticipant.hashCode()));
        this.fModalStack.pop(modalParticipant);
    }

    @Override
    public void setParticipantModal(ModalParticipant modalParticipant, boolean bl) {
        if (!this.fParticipants.containsKey(new Integer(modalParticipant.hashCode()))) {
            return;
        }
        if (bl) {
            this.fModalStack.modalize(modalParticipant);
            if (!this.fEventFiltering) {
                Toolkit.getDefaultToolkit().addAWTEventListener(this.fEventListener, 131128L);
                this.fEventFiltering = true;
            }
        } else {
            this.fModalStack.demodalize(modalParticipant);
            if (this.fEventFiltering && !this.modalExists()) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this.fEventListener);
                this.fEventFiltering = false;
            }
        }
    }

    @Override
    public boolean isAcceptingInput(ModalParticipant modalParticipant) {
        if (!this.fParticipants.containsKey(new Integer(modalParticipant.hashCode()))) {
            return true;
        }
        return this.fModalStack.canKeepFocus(modalParticipant);
    }

    @Override
    public void demodalizeAll() {
        ModalParticipant modalParticipant = this.fModalStack.peek();
        while (modalParticipant != null) {
            modalParticipant.setModal(false);
            modalParticipant = this.fModalStack.peek();
        }
    }

    private boolean isEventFromFocusableParticipant(AWTEvent aWTEvent) {
        Window window;
        boolean bl = true;
        Object object = aWTEvent.getSource();
        if (object instanceof Component && (window = SwingUtilities.getWindowAncestor((Component)object)) instanceof ModalParticipant) {
            bl = this.fModalStack.canKeepFocus((ModalParticipant)((Object)window));
        }
        return bl;
    }

    private class ModalityManagerAWTEventListener
    implements AWTEventListener {
        private ModalityManagerAWTEventListener() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent instanceof InputEvent && !ModalManagerImpl.this.isEventFromFocusableParticipant(aWTEvent)) {
                ((InputEvent)aWTEvent).consume();
            }
        }
    }
}

