/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.checkboxtree;

import com.mathworks.mwswing.MJTree;
import com.mathworks.mwswing.checkboxtree.CheckBoxTreeCellRenderer;
import com.mathworks.mwswing.checkboxtree.CheckBoxTreeListener;
import com.mathworks.mwswing.checkboxtree.CheckBoxTreeUtils;
import com.mathworks.mwswing.checkboxtree.Selectable;
import com.mathworks.mwswing.checkboxtree.SelectionState;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class CheckBoxTree
extends MJTree {
    private final boolean fParentsReflectChildren;
    private boolean fReadOnly;

    public CheckBoxTree(TreeModel treeModel) {
        this(treeModel, true);
    }

    public CheckBoxTree(TreeModel treeModel, boolean bl) {
        this(treeModel, bl, new DefaultTreeCellRenderer());
    }

    public CheckBoxTree(TreeModel treeModel, boolean bl, TreeCellRenderer treeCellRenderer) {
        this(treeModel, bl, treeCellRenderer, null);
    }

    public CheckBoxTree(TreeModel treeModel, boolean bl, TreeCellRenderer treeCellRenderer, TreeCellRenderer treeCellRenderer2) {
        super(treeModel);
        super.setCellRenderer(new CheckBoxTreeCellRenderer(treeCellRenderer));
        this.fParentsReflectChildren = bl;
        if (bl) {
            CheckBoxTreeUtils.synchronizeNodes(this.getModel());
        }
        this.setEditable(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!CheckBoxTree.this.fReadOnly) {
                    int n = CheckBoxTree.this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (n == -1) {
                        return;
                    }
                    CheckBoxTree.this.toggleRowSelectionState(n);
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "toggleCheckBox");
        this.getActionMap().put("toggleCheckBox", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CheckBoxTree.this.fReadOnly && CheckBoxTree.this.getSelectionPath() != null) {
                    CheckBoxTree.this.toggleRowSelectionState(CheckBoxTree.this.getRowForPath(CheckBoxTree.this.getSelectionPath()));
                }
            }
        });
    }

    @Override
    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        super.setCellRenderer(new CheckBoxTreeCellRenderer(treeCellRenderer));
    }

    public void setReadOnly(boolean bl) {
        CheckBoxTreeCellRenderer checkBoxTreeCellRenderer = (CheckBoxTreeCellRenderer)this.getCellRenderer();
        checkBoxTreeCellRenderer.setEnabled(!bl);
        this.fReadOnly = bl;
        this.repaint();
    }

    @Override
    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
        if (this.fParentsReflectChildren) {
            CheckBoxTreeUtils.synchronizeNodes(this.getModel());
        }
    }

    public void addCheckBoxListener(CheckBoxTreeListener checkBoxTreeListener) {
        this.listenerList.add(CheckBoxTreeListener.class, checkBoxTreeListener);
    }

    public void removeCheckBoxListener(CheckBoxTreeListener checkBoxTreeListener) {
        this.listenerList.remove(CheckBoxTreeListener.class, checkBoxTreeListener);
    }

    private void notifyCheckBoxListeners(Set set) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CheckBoxTreeListener.class) continue;
            ((CheckBoxTreeListener)objectArray[i + 1]).itemsChanged(set);
        }
    }

    public void setShowDefaultIcons(boolean bl) {
        CheckBoxTreeCellRenderer checkBoxTreeCellRenderer = (CheckBoxTreeCellRenderer)this.getCellRenderer();
        checkBoxTreeCellRenderer.setShowDefaultIcons(bl);
        this.repaint();
    }

    void updateRelatives(Selectable selectable) {
        assert (this.fParentsReflectChildren) : "wrong state";
        HashSet<Selectable> hashSet = new HashSet<Selectable>();
        hashSet.add(selectable);
        this.updateChildren(selectable, hashSet);
        this.updateParents(selectable, hashSet);
        this.notifyCheckBoxListeners(hashSet);
        this.repaint();
    }

    private void updateChildren(Object object, Set<Selectable> set) {
        assert (this.fParentsReflectChildren) : "wrong state";
        if (!this.getModel().isLeaf(object)) {
            if (object instanceof Selectable && ((Selectable)object).getSelectionState() != SelectionState.MIXED) {
                Selectable selectable = (Selectable)object;
                for (int i = 0; i < this.getModel().getChildCount(object); ++i) {
                    Object object2 = this.getModel().getChild(object, i);
                    if (!(object2 instanceof Selectable) || ((Selectable)object2).getSelectionState() == selectable.getSelectionState()) continue;
                    Selectable selectable2 = (Selectable)object2;
                    selectable2.setSelectionState(selectable.getSelectionState());
                    set.add(selectable2);
                }
            }
            for (int i = 0; i < this.getModel().getChildCount(object); ++i) {
                this.updateChildren(this.getModel().getChild(object, i), set);
            }
        }
    }

    private void updateParents(Object object, Set<Selectable> set) {
        assert (this.fParentsReflectChildren) : "wrong state";
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.getModel().getRoot());
        this.computePathToRoot(arrayList, object, this.getModel().getRoot());
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Object e = arrayList.get(i);
            if (!(e instanceof Selectable) || !CheckBoxTreeUtils.updateParentBasedOnChildren(this.getModel(), e)) continue;
            set.add((Selectable)e);
        }
    }

    private boolean computePathToRoot(List<Object> list, Object object, Object object2) {
        boolean bl = false;
        if (object == object2) {
            list.remove(object);
            bl = true;
        } else if (!this.getModel().isLeaf(object2)) {
            for (int i = 0; i < this.getModel().getChildCount(object2); ++i) {
                Object object3 = this.getModel().getChild(object2, i);
                list.add(object3);
                if (this.computePathToRoot(list, object, object3)) {
                    bl = true;
                    break;
                }
                list.remove(object3);
            }
        }
        return bl;
    }

    private void testClickRow(int n) {
        this.toggleRowSelectionState(n);
    }

    private void toggleRowSelectionState(int n) {
        Object object;
        TreePath treePath = this.getPathForRow(n);
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof Selectable) {
            Selectable selectable = (Selectable)object;
            SelectionState selectionState = selectable.getSelectionState();
            ((Selectable)object).setSelectionState(selectionState == SelectionState.NOT_SELECTED ? SelectionState.SELECTED : SelectionState.NOT_SELECTED);
            if (this.fParentsReflectChildren) {
                this.updateRelatives(selectable);
            } else {
                this.notifyCheckBoxListeners(Collections.singleton(object));
            }
            this.repaint();
        }
    }

    public boolean isParentsReflectChildren() {
        return this.fParentsReflectChildren;
    }
}

