/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.checkboxlist;

import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.checkboxlist.CheckBoxList;
import com.mathworks.mwswing.checkboxlist.DefaultListCheckModel;
import com.mathworks.mwswing.checkboxlist.ListCheckModel;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class CheckBoxListCellRenderer
extends MJCheckBox
implements ListCellRenderer {
    private static final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);

    public CheckBoxListCellRenderer() {
        this.setOpaque(true);
        this.setBorder(NO_FOCUS_BORDER);
        this.setBorderPainted(true);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        CheckBoxList checkBoxList = (CheckBoxList)jList;
        this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
        this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
        this.setText(object.toString());
        this.setSelected(checkBoxList.isIndexChecked(n));
        ListCheckModel listCheckModel = checkBoxList.getCheckModel();
        this.setEnabled(!(listCheckModel instanceof DefaultListCheckModel) || !((DefaultListCheckModel)listCheckModel).exceedsLimit(n));
        Border border = null;
        if (bl2 && !PlatformInfo.isMacintosh()) {
            if (bl) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = NO_FOCUS_BORDER;
        }
        this.setBorder(border);
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        dimension.height = fontMetrics.getAscent() + fontMetrics.getDescent() + 4;
        return dimension;
    }
}

