/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.binding;

import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.binding.CustomKeyBindingSet;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingSet;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.util.LanguageUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public class TestActionUtils {
    private TestActionUtils() {
    }

    public static void checkActionProperties(KeyBindingManager keyBindingManager, ExtendedAction extendedAction, String string, String string2, char c, KeyStroke keyStroke, String string3, Icon icon) {
        TestActionUtils.checkActionProperties(keyBindingManager.getAllSetsForPlatform(), keyBindingManager, extendedAction, string, string2, c, keyStroke == null ? null : new KeyStrokeList(keyStroke), string3, icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkActionProperties(Collection<KeyBindingSet> collection, KeyBindingManager keyBindingManager, ExtendedAction extendedAction, String string, String string2, char c, KeyStrokeList keyStrokeList, String string3, Icon icon) {
        KeyBindingSet keyBindingSet = keyBindingManager.getCurrentKeyBindingSet();
        try {
            boolean bl = true;
            for (KeyBindingSet keyBindingSet2 : collection) {
                boolean bl2 = TestActionUtils.isNotInKeyBindingManager(keyBindingManager, keyBindingSet2);
                try {
                    keyBindingManager.setCurrentKeyBindingSet(keyBindingSet2.getID());
                    boolean bl3 = true;
                    if (!PlatformInfo.isMacintosh()) {
                        bl3 = c == (Integer)extendedAction.getValue("MnemonicKey");
                        TestActionUtils.printErrorMessage(bl3, "Mnemonic", keyBindingSet2, c, extendedAction.getValue("MnemonicKey"));
                    }
                    boolean bl4 = TestActionUtils.checkActionProperties(keyBindingSet2, extendedAction, string, string2, keyStrokeList, string3, icon);
                    bl = bl && bl3 && bl4;
                }
                finally {
                    if (!bl2) continue;
                    keyBindingManager.removeCustomKeyBindingSet(keyBindingSet2.getID());
                }
            }
            if (!bl) {
                throw new IllegalStateException("Error was found in checkActionProperties for action '" + string + "'.");
            }
        }
        finally {
            keyBindingManager.setCurrentKeyBindingSet(keyBindingSet.getID());
        }
    }

    private static boolean isNotInKeyBindingManager(KeyBindingManager keyBindingManager, KeyBindingSet keyBindingSet) {
        if (keyBindingSet instanceof CustomKeyBindingSet && !keyBindingManager.containsCustomKeyBindingSet(keyBindingSet.getID())) {
            keyBindingManager.addCustomKeyBindingSet((CustomKeyBindingSet)keyBindingSet);
            return true;
        }
        return false;
    }

    private static boolean checkActionProperties(KeyBindingSet keyBindingSet, ExtendedAction extendedAction, String string, String string2, KeyStrokeList keyStrokeList, String string3, Icon icon) {
        boolean bl;
        boolean bl2 = true;
        if (LanguageUtils.isEnglish()) {
            if (string != null) {
                bl = string.equals(extendedAction.getName());
                TestActionUtils.printErrorMessage(bl, "Name", keyBindingSet, string, extendedAction.getName());
                bl2 = bl;
            }
            if (string2 != null) {
                bl = KeyStrokeUtils.appendShortcut(string2, extendedAction).equals(extendedAction.getTip());
                TestActionUtils.printErrorMessage(bl, "Tooltip", keyBindingSet, string2, extendedAction.getTip());
                boolean bl3 = bl2 = bl2 && bl;
            }
        }
        if (keyStrokeList == null) {
            bl = TestActionUtils.verifyNoSingleStrokeBinding(extendedAction, keyBindingSet) && TestActionUtils.verifyNoMultiStrokeBinding(extendedAction, keyBindingSet);
        } else if (!keyStrokeList.isMultiStroke()) {
            bl = keyStrokeList.toKeyStrokeArray()[0].equals(extendedAction.getAccelerator());
            TestActionUtils.printErrorMessage(bl, "Keystroke", keyBindingSet, keyStrokeList.toKeyStrokeArray()[0], extendedAction.getAccelerator());
            bl = bl && TestActionUtils.verifyNoMultiStrokeBinding(extendedAction, keyBindingSet);
        } else {
            bl = TestActionUtils.verifyNoSingleStrokeBinding(extendedAction, keyBindingSet);
            if (bl) {
                bl = new KeyStrokeList(extendedAction.getAcceleratorSequence()).equals(keyStrokeList);
                TestActionUtils.printErrorMessage(bl, "Multi-stroke keybinding", keyBindingSet, keyStrokeList, new KeyStrokeList(extendedAction.getAcceleratorSequence()));
            }
        }
        boolean bl4 = string3.equals(extendedAction.getComponentName());
        TestActionUtils.printErrorMessage(bl4, "Component", keyBindingSet, string3, extendedAction.getComponentName());
        boolean bl5 = icon == null && extendedAction.getButtonOnlyIcon() == null || icon != null && icon.toString().equals(extendedAction.getButtonOnlyIcon().toString());
        TestActionUtils.printErrorMessage(bl5, "Icon", keyBindingSet, icon, extendedAction.getButtonOnlyIcon());
        return bl2 && bl && bl4 && bl5;
    }

    private static boolean verifyNoMultiStrokeBinding(ExtendedAction extendedAction, KeyBindingSet keyBindingSet) {
        boolean bl = extendedAction.getAcceleratorSequence() == null;
        TestActionUtils.printErrorMessage(bl, "Multi-stroke keybinding", keyBindingSet, null, extendedAction.getAcceleratorSequence());
        return bl;
    }

    private static boolean verifyNoSingleStrokeBinding(ExtendedAction extendedAction, KeyBindingSet keyBindingSet) {
        boolean bl = extendedAction.getAccelerator() == null;
        TestActionUtils.printErrorMessage(bl, "Keystroke", keyBindingSet, null, extendedAction.getAccelerator());
        return bl;
    }

    public static void checkActionPropertiesInCurrentSet(KeyBindingManager keyBindingManager, ExtendedAction extendedAction, String string, String string2, KeyStrokeList keyStrokeList, String string3, Icon icon) {
        if (!TestActionUtils.checkActionProperties(keyBindingManager.getCurrentKeyBindingSet(), extendedAction, string, string2, keyStrokeList, string3, icon)) {
            throw new IllegalStateException("Error was found in checkActionProperties for action '" + string + "'.");
        }
    }

    public static void checkInputMap(KeyBindingManager keyBindingManager, InputMap inputMap, String string, KeyStroke keyStroke) {
        TestActionUtils.checkInputMap(keyBindingManager.getAllSetsForPlatform(), keyBindingManager, inputMap, string, keyStroke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkInputMap(Collection<KeyBindingSet> collection, KeyBindingManager keyBindingManager, InputMap inputMap, String string, KeyStroke ... keyStrokeArray) {
        assert (inputMap != null) : "Supplied input map cannot be null";
        KeyBindingSet keyBindingSet = keyBindingManager.getCurrentKeyBindingSet();
        try {
            boolean bl = true;
            for (KeyBindingSet keyBindingSet2 : collection) {
                boolean bl2 = TestActionUtils.isNotInKeyBindingManager(keyBindingManager, keyBindingSet2);
                try {
                    Object object;
                    keyBindingManager.setCurrentKeyBindingSet(keyBindingSet2.getID());
                    if (keyStrokeArray.length > 1) {
                        assert (inputMap instanceof ExtendedInputMap) : "Multi-stroke keybindings must be in an ExtendedMap";
                        object = ((ExtendedInputMap)((Object)inputMap)).get(keyStrokeArray);
                    } else {
                        object = inputMap.get(keyStrokeArray[0]);
                    }
                    boolean bl3 = string.equals(object);
                    TestActionUtils.printErrorMessage(bl3, "InputMap", keyBindingSet2, string, object);
                    bl = bl && bl3;
                }
                finally {
                    if (!bl2) continue;
                    keyBindingManager.removeCustomKeyBindingSet(keyBindingSet2.getID());
                }
            }
            if (!bl) {
                throw new IllegalStateException("Error was found in testInputMaps for action '" + string + "'.");
            }
        }
        finally {
            keyBindingManager.setCurrentKeyBindingSet(keyBindingSet.getID());
        }
    }

    public static MJAbstractAction createDummyAction(KeyBindingManager keyBindingManager, String string, String string2) {
        MJAbstractAction mJAbstractAction = new MJAbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        keyBindingManager.addKeyBindingAndActionInfo(string2, string, mJAbstractAction);
        return mJAbstractAction;
    }

    private static void printErrorMessage(boolean bl, String string, KeyBindingSet keyBindingSet, Object object, Object object2) {
        if (!bl) {
            System.out.println(string + " is wrong for set '" + keyBindingSet.getID() + "'. Expected '" + object + "' but got '" + object2 + "'.");
        }
    }
}

