/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.NarrowBevelBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class MJStatusBar
extends MJPanel {
    protected Field fMainField;
    private Box fWestBox;
    private Box fEastBox;
    private static final int X_MARGIN = 4;
    private static final int FIELD_GAP = 2;
    private static final int MAIN_FIELD_MIN_WIDTH = 20;
    private static final String BLANK = " ";
    private static final Border BEVEL = new NarrowBevelBorder(1, UIManager.getColor("controlLtHighlight"), UIManager.getColor("controlShadow"));
    private static final Field TEST_FIELD = new Field("Test String", 20, true);

    public MJStatusBar() {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 2));
        this.fMainField = new Field(BLANK, 20, false){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height += this.getBevelBorderHeightDifference();
                return dimension;
            }
        };
        super.add((Component)this.fMainField, "Center");
    }

    public void addTextPropertyListener(PropertyChangeListener propertyChangeListener) {
        this.fMainField.addPropertyChangeListener("text", propertyChangeListener);
    }

    public void removeTextPropertyListener(PropertyChangeListener propertyChangeListener) {
        this.fMainField.removePropertyChangeListener("text", propertyChangeListener);
    }

    public boolean isBlank() {
        return MJStatusBar.isBlank(this.fMainField.getText());
    }

    public static boolean isBlank(String string) {
        return string == null || string.length() == 0 || BLANK.equals(string);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, this.getLargestComponentHeight());
    }

    private int getLargestComponentHeight() {
        int n = MJStatusBar.TEST_FIELD.getPreferredSize().height;
        for (Component component : this.getComponents()) {
            Dimension dimension = component.getPreferredSize();
            if (dimension.height <= n) continue;
            n = dimension.height;
        }
        return n;
    }

    @Override
    public Component add(Component component) {
        this.add(component, "East");
        return component;
    }

    @Override
    public Component add(String string, Component component) {
        if (component != null) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    @Override
    public Component add(Component component, int n) {
        if (component != null) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    @Override
    public void add(Component component, Object object, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Component component, Object object) {
        if (object == null) {
            object = "East";
        }
        if (object == "East" || object.equals("East")) {
            if (this.fEastBox == null) {
                this.fEastBox = Box.createHorizontalBox();
                super.add((Component)this.fEastBox, "East");
            } else if (this.fEastBox.getComponentCount() > 0 && !(this.fEastBox.getComponent(this.fEastBox.getComponentCount() - 1) instanceof Box.Filler)) {
                this.fEastBox.add(Box.createHorizontalStrut(2));
            }
            this.fEastBox.add(component);
        } else if (object == "West" || object.equals("West")) {
            if (this.fWestBox == null) {
                this.fWestBox = Box.createHorizontalBox();
                super.add((Component)this.fWestBox, "West");
            } else if (this.fWestBox.getComponentCount() > 0 && !(this.fWestBox.getComponent(this.fWestBox.getComponentCount() - 1) instanceof Box.Filler)) {
                this.fWestBox.add(Box.createHorizontalStrut(2));
            }
            this.fWestBox.add(component);
        } else {
            throw new IllegalArgumentException("cannot add component: constraint must be BorderLayout.EAST or BorderLayout.WEST (or null)");
        }
    }

    @Override
    public void remove(Component component) {
        if (this.fEastBox != null && component.getParent() == this.fEastBox) {
            int n = Arrays.asList(this.fEastBox.getComponents()).indexOf(component);
            this.fEastBox.remove(n);
            if (n > 0 && this.fEastBox.getComponent(n - 1) instanceof Box.Filler) {
                this.fEastBox.remove(n - 1);
            }
        } else if (this.fWestBox != null && component.getParent() == this.fWestBox) {
            int n = Arrays.asList(this.fWestBox.getComponents()).indexOf(component);
            this.fWestBox.remove(n);
            if (n > 0 && this.fWestBox.getComponent(n - 1) instanceof Box.Filler) {
                this.fWestBox.remove(n - 1);
            }
        }
    }

    @Override
    public void remove(int n) {
        throw new UnsupportedOperationException();
    }

    public void clearText() {
        this.fMainField.setText(BLANK);
    }

    public void setText(String string) {
        if (string == null) {
            string = BLANK;
        }
        this.fMainField.setText(string, false);
    }

    public String getText() {
        String string = this.fMainField.getText();
        return BLANK.equals(string) ? null : string;
    }

    public static class LabeledField
    extends MJPanel {
        private Field[] fValueFields;

        public LabeledField(String string, int n, boolean bl) {
            this(new String[]{string}, new int[]{n}, bl);
        }

        public LabeledField(String[] stringArray, int[] nArray, boolean bl) {
            this.setLayout(new GridBagLayout());
            this.setHasBorder(bl);
            assert (stringArray.length == nArray.length);
            this.fValueFields = new Field[stringArray.length];
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 4, 0, 0);
            for (int i = 0; i < stringArray.length; ++i) {
                MJLabel mJLabel = new MJLabel(stringArray[i]);
                mJLabel.setOpaque(true);
                this.add((Component)mJLabel, gridBagConstraints);
                ++gridBagConstraints.gridx;
                this.fValueFields[i] = new Field(nArray[i], false);
                this.add((Component)this.fValueFields[i], gridBagConstraints);
                ++gridBagConstraints.gridx;
            }
        }

        private void setHasBorder(boolean bl) {
            if (bl) {
                this.setBorder(BEVEL);
            } else if (this.getBorder() != null) {
                this.setBorder(null);
            }
        }

        public void setValue(int n, String string) {
            assert (n < this.fValueFields.length);
            this.fValueFields[n].setText(string);
        }

        public void setValue(int n, int n2) {
            this.setValue(n, Integer.toString(n2));
        }
    }

    public static class Field
    extends MJLabel {
        private int fMinWidth;
        private int fFixedWidth;
        private static final Border MARGINS = BorderFactory.createEmptyBorder(0, 4, 0, 0);
        private static final Border MARGINS_AND_BEVEL = BorderFactory.createCompoundBorder(MJStatusBar.access$000(), MARGINS);

        public Field(String string, int n, boolean bl) {
            super(string);
            this.setOpaque(true);
            this.setHasBorder(bl);
            this.fMinWidth = n;
        }

        public Field(int n, boolean bl) {
            this.setOpaque(true);
            this.setHasBorder(bl);
            this.fFixedWidth = n;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension dimension = this.getPreferredSize();
            dimension.height = 1000;
            return dimension;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (this.fFixedWidth != 0) {
                dimension.width = this.fFixedWidth;
            } else if (this.fMinWidth != 0 && this.fMinWidth > dimension.width) {
                dimension.width = this.fMinWidth;
            } else if (this.getBorder() != null) {
                dimension.width += this.getBorder().getBorderInsets((Component)this).right + this.getBorder().getBorderInsets((Component)this).left;
            }
            dimension.height += 5;
            return dimension;
        }

        private void setHasBorder(boolean bl) {
            if (bl) {
                this.setBorder(MARGINS_AND_BEVEL);
            } else {
                this.setBorder(MARGINS);
            }
        }

        protected int getBevelBorderHeightDifference() {
            Insets insets = MARGINS_AND_BEVEL.getBorderInsets(this);
            Insets insets2 = MARGINS.getBorderInsets(this);
            return insets.top + insets.bottom - insets2.top - insets2.bottom;
        }
    }
}

