/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.AppearanceFocusDispatcher;
import com.mathworks.mwswing.AppearanceFocusEvent;
import com.mathworks.mwswing.AppearanceFocusListener;
import com.mathworks.mwswing.CellViewerCustomizer;
import com.mathworks.mwswing.CellViewerUtils;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.DefaultListCellViewerCustomizer;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.PropertySafetyListener;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;

public class MJList
extends JList
implements CellViewerCustomizer<Integer> {
    protected boolean fRightSelectionEnabled;
    protected MouseDragGestureRecognizer fDragRecognizer;
    protected int fSuppressedIndex = -1;
    private boolean fIsSelectionLocked;
    private CellViewerUtils.Context fCellViewerContext;
    private ListDataListener fModelSafetyListener;
    private ListSelectionListener fSelectionSafetyListener;
    private CellViewerCustomizer<Integer> fDefaultCellViewerCustomizer;
    private static Dimension sCellViewerOffset = new Dimension();
    private boolean fDragSelectionEnabled = false;
    private boolean fSelectionAppearanceReflectsFocus = true;
    private Color fSaveSelectionBackground;
    private Color fSaveSelectionForeground;
    private static AppearanceFocusDispatcher sAppearanceFocusDispatcher = new AppearanceFocusDispatcher();

    public MJList() {
        this.initialize();
    }

    public MJList(ListModel listModel) {
        super(listModel);
        this.initialize();
    }

    public MJList(Object[] objectArray) {
        super(objectArray);
        this.initialize();
    }

    public MJList(Vector<?> vector) {
        super(vector);
        this.initialize();
    }

    private void initialize() {
        this.addSelfListeners();
    }

    private void addSelfListeners() {
        this.fDefaultCellViewerCustomizer = new DefaultListCellViewerCustomizer(this);
        LocalMouseListener localMouseListener = new LocalMouseListener();
        this.addMouseListener(localMouseListener);
        this.addMouseMotionListener(localMouseListener);
        if (this.fSelectionAppearanceReflectsFocus) {
            this.addFocusListener(sAppearanceFocusDispatcher);
        }
        if (MJUtilities.threadingChecksEnabled()) {
            this.fModelSafetyListener = new ModelSafetyListener();
            this.fSelectionSafetyListener = new SelectionSafetyListener();
            this.getModel().addListDataListener(this.fModelSafetyListener);
            this.getSelectionModel().addListSelectionListener(this.fSelectionSafetyListener);
            this.addPropertyChangeListener(new PropertySafetyListener(this));
        }
    }

    public void setRightSelectionEnabled(boolean bl) {
        this.fRightSelectionEnabled = bl;
    }

    public boolean isRightSelectionEnabled() {
        return this.fRightSelectionEnabled;
    }

    public void setDragSelectionEnabled(boolean bl) {
        this.fDragSelectionEnabled = bl;
    }

    public boolean isDragSelectionEnabled() {
        return this.fDragSelectionEnabled;
    }

    public void setCellViewerEnabled(boolean bl) {
        if (bl && this.fCellViewerContext == null) {
            this.fCellViewerContext = CellViewerUtils.installCellViewer(this);
        } else {
            this.fCellViewerContext.uninstall();
            this.fCellViewerContext = null;
        }
    }

    public boolean isCellViewerEnabled() {
        return this.fCellViewerContext != null;
    }

    public void setSelectionAppearanceReflectsFocus(boolean bl) {
        if (bl && !this.fSelectionAppearanceReflectsFocus) {
            this.addFocusListener(sAppearanceFocusDispatcher);
        } else if (!bl && this.fSelectionAppearanceReflectsFocus) {
            this.removeFocusListener(sAppearanceFocusDispatcher);
        }
        this.fSelectionAppearanceReflectsFocus = bl;
    }

    public boolean selectionAppearanceReflectsFocus() {
        return this.fSelectionAppearanceReflectsFocus;
    }

    public void setModel(ListModel listModel) {
        if (this.fModelSafetyListener != null) {
            ListModel listModel2 = this.getModel();
            listModel2.removeListDataListener(this.fModelSafetyListener);
            if (listModel != null) {
                listModel.addListDataListener(this.fModelSafetyListener);
            }
        }
        super.setModel(listModel);
    }

    @Override
    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (this.fSelectionSafetyListener != null) {
            ListSelectionModel listSelectionModel2 = this.getSelectionModel();
            listSelectionModel2.removeListSelectionListener(this.fSelectionSafetyListener);
            listSelectionModel.addListSelectionListener(this.fSelectionSafetyListener);
        }
        super.setSelectionModel(listSelectionModel);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        if (mouseListener instanceof MouseDragGestureRecognizer) {
            this.fDragRecognizer = (MouseDragGestureRecognizer)mouseListener;
        }
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        if (mouseListener == this.fDragRecognizer) {
            this.fDragRecognizer = null;
            this.fSuppressedIndex = -1;
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        this.processMouseEventImpl(mouseEvent);
    }

    public void processMouseEventImpl(MouseEvent mouseEvent) {
        int n;
        if (this.fCellViewerContext != null) {
            mouseEvent = this.fCellViewerContext.adjustMouseEvent(mouseEvent);
        }
        if (this.fDragRecognizer != null) {
            n = mouseEvent.getID();
            if (n == 501) {
                int n2 = this.locationToIndex(mouseEvent.getPoint());
                int n3 = mouseEvent.getModifiers();
                if ((n3 & 0x10) != 0 && this.getSelectionMode() != 0 && this.getSelectedIndices().length > 1 && this.isSelectedIndex(n2)) {
                    this.fIsSelectionLocked = true;
                    this.fSuppressedIndex = n2;
                } else {
                    this.fSuppressedIndex = -1;
                }
            } else if (n == 502 && this.fSuppressedIndex != -1) {
                MJUtilities.handleMouseReleased(mouseEvent, this.fSuppressedIndex, this.getSelectionModel());
                this.fSuppressedIndex = -1;
            }
        }
        if (PlatformInfo.isMacintosh() && mouseEvent.isPopupTrigger() && SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isShiftDown() && this.getSelectionModel().getSelectionMode() != 0) {
            n = this.locationToIndex(mouseEvent.getPoint());
            this.fIsSelectionLocked = n != -1 && this.isSelectedIndex(n);
        }
        super.processMouseEvent(mouseEvent);
        this.fIsSelectionLocked = false;
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.fDragRecognizer != null && mouseEvent.getID() == 506) {
            this.fDragRecognizer.mouseDragged(mouseEvent);
        } else if (mouseEvent.getID() == 506 && this.fDragSelectionEnabled) {
            Rectangle rectangle;
            if (!this.fRightSelectionEnabled && MJUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            int n = this.locationToIndex(mouseEvent.getPoint());
            if (n != -1 && (rectangle = this.getCellBounds(n, n)) != null && rectangle.contains(mouseEvent.getPoint())) {
                int n2 = this.getAnchorSelectionIndex();
                this.removeSelectionInterval(n2, this.getLeadSelectionIndex());
                this.addSelectionInterval(n2, n);
                this.ensureIndexIsVisible(n);
            }
        } else {
            super.processMouseMotionEvent(mouseEvent);
        }
    }

    @Override
    public Component getCellPainter(Integer n) {
        return this.fDefaultCellViewerCustomizer.getCellPainter(n);
    }

    @Override
    public Dimension getCellViewerOffset(Integer n) {
        return this.fDefaultCellViewerCustomizer.getCellViewerOffset(n);
    }

    @Override
    public boolean shouldShowCellViewer(Integer n) {
        return this.fDefaultCellViewerCustomizer.shouldShowCellViewer(n);
    }

    @Override
    public boolean constrainViewerToCellHeight() {
        return this.fDefaultCellViewerCustomizer.constrainViewerToCellHeight();
    }

    private void setSaveSelectionBackground(Color color) {
        this.fSaveSelectionBackground = color;
    }

    private void setSaveSelectionForeground(Color color) {
        this.fSaveSelectionForeground = color;
    }

    private Color getSaveSelectionForeground() {
        return this.fSaveSelectionForeground;
    }

    private Color getSaveSelectionBackground() {
        return this.fSaveSelectionBackground;
    }

    @Override
    public void setSelectionBackground(Color color) {
        if (this.fSaveSelectionBackground == null) {
            super.setSelectionBackground(color);
        } else {
            this.fSaveSelectionBackground = color;
        }
    }

    @Override
    public void setSelectionForeground(Color color) {
        if (this.fSaveSelectionForeground == null) {
            super.setSelectionForeground(color);
        } else {
            this.fSaveSelectionForeground = color;
        }
    }

    @Override
    public void addSelectionInterval(int n, int n2) {
        if (!this.fIsSelectionLocked) {
            super.addSelectionInterval(n, n2);
        }
    }

    @Override
    public void clearSelection() {
        if (!this.fIsSelectionLocked) {
            super.clearSelection();
        }
    }

    @Override
    public void removeSelectionInterval(int n, int n2) {
        if (!this.fIsSelectionLocked) {
            super.removeSelectionInterval(n, n2);
        }
    }

    @Override
    public void setSelectionInterval(int n, int n2) {
        if (!this.fIsSelectionLocked) {
            super.setSelectionInterval(n, n2);
        }
    }

    static {
        sAppearanceFocusDispatcher.addAppearanceFocusListener(new ListAppearanceFocusListener());
    }

    static class ListAppearanceFocusListener
    implements AppearanceFocusListener {
        ListAppearanceFocusListener() {
        }

        @Override
        public void appearanceFocusLost(AppearanceFocusEvent appearanceFocusEvent) {
            if (appearanceFocusEvent.getComponent() instanceof MJList) {
                MJList mJList = (MJList)appearanceFocusEvent.getComponent();
                mJList.setSaveSelectionBackground(null);
                mJList.setSaveSelectionForeground(null);
                Color color = mJList.getSelectionBackground();
                Color color2 = mJList.getSelectionForeground();
                mJList.setSelectionBackground(ColorUtils.getUnfocusedSelectionBackgroundColor(mJList));
                mJList.setSelectionForeground(ColorUtils.getUnfocusedSelectionForegroundColor(mJList));
                mJList.setSaveSelectionBackground(color);
                mJList.setSaveSelectionForeground(color2);
                mJList.repaint();
            }
        }

        @Override
        public void appearanceFocusGained(AppearanceFocusEvent appearanceFocusEvent) {
            if (appearanceFocusEvent.getComponent() instanceof MJList) {
                Color color;
                MJList mJList = (MJList)appearanceFocusEvent.getComponent();
                if (mJList.getSaveSelectionBackground() != null) {
                    color = mJList.getSaveSelectionBackground();
                    mJList.setSaveSelectionBackground(null);
                    mJList.setSelectionBackground(color);
                }
                if (mJList.getSaveSelectionForeground() != null) {
                    color = mJList.getSaveSelectionForeground();
                    mJList.setSaveSelectionForeground(null);
                    mJList.setSelectionForeground(color);
                }
                mJList.repaint();
            }
        }
    }

    private class SelectionSafetyListener
    implements ListSelectionListener {
        private SelectionSafetyListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (MJList.this.isShowing()) {
                MJUtilities.assertIsEventThread();
            }
        }
    }

    private class ModelSafetyListener
    implements ListDataListener {
        private ModelSafetyListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            if (MJList.this.isShowing()) {
                MJUtilities.assertIsEventThread();
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            if (MJList.this.isShowing()) {
                MJUtilities.assertIsEventThread();
            }
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            if (MJList.this.isShowing()) {
                MJUtilities.assertIsEventThread();
            }
        }
    }

    private class LocalMouseListener
    extends MouseInputAdapter {
        private LocalMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!MJList.this.isEnabled()) {
                return;
            }
            boolean bl = MJUtilities.isRightMouseButton(mouseEvent);
            if (!MJList.this.isRightSelectionEnabled() || !bl) {
                return;
            }
            int n = MJList.this.locationToIndex(mouseEvent.getPoint());
            if (n == -1 || MJList.this.isSelectedIndex(n)) {
                return;
            }
            int n2 = MJList.this.getAnchorSelectionIndex();
            if (mouseEvent.isControlDown()) {
                MJList.this.addSelectionInterval(n, n);
            } else if (mouseEvent.isShiftDown() && n2 != -1) {
                MJList.this.setSelectionInterval(n2, n);
            } else if (!MJList.this.isSelectedIndex(n)) {
                MJList.this.setSelectionInterval(n, n);
            }
        }
    }
}

