/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.FileExtensionFilter;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.api.FileExtensionFilterContributor;
import com.mathworks.util.osgi.ClasspathOSGiManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FileExtensionFilterUtils {
    private static final FileExtensionFilter M_FILE_FILTER = new FileExtensionFilter(MJUtilities.intlString("filter.MFiles"), "m", true);
    private static final FileExtensionFilter MAT_FILE_FILTER = new FileExtensionFilter(MJUtilities.intlString("filter.Mat"), "mat", true);
    private static final FileExtensionFilter FIG_FILE_FILTER = new FileExtensionFilter(MJUtilities.intlString("filter.Fig"), "fig", true);
    private static final FileExtensionFilter SIMSCAPE_FILE_FILTER = new FileExtensionFilter(MJUtilities.intlString("filter.Simscape"), "ssc", true);
    private static final FileExtensionFilter RTW_FILTER = new FileExtensionFilter(MJUtilities.intlString("filter.RTW"), Arrays.asList("rtw", "tlc", "tmf", "c", "cpp", "h", "mk", "vhd", "v"), true);

    private FileExtensionFilterUtils() {
    }

    public static FileExtensionFilter getMatlabProductFilter() {
        return FileExtensionFilterUtils.createMatlabProductFilter(FileExtensionFilterUtils.getFileExtensionContributors(), Collections.emptySet());
    }

    public static FileExtensionFilter getCoreMatlabProductFilter() {
        return FileExtensionFilterUtils.createMatlabProductFilter(FileExtensionFilterUtils.getFileExtensionContributors(), Collections.singleton(FileExtensionFilterContributor.FileFilterPriority.CORE_PRODUCT));
    }

    private static Collection<FileExtensionFilterContributor> getFileExtensionContributors() {
        return ClasspathOSGiManager.getInstance().getImplementors(FileExtensionFilterContributor.class);
    }

    public static FileExtensionFilter createMatlabProductFilter(Collection<FileExtensionFilterContributor> collection, Set<FileExtensionFilterContributor.FileFilterPriority> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (FileExtensionFilterContributor fileExtensionFilterContributor : collection) {
            if (!set.isEmpty() && !set.contains((Object)fileExtensionFilterContributor.getPriority())) continue;
            hashSet.addAll(fileExtensionFilterContributor.getProductFilterExtensions());
        }
        ArrayList arrayList = new ArrayList(hashSet);
        return new FileExtensionFilter(MJUtilities.intlString("filter.MATLAB"), arrayList, !set.isEmpty());
    }

    public static List<FileExtensionFilter> getFileExtensionFilters() {
        return FileExtensionFilterUtils.sortFileExtensionFilters(FileExtensionFilterUtils.getFileExtensionContributors());
    }

    public static List<FileExtensionFilter> sortFileExtensionFilters(Collection<FileExtensionFilterContributor> collection) {
        ArrayList<List<FileExtensionFilter>> arrayList = new ArrayList<List<FileExtensionFilter>>();
        ArrayList<List<FileExtensionFilter>> arrayList2 = new ArrayList<List<FileExtensionFilter>>();
        for (FileExtensionFilterContributor object : collection) {
            if (object.getDialogFilters().isEmpty()) continue;
            if (object.getPriority() == FileExtensionFilterContributor.FileFilterPriority.CORE_PRODUCT) {
                arrayList.add(object.getDialogFilters());
                continue;
            }
            arrayList2.add(object.getDialogFilters());
        }
        Collections.sort(arrayList, FileExtensionFilterUtils.createFileExtensionFilterListComparator());
        Collections.sort(arrayList2, FileExtensionFilterUtils.createFileExtensionFilterListComparator());
        ArrayList arrayList3 = new ArrayList();
        arrayList3.add(FileExtensionFilterUtils.getMatlabProductFilter());
        for (List list : arrayList) {
            arrayList3.addAll(list);
        }
        for (List list : arrayList2) {
            arrayList3.addAll(list);
        }
        return arrayList3;
    }

    public static FileExtensionFilter getMatlabFileFilter() {
        return M_FILE_FILTER;
    }

    public static FileExtensionFilter getSimscapeFileFilter() {
        return SIMSCAPE_FILE_FILTER;
    }

    public static FileExtensionFilter getMatFileFilter() {
        return MAT_FILE_FILTER;
    }

    public static FileExtensionFilter getFigFileFilter() {
        return FIG_FILE_FILTER;
    }

    public static FileExtensionFilter getCodeGenFileFilter() {
        return RTW_FILTER;
    }

    private static Comparator<List<FileExtensionFilter>> createFileExtensionFilterListComparator() {
        return new Comparator<List<FileExtensionFilter>>(){

            @Override
            public int compare(List<FileExtensionFilter> list, List<FileExtensionFilter> list2) {
                return list.get(0).getDescription().compareTo(list2.get(0).getDescription());
            }
        };
    }
}

