/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.CellViewer;
import com.mathworks.mwswing.CellViewerCustomizer;
import com.mathworks.mwswing.TableCell;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JTable;

public class DefaultTableCellViewerCustomizer
implements CellViewerCustomizer<TableCell> {
    private final JTable fTable;

    public DefaultTableCellViewerCustomizer(JTable jTable) {
        this.fTable = jTable;
    }

    @Override
    public Component getCellPainter(TableCell tableCell) {
        int n = this.fTable.getColumnModel().getColumn(tableCell.getColumn()).getModelIndex();
        return this.fTable.getCellRenderer(tableCell.getRow(), tableCell.getColumn()).getTableCellRendererComponent(this.fTable, this.fTable.getModel().getValueAt(tableCell.getRow(), n), this.fTable.isCellSelected(tableCell.getRow(), tableCell.getColumn()), false, tableCell.getRow(), tableCell.getColumn());
    }

    @Override
    public Dimension getCellViewerOffset(TableCell tableCell) {
        return new Dimension(0, 0);
    }

    @Override
    public boolean shouldShowCellViewer(TableCell tableCell) {
        Rectangle rectangle = this.fTable.getVisibleRect();
        Rectangle rectangle2 = this.fTable.getCellRect(tableCell.getRow(), tableCell.getColumn(), false);
        Component component = this.getCellPainter(tableCell);
        Dimension dimension = component.getPreferredSize();
        int n = component instanceof JLabel ? ((JLabel)component).getHorizontalAlignment() : 2;
        return CellViewer.shouldShow(rectangle, rectangle2, dimension, n);
    }

    @Override
    public boolean constrainViewerToCellHeight() {
        return true;
    }
}

