/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.ColorUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class ContrastingIcon
implements Icon {
    private Icon fLightIcon;
    private Icon fDarkIcon;
    private URL fLightIconURL;
    private URL fDarkIconURL;

    public ContrastingIcon(Icon icon, Icon icon2) {
        this.fLightIcon = icon;
        this.fDarkIcon = icon2;
    }

    public ContrastingIcon(URL uRL, URL uRL2) {
        this.fLightIconURL = uRL;
        this.fDarkIconURL = uRL2;
    }

    @Override
    public int getIconWidth() {
        Icon icon = this.getReferenceIcon();
        return icon == null ? 0 : icon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        Icon icon = this.getReferenceIcon();
        return icon == null ? 0 : icon.getIconHeight();
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.getContrastingIcon().paintIcon(component, graphics, n, n2);
    }

    public Icon getLightIcon() {
        if (this.fLightIcon == null && this.fLightIconURL != null) {
            this.fLightIcon = new ImageIcon(this.fLightIconURL);
        }
        return this.fLightIcon;
    }

    public Icon getDarkIcon() {
        if (this.fDarkIcon == null && this.fDarkIconURL != null) {
            this.fDarkIcon = new ImageIcon(this.fDarkIconURL);
        }
        return this.fDarkIcon;
    }

    protected Color getBackground() {
        return UIManager.getColor("control");
    }

    protected Icon getContrastingIcon() {
        return ColorUtils.isDark(this.getBackground()) ? this.getLightIcon() : this.getDarkIcon();
    }

    private Icon getReferenceIcon() {
        if (this.fDarkIcon != null) {
            return this.fDarkIcon;
        }
        if (this.fLightIcon != null) {
            return this.fLightIcon;
        }
        return this.getContrastingIcon();
    }
}

