/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.lmlogin;

import com.mathworks.lmlogin.BlockingValidationStrategy;
import com.mathworks.lmlogin.DescribeEntitlementsException;
import com.mathworks.lmlogin.EntitlementDialogCreator;
import com.mathworks.lmlogin.ErrorCodes;
import com.mathworks.lmlogin.INUEntitlementRetriever;
import com.mathworks.lmlogin.LicenseManagerLoginValidationStrategy;
import com.mathworks.lmlogin.LicenseManagerResponseObject;
import com.mathworks.lmlogin.LmLoginResourceKey;
import com.mathworks.webservices.mls.model.Entitlement;
import com.mathworks.widgets.login.CompletionStatus;
import com.mathworks.widgets.login.ValidationStrategy;
import com.mathworks.widgets.login.ValidationWorkFlow;
import com.mathworks.widgets.login.WorkFlowReturn;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JOptionPane;

final class LicenseManagerLogin {
    private BlockingValidationStrategy validationStrategy = new LicenseManagerLoginValidationStrategy();
    private ValidationWorkFlow validationWorkFlow = new ValidationWorkFlow((ValidationStrategy)this.validationStrategy);
    private CompletionStatus completionStatus = null;
    private WorkFlowReturn workFlowReturn;
    private LicenseManagerResponseObject licenseManagerResponseObject = null;
    private INUEntitlementRetriever entitlementRetriever = new INUEntitlementRetriever();
    private Dimension dim;

    public CompletionStatus startWorkflow() {
        this.validationWorkFlow.startWorkFlow();
        try {
            this.validationStrategy.awaitComplete();
        }
        catch (InterruptedException interruptedException) {
            this.validationWorkFlow.cancelWorkFlow();
        }
        this.workFlowReturn = this.validationStrategy.getWorkFlowReturn();
        this.completionStatus = this.workFlowReturn.getCompletionStatus();
        return this.completionStatus;
    }

    public LicenseManagerResponseObject getLicenseManagerResponseObject() {
        if (this.completionStatus.equals((Object)CompletionStatus.SUCCEEDED)) {
            this.dim = this.validationStrategy.getPreferredSize();
            this.successfulCompletion();
        } else {
            this.createErrorDialog(ErrorCodes.LOGIN_UNSUCCESSFUL.getErrorCode(), LmLoginResourceKey.LOGIN_GENERIC_ERROR.getString(new Object[0]));
        }
        return this.licenseManagerResponseObject;
    }

    private void successfulCompletion() {
        String string = this.workFlowReturn.getLoginResponse().getToken();
        try {
            List<Entitlement> list = this.entitlementRetriever.getEntitlements(string);
            if (list.size() == 1) {
                this.createSuccessfulResponseObject(string, list.get(0).getId());
            } else if (list.size() == 0) {
                this.createDialogWhenZeroEntitlements(string);
            } else if (list.size() > 1) {
                EntitlementDialogCreator entitlementDialogCreator = new EntitlementDialogCreator(list, this.dim);
                entitlementDialogCreator.display();
                if (!entitlementDialogCreator.hasSelectedEntitlement()) {
                    this.createCancelledResponseObject();
                } else {
                    String string2 = entitlementDialogCreator.getSelectedEntitlement();
                    this.createSuccessfulResponseObject(string, string2);
                }
            }
        }
        catch (DescribeEntitlementsException describeEntitlementsException) {
            this.createErrorDialog(describeEntitlementsException.getErrorCode(), describeEntitlementsException.getMessage());
        }
        catch (Exception exception) {
            this.createErrorDialog(ErrorCodes.DIALOG_GENERIC_EXCEPTION.getErrorCode(), LmLoginResourceKey.LOGIN_GENERIC_ERROR.getString(new Object[0]));
        }
    }

    private void createDialogWhenZeroEntitlements(String string) {
        Object[] objectArray = new Object[]{LmLoginResourceKey.ACTIVATION_ERROR_ACTIVATE_BUTTON.getString(new Object[0]), LmLoginResourceKey.ACTIVATION_ERROR_CANCEL_BUTTON.getString(new Object[0])};
        int n = JOptionPane.showOptionDialog(null, LmLoginResourceKey.ACTIVATION_ERROR_MESSAGE.getString(new Object[0]), LmLoginResourceKey.ACTIVATION_ERROR_TITLE.getString(new Object[0]), 1, 0, null, objectArray, objectArray[1]);
        if (n == 0) {
            this.createActivateResponseObject(string);
        } else if (n == 1) {
            this.createCancelledResponseObject();
        }
    }

    private void createErrorDialog(String string, String string2) {
        JOptionPane.showMessageDialog(null, string2 + System.getProperty("line.separator") + LmLoginResourceKey.LOGIN_GENERIC_ERROR_SUPPORT.getString(string), LmLoginResourceKey.ACTIVATION_ERROR_TITLE.getString(new Object[0]), 0);
        this.licenseManagerResponseObject = new LicenseManagerResponseObject("", "", 1);
    }

    private void createActivateResponseObject(String string) {
        this.licenseManagerResponseObject = new LicenseManagerResponseObject(string, "", 2);
    }

    private void createSuccessfulResponseObject(String string, String string2) {
        this.licenseManagerResponseObject = new LicenseManagerResponseObject(string, string2, 0);
    }

    private void createCancelledResponseObject() {
        this.licenseManagerResponseObject = new LicenseManagerResponseObject("", "", -1);
    }
}

