/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.hadoop;

import com.mathworks.mvm.MVM;
import com.mathworks.mvm.MvmFactory;
import com.mathworks.mvm.MvmSession;
import com.mathworks.mvm.exec.MvmExecutionException;
import com.mathworks.toolbox.parallel.hadoop.MatlabConfiguration;
import com.mathworks.toolbox.parallel.hadoop.MatlabFailureException;
import com.mathworks.toolbox.parallel.hadoop.MatlabStartupFailureException;
import com.mathworks.toolbox.parallel.hadoop.SerializationUtils;
import com.mathworks.toolbox.parallel.hadoop.TaskUtils;
import com.mathworks.toolbox.parallel.mapreduce.PairSocket;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobID;

class MvmSingleton {
    private MvmSession fMvmSession = null;
    private MvmFactory fMvmFactory = null;
    private MVM fMVM = null;
    private static MvmSingleton sInstance = null;
    private static final String YARN_LOG_DIR_PROPERTY_NAME = "yarn.app.container.log.dir";
    private static final String HADOOP_LOG_BASE_DIR_PROPERTY_NAME = "hadoop.log.dir";
    private static final String HADOOP_USERLOGS_DIR_NAME = "userlogs";
    private static final String MATLAB_OUTLOG_FILE = "matlab.out";
    private static String WORKER_CLOSE_FUNCTION = "parallel.internal.hadoop.evaluateClose";

    public static void initialize(Configuration conf, JobID jobID) throws IOException, InterruptedException {
        assert (sInstance == null);
        MvmSingleton.throwIfWindowsPlatform();
        MvmSingleton.throwIfInvalidHomeDir();
        System.setProperty("java.awt.headless", "true");
        try {
            PairSocket.initializeNativeLibrary();
        }
        catch (UnsatisfiedLinkError e) {
            throw new MatlabStartupFailureException("parallel:mapreduce:HadoopTaskCouldNotFindMatlab", new String[0]);
        }
        MvmSingleton instance = new MvmSingleton();
        instance.doInitialize(conf, jobID);
        sInstance = instance;
    }

    public static MVM getMVM() {
        return sInstance == null ? null : MvmSingleton.sInstance.fMVM;
    }

    private void doInitialize(Configuration configuration, JobID jobID) throws IOException, InterruptedException {
        this.addMATLABShutdownHook();
        MvmSession.SessionOptions sessionOptions = new MvmSession.SessionOptions();
        sessionOptions.fDisableLocalMVM = true;
        this.fMvmSession = MvmSession.createSession((MvmSession.SessionOptions)sessionOptions);
        MvmFactory.FactoryOptions options = new MvmFactory.FactoryOptions(new String[]{"-dmlworker", "-logfile", new File(this.getLogDir(jobID), MATLAB_OUTLOG_FILE).toString()});
        this.fMvmFactory = MvmFactory.createFactory((MvmFactory.FactoryType)MvmFactory.FactoryType.MATLABMVM, (String)"Worker", (MvmFactory.FactoryOptions)options);
        this.fMVM = this.fMvmFactory.createMVM();
        this.configureWorker(configuration, jobID);
    }

    private static void throwIfWindowsPlatform() {
        if (TaskUtils.isWindowsPlatform()) {
            throw new MatlabStartupFailureException("parallel:mapreduce:HadoopTaskWindowsUnsupported", new String[0]);
        }
    }

    private static void throwIfInvalidHomeDir() {
        String homeEnvironmentVariable = System.getenv("HOME");
        if (homeEnvironmentVariable == null || homeEnvironmentVariable.isEmpty()) {
            throw new MatlabStartupFailureException("parallel:mapreduce:HadoopTaskInvalidHome", "");
        }
        File homeDirectory = new File(homeEnvironmentVariable);
        if (!homeDirectory.exists() || !homeDirectory.canWrite()) {
            throw new MatlabStartupFailureException("parallel:mapreduce:HadoopTaskInvalidHome", homeEnvironmentVariable);
        }
    }

    private void addMATLABShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    MvmSingleton.this.closeWorker();
                    MvmSingleton.this.fMVM = null;
                    if (MvmSingleton.this.fMvmFactory != null) {
                        MvmSingleton.this.fMvmFactory.terminate();
                        MvmSingleton.this.fMvmFactory = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (MvmSingleton.this.fMvmSession != null) {
                    MvmSingleton.this.fMvmSession.close();
                    MvmSingleton.this.fMvmSession = null;
                }
            }
        });
    }

    private void closeWorker() {
        if (this.fMVM == null) {
            return;
        }
        try {
            this.fMVM.feval(WORKER_CLOSE_FUNCTION, new Object[0]).get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void configureWorker(Configuration configuration, JobID jobID) throws IOException, InterruptedException {
        try {
            MatlabConfiguration matlabConfiguration = new MatlabConfiguration(configuration);
            String confJarFile = Configuration.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            this.fMVM.feval(matlabConfiguration.getConfigureFunction(), new Object[]{confJarFile, matlabConfiguration.getHadoopVersion(), System.getProperty("java.io.tmpdir"), this.getLogDir(jobID), SerializationUtils.serializeConfiguration(configuration)}).get();
        }
        catch (MvmExecutionException e) {
            throw MatlabFailureException.wrapException(e);
        }
    }

    private String getLogDir(JobID jobID) throws IOException {
        File logDir;
        boolean folderExists;
        File logDir2;
        boolean folderExists2;
        String yarnContainerLogDir = System.getProperty(YARN_LOG_DIR_PROPERTY_NAME);
        if (yarnContainerLogDir != null && (folderExists2 = MvmSingleton.ensurePathExists(logDir2 = new File(yarnContainerLogDir)))) {
            return logDir2.toString();
        }
        String hadoopLogDir = System.getProperty(HADOOP_LOG_BASE_DIR_PROPERTY_NAME);
        if (hadoopLogDir != null && (folderExists = MvmSingleton.ensurePathExists(logDir = new File(new File(hadoopLogDir, HADOOP_USERLOGS_DIR_NAME), jobID.toString())))) {
            return logDir.toString();
        }
        return new File(".").getCanonicalPath().toString();
    }

    private static boolean ensurePathExists(File path) {
        if (path.exists()) {
            return true;
        }
        return path.mkdirs();
    }

    private MvmSingleton() {
    }
}

