/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.hadoop;

import com.mathworks.mvm.MVM;
import com.mathworks.mvm.exec.FutureFevalResult;
import com.mathworks.mvm.exec.MvmExecutionException;
import com.mathworks.toolbox.parallel.hadoop.MatlabConfiguration;
import com.mathworks.toolbox.parallel.hadoop.MatlabFailureException;
import com.mathworks.toolbox.parallel.hadoop.MatlabOutputFormat;
import com.mathworks.toolbox.parallel.hadoop.MvmSingleton;
import com.mathworks.toolbox.parallel.hadoop.SerializationUtils;
import com.mathworks.toolbox.parallel.hadoop.TaskUtils;
import com.mathworks.toolbox.parallel.mapreduce.Endpoint;
import com.mathworks.toolbox.parallel.mapreduce.HadoopTaskAttemptID;
import com.mathworks.toolbox.parallel.mapreduce.KeyValueMessage;
import com.mathworks.toolbox.parallel.mapreduce.KeyValueSocket;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

class MatlabReducer
extends Reducer<BytesWritable, BytesWritable, Void, Void> {
    private MatlabConfiguration fConfig;
    private HadoopTaskAttemptID fTaskAttemptID;
    private MVM fMVM;
    private KeyValueSocket fKeyValueSocket;
    private String fOutputFolder;
    private String fFinalOutputFolder;

    MatlabReducer() {
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        TaskUtils.throwIfOutputFolderDoesNotExist((TaskAttemptContext)context);
        Configuration conf = context.getConfiguration();
        this.fConfig = new MatlabConfiguration(conf);
        this.fTaskAttemptID = TaskUtils.convertTaskAttemptID(context.getTaskAttemptID());
        this.fOutputFolder = MatlabOutputFormat.getWorkOutputPath((TaskInputOutputContext)context).toString();
        this.fFinalOutputFolder = MatlabOutputFormat.getOutputPath((JobContext)context).toString();
        if (MvmSingleton.getMVM() == null) {
            try {
                MvmSingleton.initialize(conf, context.getJobID());
            }
            catch (Exception e) {
                TaskUtils.handleMatlabStartupException(e, this.fTaskAttemptID, this.fFinalOutputFolder, conf);
            }
        }
        this.fMVM = MvmSingleton.getMVM();
        this.fKeyValueSocket = new KeyValueSocket();
    }

    protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
        this.fKeyValueSocket.close();
    }

    private Endpoint bindEndpoint() throws IOException {
        Endpoint endpoint = new Endpoint("ipc://ml_" + this.fTaskAttemptID.toString());
        this.fKeyValueSocket.bind(endpoint);
        return endpoint;
    }

    private FutureFevalResult launchMatlab(Endpoint endpoint) throws IOException {
        return this.fMVM.feval(this.fConfig.getReducerFunction(), new Object[]{endpoint.toString(), this.fTaskAttemptID.toString(), this.fOutputFolder, this.fFinalOutputFolder, SerializationUtils.serializeConfiguration(this.fConfig.toConfiguration())});
    }

    private void reduce(Reducer.Context context) throws IOException, InterruptedException {
        Endpoint endpoint = this.bindEndpoint();
        FutureFevalResult future = this.launchMatlab(endpoint);
        try {
            while (context.nextKey()) {
                this.sendKey((BytesWritable)context.getCurrentKey(), (Future)future);
                for (BytesWritable value : context.getValues()) {
                    this.sendValue(value, (Future)future);
                }
            }
            this.sendClose((Future)future);
            this.recvClose((Future)future);
        }
        catch (MatlabFinishedEarlyException e) {
            // empty catch block
        }
        try {
            future.get();
        }
        catch (MvmExecutionException e) {
            throw MatlabFailureException.wrapException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Reducer.Context context) throws IOException, InterruptedException {
        this.setup(context);
        try {
            this.reduce(context);
        }
        finally {
            this.cleanup(context);
        }
    }

    private void doSend(KeyValueMessage message, Future future) throws IOException {
        while (!future.isDone()) {
            if (!this.fKeyValueSocket.send(message, 1000L, TimeUnit.MILLISECONDS)) continue;
            return;
        }
        throw new MatlabFinishedEarlyException();
    }

    private void sendKey(BytesWritable key, Future future) throws IOException {
        ByteBuffer keyBuffer = ByteBuffer.wrap(key.getBytes());
        keyBuffer.limit(key.getLength());
        this.doSend(KeyValueMessage.createKeyMessage((ByteBuffer)keyBuffer), future);
    }

    private void sendValue(BytesWritable value, Future future) throws IOException {
        ByteBuffer valueBuffer = ByteBuffer.wrap(value.getBytes());
        valueBuffer.limit(value.getLength());
        this.doSend(KeyValueMessage.createValueMessage((ByteBuffer)valueBuffer), future);
    }

    private void sendClose(Future future) throws IOException {
        this.doSend(KeyValueMessage.createCloseMessage(), future);
    }

    private void recvClose(Future future) throws IOException {
        while (!future.isDone()) {
            KeyValueMessage message = this.fKeyValueSocket.recv(1000L, TimeUnit.MILLISECONDS);
            if (message == null) continue;
            return;
        }
    }

    private static class MatlabFinishedEarlyException
    extends IOException {
        private MatlabFinishedEarlyException() {
        }
    }
}

