/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.search;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.DocumentationQuery;
import com.mathworks.helpsearch.facets.DocFacet;
import com.mathworks.helpsearch.facets.Facetable;
import com.mathworks.html.FileUrl;
import java.util.EnumMap;
import java.util.Map;

public class LocalDocSearchPage {
    private final String fSearchString;
    private final Map<DocFacet, String> fFacets = new EnumMap<DocFacet, String>(DocFacet.class);
    private final int fPageNum;

    private LocalDocSearchPage(String string, Map<DocFacet, String> map, int n) {
        this.fSearchString = string;
        this.fFacets.putAll(map);
        this.fPageNum = n;
    }

    public static LocalDocSearchPage fromSearchResultsPage(FileUrl fileUrl) {
        String string = fileUrl.getParameterValue("qdoc");
        String string2 = fileUrl.getParameterValue("page");
        int n = LocalDocSearchPage.getPageNum(string2);
        DocumentationQuery documentationQuery = new DocumentationQuery(string, ContentFormat.DOC_CENTER_DOC);
        return LocalDocSearchPage.fromDocumentationQuery(documentationQuery, n);
    }

    private static int getPageNum(String string) {
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Throwable throwable) {
                return 1;
            }
        }
        return 1;
    }

    public static LocalDocSearchPage fromDocumentationQuery(DocumentationQuery documentationQuery, int n) {
        return new LocalDocSearchPage(documentationQuery.getSearchText(), documentationQuery.getFacets(), n);
    }

    public DocumentationQuery getQuery() {
        return new DocumentationQuery(this.fSearchString, this.fFacets);
    }

    public int getPageNum() {
        return this.fPageNum;
    }

    LocalDocSearchPage getModifiedCopy(int n) {
        return new LocalDocSearchPage(this.fSearchString, this.fFacets, n);
    }

    LocalDocSearchPage getModifiedCopy(Facetable facetable) {
        return this.getModifiedCopy(facetable.getFacetType(), facetable.getFacetId());
    }

    LocalDocSearchPage getModifiedCopy(DocFacet docFacet, String string) {
        Map<DocFacet, String> map = this.cloneFacets();
        if (string == null) {
            map.remove(docFacet);
        } else {
            map.put(docFacet, string);
        }
        return new LocalDocSearchPage(this.fSearchString, map, this.fPageNum);
    }

    private Map<DocFacet, String> cloneFacets() {
        if (this.fFacets == null || this.fFacets.isEmpty()) {
            return new EnumMap<DocFacet, String>(DocFacet.class);
        }
        return new EnumMap<DocFacet, String>(this.fFacets);
    }
}

