/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.json;

import com.mathworks.help.helpui.json.JsonEntity;
import com.mathworks.help.helpui.json.JsonPrimitive;
import com.mathworks.help.helpui.json.JsonString;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsonObject
extends JsonEntity {
    private final Map<String, JsonEntity> fJsonProperties = new LinkedHashMap<String, JsonEntity>();

    public void addJsonProperty(String string, JsonEntity jsonEntity) {
        this.fJsonProperties.put(string, jsonEntity);
    }

    public void addStringProperty(String string, String string2) {
        this.fJsonProperties.put(string, new JsonString(string2));
    }

    public void addBooleanProperty(String string, boolean bl) {
        this.addPrimitiveProperty(string, new JsonPrimitive(bl));
    }

    public void addIntProperty(String string, int n) {
        this.addPrimitiveProperty(string, new JsonPrimitive(n));
    }

    public void addPrimitiveProperty(String string, JsonPrimitive jsonPrimitive) {
        this.fJsonProperties.put(string, jsonPrimitive);
    }

    @Override
    public String getJsonString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        for (Map.Entry<String, JsonEntity> entry : this.fJsonProperties.entrySet()) {
            stringBuilder.append('\"').append(entry.getKey()).append("\":");
            stringBuilder.append(entry.getValue().getJsonString()).append(',');
        }
        if (!this.fJsonProperties.isEmpty()) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public String getPropertyJsonString(String string) {
        JsonEntity jsonEntity = this.fJsonProperties.get(string);
        return jsonEntity == null ? null : ((Object)jsonEntity).toString();
    }

    public boolean isEmpty() {
        return this.fJsonProperties.isEmpty();
    }
}

