/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.addon;

import com.mathworks.help.helpui.DocRoot;
import com.mathworks.help.helpui.addon.DocAddOnLinkPage;
import com.mathworks.help.helpui.json.JsonArray;
import com.mathworks.help.helpui.json.JsonEntity;
import com.mathworks.help.helpui.json.JsonObject;
import com.mathworks.helpsearch.HelpLocation;
import com.mathworks.helpsearch.product.DocAddOn;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.Url;
import com.mathworks.html.WebUrl;
import java.util.ArrayList;
import java.util.Collection;

public class InstalledDocDocAddOnLinkPage
implements DocAddOnLinkPage {
    private final HtmlComponent fHtmlComponent;
    private final DocRoot<? extends Url> fDefaultDocUrlBuilder;
    private final Collection<DocAddOn> fDocAddOns = new ArrayList<DocAddOn>();
    private final DocRoot<WebUrl> fWebDocUrlBuilder;
    private final DocProduct fDocProduct;

    public InstalledDocDocAddOnLinkPage(HtmlComponent htmlComponent, DocRoot<? extends Url> docRoot, Collection<DocAddOn> collection, DocRoot<WebUrl> docRoot2, DocProduct docProduct) {
        this.fHtmlComponent = htmlComponent;
        this.fDefaultDocUrlBuilder = docRoot;
        this.fDocAddOns.addAll(collection);
        this.fWebDocUrlBuilder = docRoot2;
        this.fDocProduct = docProduct;
    }

    private JsonEntity getInstalledJson() {
        JsonArray jsonArray = new JsonArray();
        if (!this.fDocAddOns.isEmpty()) {
            for (DocAddOn docAddOn : this.fDocAddOns) {
                JsonEntity jsonEntity = this.getAddOnJson((DocSetItem)docAddOn);
                jsonArray.addEntity(jsonEntity);
            }
        }
        return jsonArray;
    }

    private JsonEntity getAddOnJson(DocSetItem docSetItem) {
        String string = docSetItem.getDisplayName();
        String string2 = this.getLocation(docSetItem.getHelpLocation());
        JsonObject jsonObject = new JsonObject();
        jsonObject.addStringProperty("displayname", string);
        jsonObject.addStringProperty("helplocation", string2);
        return jsonObject;
    }

    private String getLocation(HelpLocation helpLocation) {
        assert (helpLocation != null) : "HelpLocation is null, cannot create installed link.";
        Url url = this.fDefaultDocUrlBuilder.buildHelpLocationUrl(helpLocation);
        return url.toUrlBuilder().append(new String[]{"index.html"}).toString();
    }

    private JsonEntity getWebJson() {
        WebUrl webUrl = this.fWebDocUrlBuilder.buildDocSetItemLandingPageUrl((DocSetItem)this.fDocProduct);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addStringProperty("displayname", "Hardware Support Packages");
        jsonObject.addStringProperty("helplocation", webUrl.toString());
        return jsonObject;
    }

    @Override
    public void displayHspLinks() {
        JsonEntity jsonEntity = this.getInstalledJson();
        JsonEntity jsonEntity2 = this.getWebJson();
        this.fHtmlComponent.executeScript(String.format("populateInstalledLinks(%s);", jsonEntity.getJsonString()));
        this.fHtmlComponent.executeScript(String.format("populateWebLink(%s);", jsonEntity2.getJsonString()));
    }
}

