/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui;

import com.mathworks.help.helpui.DocUrlNavigationRule;
import com.mathworks.help.helpui.DocUrlType;
import com.mathworks.helpsearch.index.LocaleFileLocator;
import com.mathworks.helpsearch.index.LocalizedFileLocator;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.Url;
import com.mathworks.html.UrlBuilder;
import com.mathworks.html.UrlReplacer;
import com.mathworks.html.WebUrl;
import java.io.File;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;

public class LocalizationDocUrlRule
implements DocUrlNavigationRule {
    private final Map<DocUrlType, Locale> fLocaleMap = new EnumMap<DocUrlType, Locale>(DocUrlType.class);

    public LocalizationDocUrlRule(Locale locale) {
        this(locale, null);
    }

    public LocalizationDocUrlRule(Locale locale, Locale locale2) {
        for (DocUrlType docUrlType : DocUrlType.values()) {
            this.fLocaleMap.put(docUrlType, locale);
        }
        Locale locale3 = locale2 != null ? locale2 : locale;
        this.fLocaleMap.put(DocUrlType.GLOBAL_LANDING_PAGE, locale3);
    }

    @Override
    public <T extends Url> void apply(UrlBuilder<T> urlBuilder, DocUrlType docUrlType) {
        Locale locale;
        Url url;
        Url url2 = urlBuilder.toUrl();
        if (docUrlType != DocUrlType.SEARCH && LocalizationDocUrlRule.needsLocalization(url2) && (url = new LocalizeTransformer(this.getLocalizedFileLocator(locale = this.fLocaleMap.get((Object)docUrlType))).transformUrl(url2)) != null) {
            urlBuilder.rewrite(url, EnumSet.of(Url.UrlPart.BASE));
        }
    }

    @Override
    public <T extends Url> void remove(UrlBuilder<T> urlBuilder, DocUrlType docUrlType) {
        Locale locale;
        Url url;
        if (urlBuilder.getType() == Url.UrlType.FILE && docUrlType != DocUrlType.SEARCH && (url = new UnlocalizeTransformer(this.getLocalizedFileLocator(locale = this.fLocaleMap.get((Object)docUrlType))).transformUrl(urlBuilder.toUrl())) != null) {
            urlBuilder.rewrite(url, EnumSet.of(Url.UrlPart.BASE));
        }
    }

    protected LocalizedFileLocator getLocalizedFileLocator(Locale locale) {
        return new LocaleFileLocator(locale);
    }

    private static boolean needsLocalization(Url url) {
        if (url.getType() == Url.UrlType.FILE) {
            String string = url.getParameterValue("lang");
            return string == null || !string.equalsIgnoreCase("en");
        }
        return false;
    }

    private static class UnlocalizeTransformer
    extends UrlReplacer {
        private final LocalizedFileLocator iLocator;

        private UnlocalizeTransformer(LocalizedFileLocator localizedFileLocator) {
            this.iLocator = localizedFileLocator;
        }

        protected FileUrl transformFileUrl(FileUrl fileUrl) {
            File file = fileUrl.getFile();
            String string = this.iLocator.getUnlocalizedFileName(file.getName());
            if (!string.equals(file.getName())) {
                File file2 = new File(file.getParentFile(), string);
                return new FileUrl(file2, fileUrl.getParameters(), fileUrl.getTarget());
            }
            return null;
        }

        protected WebUrl transformWebUrl(WebUrl webUrl) {
            return webUrl;
        }

        protected CustomProtocolUrl transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
            return customProtocolUrl;
        }
    }

    private static class LocalizeTransformer
    extends UrlReplacer {
        private final LocalizedFileLocator iLocator;

        private LocalizeTransformer(LocalizedFileLocator localizedFileLocator) {
            this.iLocator = localizedFileLocator;
        }

        protected FileUrl transformFileUrl(FileUrl fileUrl) {
            File file = fileUrl.getFile();
            File file2 = this.iLocator.findLocalizedFile(file);
            if (!file2.equals(file)) {
                return new FileUrl(file2, fileUrl.getParameters(), fileUrl.getTarget());
            }
            return null;
        }

        protected WebUrl transformWebUrl(WebUrl webUrl) {
            return webUrl;
        }

        protected CustomProtocolUrl transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
            return customProtocolUrl;
        }
    }
}

