/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui;

import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.SearchConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;

public class HelpBrowserSearchConfig
implements SearchConfig {
    private static final String[] MAIN_SEARCH_INDEX_NAMES = new String[]{"helpsearch-v2", "helpsearch"};
    private static final String ADDON_INDEX_NAME = "helpsearch";
    private final File fDocSetDirectory;
    private final Collection<File> fIndexDirectories;
    private final DocLanguage fLanguage;

    public HelpBrowserSearchConfig(DocLanguage docLanguage, File file, Collection<File> collection) {
        this.fDocSetDirectory = file != null && file.exists() && file.isDirectory() ? file : null;
        this.fLanguage = docLanguage;
        this.fIndexDirectories = HelpBrowserSearchConfig.getIndexDirs(docLanguage, file, collection);
    }

    private static Collection<File> getIndexDirs(DocLanguage docLanguage, File file, Collection<File> collection) {
        ArrayList<File> arrayList = new ArrayList<File>(collection.size() + 1);
        for (String string : MAIN_SEARCH_INDEX_NAMES) {
            File file2 = HelpBrowserSearchConfig.getIndexDir(file, string, docLanguage);
            if (file2 == null || !file2.exists() || !file2.isDirectory()) continue;
            arrayList.add(file2);
        }
        for (File file3 : collection) {
            File file4 = HelpBrowserSearchConfig.getIndexDir(file3, ADDON_INDEX_NAME, docLanguage);
            if (file4 == null) continue;
            arrayList.add(file4);
        }
        return arrayList;
    }

    private static File getIndexDir(File file, String string, DocLanguage docLanguage) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            return null;
        }
        if (docLanguage == DocLanguage.ENGLISH) {
            return new File(file, string);
        }
        Locale locale = docLanguage.getLocale();
        String string2 = string + "_" + locale.getLanguage() + "_" + locale.getCountry();
        File file2 = new File(file, string2);
        if (file2.exists() && file2.isDirectory()) {
            return file2;
        }
        return new File(file, string);
    }

    protected File getDocSetDirectory() {
        return this.fDocSetDirectory;
    }

    protected DocLanguage getLanguage() {
        return this.fLanguage;
    }

    public Collection<File> getIndexDirectories() {
        return Collections.unmodifiableCollection(this.fIndexDirectories);
    }
}

