/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui;

import com.mathworks.help.helpui.HelpBrowserComponent;
import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.help.helpui.HelpBrowserWindowListener;
import com.mathworks.html.Url;
import java.awt.Component;
import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class HelpBrowser {
    private final HelpBrowserComponent fHelpBrowserComponent;
    private JFrame fFrame;

    private HelpBrowser(HelpBrowserComponent helpBrowserComponent, JFrame jFrame) {
        assert (SwingUtilities.isEventDispatchThread()) : "HelpBrowser must be created on the EDT.";
        this.fHelpBrowserComponent = helpBrowserComponent;
        this.fFrame = jFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HelpBrowser invoke(String string, boolean bl) {
        assert (string != null) : "HelpBrowser must be invoked with a non-null location.";
        CreateHelpBrowser createHelpBrowser = new CreateHelpBrowser(string, bl);
        try {
            SwingUtilities.invokeAndWait(createHelpBrowser);
        }
        finally {
            return createHelpBrowser.getBrowser();
        }
    }

    public Component getComponent() {
        return this.fHelpBrowserComponent.getPanel();
    }

    public void setCurrentLocation(String string) {
        this.fHelpBrowserComponent.setCurrentLocation(string);
    }

    public void setCurrentLocation(Url url) {
        this.fHelpBrowserComponent.setCurrentLocation(url);
    }

    private void displayHelp() {
        this.fHelpBrowserComponent.displayHelp();
    }

    private static HelpBrowser createAndShowHelpBrowser(String string, boolean bl) {
        JFrame jFrame = new JFrame(HelpBrowserUtils.getString("helpbrowser.title"));
        jFrame.setName("HelpBrowser");
        jFrame.getAccessibleContext().setAccessibleName("HelpBrowser");
        if (bl) {
            jFrame.setDefaultCloseOperation(3);
        } else {
            jFrame.setDefaultCloseOperation(2);
        }
        Image image = HelpBrowser.createFrameImage();
        if (image != null) {
            jFrame.setIconImage(image);
        }
        HelpBrowserComponent helpBrowserComponent = new HelpBrowserComponent(string, true);
        HelpBrowser helpBrowser = new HelpBrowser(helpBrowserComponent, jFrame);
        helpBrowser.displayHelp();
        jFrame.addWindowListener(new HelpBrowserWindowListener(helpBrowser));
        jFrame.setSize(1000, 800);
        jFrame.setLocation(20, 40);
        jFrame.getContentPane().add(helpBrowser.getComponent());
        jFrame.setVisible(true);
        return helpBrowser;
    }

    private static Image createFrameImage() {
        Image image = null;
        String string = HelpBrowserUtils.getString("helpbrowser.toolbar.image.help.small");
        String string2 = HelpBrowserUtils.getString("helpbrowser.toolbar.image.membrane.small");
        URL uRL = HelpBrowserUtils.getImageURL(string);
        URL uRL2 = HelpBrowserUtils.getImageURL(string2);
        if (uRL2 != null && uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL2);
            ImageIcon imageIcon2 = new ImageIcon(uRL);
            image = HelpBrowserUtils.createBadgedImage(imageIcon2, imageIcon, 5, 6, 11, 11);
        }
        return image;
    }

    private synchronized JFrame getFrame() {
        return this.fFrame;
    }

    private synchronized void setFrame(JFrame jFrame) {
        this.fFrame = jFrame;
    }

    private synchronized void disposeFrame() {
        JFrame jFrame = this.getFrame();
        if (jFrame != null) {
            this.getFrame().dispose();
            this.setFrame(null);
        }
    }

    private synchronized void requestFocusInFrame() {
        JFrame jFrame = this.getFrame();
        if (jFrame != null) {
            this.getFrame().setState(0);
            this.getFrame().toFront();
            this.getFrame().requestFocusInWindow();
        }
    }

    public static void main(String[] stringArray) {
        final String string = HelpBrowserUtils.getArgument(stringArray, "location");
        String string2 = HelpBrowserUtils.getArgument(stringArray, "standalone");
        if (string == null) {
            System.err.println("HelpBrowser must be invoked with the documentation location.");
            System.out.println("Usage: com.mathworks.help.helpui.HelpBrowser -location=<doc location> [-standalone=<true|false>]");
            return;
        }
        final boolean bl = string2 != null && string2.equalsIgnoreCase("true");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelpBrowser.createAndShowHelpBrowser(string, bl);
            }
        });
    }

    public boolean isDisposed() {
        return this.getFrame() == null;
    }

    public void dispose() {
        this.fHelpBrowserComponent.dispose();
        if (!this.isDisposed()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HelpBrowser.this.disposeFrame();
                }
            });
        }
    }

    public void requestFocusInWindow() {
        if (!this.isDisposed()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HelpBrowser.this.requestFocusInFrame();
                }
            });
        }
    }

    private static class CreateHelpBrowser
    implements Runnable {
        private final String iLocation;
        private final boolean iStandalone;
        private HelpBrowser iHelpBrowser;

        private CreateHelpBrowser(String string, boolean bl) {
            this.iLocation = string;
            this.iStandalone = bl;
        }

        @Override
        public void run() {
            this.iHelpBrowser = HelpBrowser.createAndShowHelpBrowser(this.iLocation, this.iStandalone);
        }

        private HelpBrowser getBrowser() {
            return this.iHelpBrowser;
        }
    }
}

