/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.bean;

import com.mathworks.jmi.OpaqueJavaInterface;
import com.mathworks.util.jarloader.JarInfo;
import com.mathworks.util.jarloader.SimpleClassLoader;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.Introspector;
import java.io.FileInputStream;

public class BeanFileData {
    private static SimpleClassLoader sBeanClassLoader = SimpleClassLoader.createLoader((String)"HGBeanClassLoader", null);
    private JarInfo fJarInfo = null;
    private int fJarIndex = 0;
    private String fBeanName = null;
    private Class fBeanClass = null;
    private Class fBeanInfoClass = null;

    public BeanFileData(String string, boolean bl) {
        this.fBeanName = string;
        if (bl) {
            this.fBeanClass = BeanFileData.createClassFromFile(string + ".class");
            this.fBeanInfoClass = BeanFileData.createClassFromFile(string + "BeanInfo.class");
        } else {
            try {
                this.fBeanClass = OpaqueJavaInterface.findClass(string);
                this.fBeanInfoClass = null;
            }
            catch (Exception exception) {
                this.fBeanClass = null;
                this.fBeanInfoClass = null;
            }
        }
    }

    public BeanFileData(JarInfo jarInfo, int n) {
        this.fJarInfo = jarInfo;
        this.fJarIndex = n;
        this.fBeanName = jarInfo.getName(n);
    }

    private static Class createClassFromBytes(String string, byte[] byArray) {
        sBeanClassLoader.defineClassFromBytes(string, byArray);
        Class clazz = null;
        try {
            clazz = sBeanClassLoader.loadClass(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz;
    }

    private static Class createClassFromFile(String string) {
        byte[] byArray = null;
        Class clazz = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (byArray != null) {
            clazz = BeanFileData.createClassFromBytes(string, byArray);
        }
        return clazz;
    }

    public String getBeanName() {
        return this.fBeanName;
    }

    public Object getInstance() {
        Object object = null;
        if (this.fJarInfo != null) {
            object = this.fJarInfo.getInstance(this.fBeanName);
        } else if (this.fBeanClass != null) {
            try {
                object = Beans.instantiate((ClassLoader)sBeanClassLoader, this.fBeanName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }

    public BeanInfo getBeanInfo() {
        BeanInfo beanInfo = null;
        if (this.fJarInfo != null) {
            beanInfo = this.fJarInfo.getBeanInfo(this.fJarIndex);
        } else if (this.fBeanClass != null) {
            try {
                beanInfo = Introspector.getBeanInfo(this.fBeanClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return beanInfo;
    }
}

