/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi;

import com.mathworks.jmi.ClassLoaderManager;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class CustomURLClassLoader
extends URLClassLoader {
    private int fDebuggingID;
    private Hashtable<Class<?>, String> fCache;
    private boolean fIsValid = true;
    private int fVerboseLevel = 0;
    private boolean fDoRecordClassCache = false;
    private Vector<String> fNativeLibraryPath = null;
    private boolean fIsLocked = false;

    public void setVerbose(int n) {
        this.fVerboseLevel = n;
    }

    public int getVerboseLevel() {
        return this.fVerboseLevel;
    }

    CustomURLClassLoader(ClassLoader classLoader, URL[] uRLArray, Vector<String> vector, int n, boolean bl, int n2) {
        super(uRLArray, classLoader);
        this.fDebuggingID = n;
        this.fDoRecordClassCache = bl;
        this.fVerboseLevel = n2;
        this.fNativeLibraryPath = vector;
    }

    @Override
    public Class<?> findClass(String string) throws ClassNotFoundException {
        if (this.fVerboseLevel >= 2) {
            System.out.println("Searching for class in file system: " + string);
        }
        if (this.fDoRecordClassCache) {
            return this.findClassWithDiagnostics(string);
        }
        return super.findClass(string);
    }

    public Class<?> findClassWithDiagnostics(String string) throws ClassNotFoundException {
        Class<?> clazz = super.findClass(string);
        if (clazz != null) {
            if (this.fCache == null) {
                this.fCache = new Hashtable(50);
            }
            this.fCache.put(clazz, string);
        }
        return clazz;
    }

    @Override
    public URL findResource(String string) {
        if (this.fVerboseLevel >= 2) {
            System.out.println("findResource: " + string);
        }
        return super.findResource(string);
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        if (this.fVerboseLevel >= 2) {
            System.out.println("getResourceAsStream: " + string);
        }
        return super.getResourceAsStream(string);
    }

    protected void finalize() throws Throwable {
        if (this.fVerboseLevel >= 2) {
            System.out.println("Garbage collected InternetClassLoader. ID: " + this.fDebuggingID);
        }
        super.finalize();
    }

    @Override
    protected String findLibrary(String string) {
        String string2 = System.getProperty("file.separator");
        String string3 = System.mapLibraryName(string);
        if (ClassLoaderManager.getCurrentVerboseLevel() >= 1) {
            System.out.println("FileSystem:findLibrary: " + string3);
        }
        String string4 = null;
        Enumeration<String> enumeration = this.fNativeLibraryPath.elements();
        while (enumeration.hasMoreElements()) {
            String string5 = enumeration.nextElement();
            File file = new File(string5 + string2 + string3);
            if (!file.isFile()) continue;
            string4 = file.getAbsolutePath();
            if (ClassLoaderManager.getCurrentVerboseLevel() >= 1) {
                System.out.println("Loaded native library: " + string3 + " from " + string4);
            }
            this.fIsLocked = true;
            break;
        }
        return string4;
    }

    public boolean isLocked() {
        return false;
    }

    public void setValid(boolean bl) {
        this.fIsValid = bl;
    }

    public boolean isValid() {
        return this.fIsValid;
    }

    public void debugSetDoRecordClassCache(boolean bl) {
        this.fDoRecordClassCache = bl;
    }

    public Hashtable<Class<?>, String> debugGetClassCache() {
        return this.fCache;
    }
}

