/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps.dsc;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSResource;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentDocumentNeededResources;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentDocumentSuppliedResources;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentPageResources;

public class ResourceTracker {
    private Set documentSuppliedResources;
    private Set documentNeededResources;
    private Set usedResources;
    private Set pageResources;
    private Map resourceUsageCounts;

    public Set getDocumentSuppliedResources() {
        if (this.documentSuppliedResources != null) {
            return Collections.unmodifiableSet(this.documentSuppliedResources);
        }
        return Collections.EMPTY_SET;
    }

    public Set getDocumentNeededResources() {
        if (this.documentNeededResources != null) {
            return Collections.unmodifiableSet(this.documentNeededResources);
        }
        return Collections.EMPTY_SET;
    }

    public void notifyStartNewPage() {
        if (this.pageResources != null) {
            this.pageResources.clear();
        }
    }

    public void registerSuppliedResource(PSResource pSResource) {
        if (this.documentSuppliedResources == null) {
            this.documentSuppliedResources = new HashSet();
        }
        this.documentSuppliedResources.add(pSResource);
        if (this.documentNeededResources != null) {
            this.documentNeededResources.remove(pSResource);
        }
    }

    public void registerNeededResource(PSResource pSResource) {
        if (this.documentNeededResources == null) {
            this.documentNeededResources = new HashSet();
        }
        if (!this.documentSuppliedResources.contains(pSResource)) {
            this.documentNeededResources.add(pSResource);
        }
    }

    private void preparePageResources() {
        if (this.pageResources == null) {
            this.pageResources = new HashSet();
        }
    }

    private void prepareUsageCounts() {
        if (this.resourceUsageCounts == null) {
            this.resourceUsageCounts = new HashMap();
        }
    }

    public void notifyResourceUsageOnPage(PSResource pSResource) {
        this.preparePageResources();
        this.pageResources.add(pSResource);
        this.prepareUsageCounts();
        Counter counter = (Counter)this.resourceUsageCounts.get(pSResource);
        if (counter == null) {
            this.resourceUsageCounts.put(pSResource, new Counter());
        } else {
            counter.inc();
        }
    }

    public void notifyResourceUsageOnPage(Collection collection) {
        this.preparePageResources();
        for (PSResource pSResource : collection) {
            this.notifyResourceUsageOnPage(pSResource);
        }
    }

    public boolean isResourceSupplied(PSResource pSResource) {
        return this.documentSuppliedResources != null && this.documentSuppliedResources.contains(pSResource);
    }

    public void writeResources(boolean bl, PSGenerator pSGenerator) throws IOException {
        if (bl) {
            this.writePageResources(pSGenerator);
        } else {
            this.writeDocumentResources(pSGenerator);
        }
    }

    public void writePageResources(PSGenerator pSGenerator) throws IOException {
        new DSCCommentPageResources(this.pageResources).generate(pSGenerator);
        if (this.usedResources == null) {
            this.usedResources = new HashSet();
        }
        this.usedResources.addAll(this.pageResources);
    }

    public void writeDocumentResources(PSGenerator pSGenerator) throws IOException {
        if (this.usedResources != null) {
            for (PSResource pSResource : this.usedResources) {
                if (this.documentSuppliedResources != null && this.documentSuppliedResources.contains(pSResource)) continue;
                this.registerNeededResource(pSResource);
            }
        }
        new DSCCommentDocumentNeededResources(this.documentNeededResources).generate(pSGenerator);
        new DSCCommentDocumentSuppliedResources(this.documentSuppliedResources).generate(pSGenerator);
    }

    public void declareInlined(PSResource pSResource) {
        if (this.documentNeededResources != null) {
            this.documentNeededResources.remove(pSResource);
        }
        if (this.documentSuppliedResources != null) {
            this.documentSuppliedResources.remove(pSResource);
        }
        if (this.pageResources != null) {
            this.pageResources.remove(pSResource);
        }
        if (this.usedResources != null) {
            this.usedResources.remove(pSResource);
        }
    }

    public long getUsageCount(PSResource pSResource) {
        Counter counter = (Counter)this.resourceUsageCounts.get(pSResource);
        return counter != null ? counter.getCount() : 0L;
    }

    private static class Counter {
        private long count = 1L;

        private Counter() {
        }

        public void inc() {
            ++this.count;
        }

        public long getCount() {
            return this.count;
        }

        public String toString() {
            return Long.toString(this.count);
        }
    }
}

