/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlgraphics.java2d.color.ColorUtil;
import org.apache.xmlgraphics.ps.PSGenerator;

public class PSState
implements Serializable {
    public static final String DEFAULT_DASH = "[] 0";
    public static final Color DEFAULT_RGB_COLOR = Color.black;
    private AffineTransform transform = new AffineTransform();
    private List transformConcatList = new ArrayList();
    private int linecap = 0;
    private int linejoin = 0;
    private float miterLimit = 0.0f;
    private double linewidth = 1.0;
    private String dashpattern = "[] 0";
    private Color color = DEFAULT_RGB_COLOR;
    private String fontname;
    private float fontsize;

    public PSState() {
    }

    public PSState(PSState pSState, boolean bl) {
        this.transform = (AffineTransform)pSState.transform.clone();
        if (bl) {
            this.transformConcatList.addAll(pSState.transformConcatList);
        }
        this.linecap = pSState.linecap;
        this.linejoin = pSState.linejoin;
        this.miterLimit = pSState.miterLimit;
        this.linewidth = pSState.linewidth;
        this.dashpattern = pSState.dashpattern;
        this.color = pSState.color;
        this.fontname = pSState.fontname;
        this.fontsize = pSState.fontsize;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public boolean checkTransform(AffineTransform affineTransform) {
        return !affineTransform.equals(this.transform);
    }

    public void concatMatrix(AffineTransform affineTransform) {
        this.transformConcatList.add(affineTransform);
        this.transform.concatenate(affineTransform);
    }

    public boolean useLineCap(int n) {
        if (this.linecap != n) {
            this.linecap = n;
            return true;
        }
        return false;
    }

    public boolean useLineJoin(int n) {
        if (this.linejoin != n) {
            this.linejoin = n;
            return true;
        }
        return false;
    }

    public boolean useMiterLimit(float f) {
        if (this.miterLimit != f) {
            this.miterLimit = f;
            return true;
        }
        return false;
    }

    public boolean useLineWidth(double d) {
        if (this.linewidth != d) {
            this.linewidth = d;
            return true;
        }
        return false;
    }

    public boolean useDash(String string) {
        if (!this.dashpattern.equals(string)) {
            this.dashpattern = string;
            return true;
        }
        return false;
    }

    public boolean useColor(Color color) {
        if (!ColorUtil.isSameColor(this.color, color)) {
            this.color = color;
            return true;
        }
        return false;
    }

    public boolean useFont(String string, float f) {
        if (string == null) {
            throw new NullPointerException("font name must not be null");
        }
        if (this.fontname == null || !this.fontname.equals(string) || this.fontsize != f) {
            this.fontname = string;
            this.fontsize = f;
            return true;
        }
        return false;
    }

    public void reestablish(PSGenerator pSGenerator) throws IOException {
        int n = this.transformConcatList.size();
        for (int i = 0; i < n; ++i) {
            pSGenerator.concatMatrix((AffineTransform)this.transformConcatList.get(i));
        }
        pSGenerator.useLineCap(this.linecap);
        pSGenerator.useLineWidth(this.linewidth);
        pSGenerator.useDash(this.dashpattern);
        pSGenerator.useColor(this.color);
        if (this.fontname != null) {
            pSGenerator.useFont(this.fontname, this.fontsize);
        }
    }
}

