/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.writer.imageio;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.MultiImageWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageIOImageWriter
implements ImageWriter,
IIOWriteWarningListener {
    private static final String STANDARD_METADATA_FORMAT = "javax_imageio_1.0";
    private String targetMIME;

    public ImageIOImageWriter(String string) {
        this.targetMIME = string;
    }

    public void writeImage(RenderedImage renderedImage, OutputStream outputStream) throws IOException {
        this.writeImage(renderedImage, outputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeImage(RenderedImage renderedImage, OutputStream outputStream, ImageWriterParams imageWriterParams) throws IOException {
        javax.imageio.ImageWriter imageWriter = this.getIIOImageWriter();
        imageWriter.addIIOWriteWarningListener(this);
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        try {
            ImageWriteParam imageWriteParam = this.getDefaultWriteParam(imageWriter, renderedImage, imageWriterParams);
            ImageTypeSpecifier imageTypeSpecifier = imageWriteParam.getDestinationType() != null ? imageWriteParam.getDestinationType() : ImageTypeSpecifier.createFromRenderedImage(renderedImage);
            IIOMetadata iIOMetadata = imageWriter.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
            if (imageWriterParams != null && iIOMetadata != null) {
                iIOMetadata = this.updateMetadata(iIOMetadata, imageWriterParams);
            }
            imageWriter.setOutput(imageOutputStream);
            IIOImage iIOImage = new IIOImage(renderedImage, null, iIOMetadata);
            imageWriter.write(null, iIOImage, imageWriteParam);
        }
        finally {
            imageOutputStream.close();
            imageWriter.dispose();
        }
    }

    private javax.imageio.ImageWriter getIIOImageWriter() {
        Iterator<javax.imageio.ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(this.getMIMEType());
        javax.imageio.ImageWriter imageWriter = null;
        if (iterator.hasNext()) {
            imageWriter = iterator.next();
        }
        if (imageWriter == null) {
            throw new UnsupportedOperationException("No ImageIO codec for writing " + this.getMIMEType() + " is available!");
        }
        return imageWriter;
    }

    protected ImageWriteParam getDefaultWriteParam(javax.imageio.ImageWriter imageWriter, RenderedImage renderedImage, ImageWriterParams imageWriterParams) {
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        if (imageWriterParams != null && imageWriterParams.getCompressionMethod() != null) {
            imageWriteParam.setCompressionMode(2);
            imageWriteParam.setCompressionType(imageWriterParams.getCompressionMethod());
        }
        return imageWriteParam;
    }

    protected IIOMetadata updateMetadata(IIOMetadata iIOMetadata, ImageWriterParams imageWriterParams) {
        if (iIOMetadata.isStandardMetadataFormatSupported()) {
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree(STANDARD_METADATA_FORMAT);
            IIOMetadataNode iIOMetadataNode2 = ImageIOImageWriter.getChildNode(iIOMetadataNode, "Dimension");
            if (imageWriterParams.getResolution() != null) {
                IIOMetadataNode iIOMetadataNode3 = ImageIOImageWriter.getChildNode(iIOMetadataNode2, "HorizontalPixelSize");
                if (iIOMetadataNode3 == null) {
                    iIOMetadataNode3 = new IIOMetadataNode("HorizontalPixelSize");
                    iIOMetadataNode2.appendChild(iIOMetadataNode3);
                }
                iIOMetadataNode3.setAttribute("value", Double.toString(imageWriterParams.getResolution().doubleValue() / 25.4));
                iIOMetadataNode3 = ImageIOImageWriter.getChildNode(iIOMetadataNode2, "VerticalPixelSize");
                if (iIOMetadataNode3 == null) {
                    iIOMetadataNode3 = new IIOMetadataNode("VerticalPixelSize");
                    iIOMetadataNode2.appendChild(iIOMetadataNode3);
                }
                iIOMetadataNode3.setAttribute("value", Double.toString(imageWriterParams.getResolution().doubleValue() / 25.4));
            }
            try {
                iIOMetadata.mergeTree(STANDARD_METADATA_FORMAT, iIOMetadataNode);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                throw new RuntimeException("Cannot update image metadata: " + iIOInvalidTreeException.getMessage());
            }
        }
        return iIOMetadata;
    }

    protected static IIOMetadataNode getChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!string.equals(node2.getNodeName())) continue;
            return (IIOMetadataNode)node2;
        }
        return null;
    }

    public String getMIMEType() {
        return this.targetMIME;
    }

    public boolean isFunctional() {
        Iterator<javax.imageio.ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(this.getMIMEType());
        return iterator.hasNext();
    }

    public void warningOccurred(javax.imageio.ImageWriter imageWriter, int n, String string) {
        System.err.println("Problem while writing image using ImageI/O: " + string);
    }

    public MultiImageWriter createMultiImageWriter(OutputStream outputStream) throws IOException {
        return new IIOMultiImageWriter(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsMultiImageWriter() {
        javax.imageio.ImageWriter imageWriter = this.getIIOImageWriter();
        try {
            boolean bl = imageWriter.canWriteSequence();
            return bl;
        }
        finally {
            imageWriter.dispose();
        }
    }

    private class IIOMultiImageWriter
    implements MultiImageWriter {
        private javax.imageio.ImageWriter iiowriter;
        private ImageOutputStream imageStream;

        public IIOMultiImageWriter(OutputStream outputStream) throws IOException {
            this.iiowriter = ImageIOImageWriter.this.getIIOImageWriter();
            if (!this.iiowriter.canWriteSequence()) {
                throw new UnsupportedOperationException("This ImageWriter does not support writing multiple images to a single image file.");
            }
            this.iiowriter.addIIOWriteWarningListener(ImageIOImageWriter.this);
            this.imageStream = ImageIO.createImageOutputStream(outputStream);
            this.iiowriter.setOutput(this.imageStream);
            this.iiowriter.prepareWriteSequence(null);
        }

        public void writeImage(RenderedImage renderedImage, ImageWriterParams imageWriterParams) throws IOException {
            if (this.iiowriter == null) {
                throw new IllegalStateException("MultiImageWriter already closed!");
            }
            ImageWriteParam imageWriteParam = ImageIOImageWriter.this.getDefaultWriteParam(this.iiowriter, renderedImage, imageWriterParams);
            ImageTypeSpecifier imageTypeSpecifier = imageWriteParam.getDestinationType() != null ? imageWriteParam.getDestinationType() : ImageTypeSpecifier.createFromRenderedImage(renderedImage);
            IIOMetadata iIOMetadata = this.iiowriter.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
            if (imageWriterParams != null && iIOMetadata != null) {
                iIOMetadata = ImageIOImageWriter.this.updateMetadata(iIOMetadata, imageWriterParams);
            }
            IIOImage iIOImage = new IIOImage(renderedImage, null, iIOMetadata);
            this.iiowriter.writeToSequence(iIOImage, imageWriteParam);
        }

        public void close() throws IOException {
            this.imageStream.close();
            this.imageStream = null;
            this.iiowriter.dispose();
            this.iiowriter = null;
        }
    }
}

