/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.IOException;
import java.text.MessageFormat;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.codec.tiff.TIFFDirectory;
import org.apache.xmlgraphics.image.codec.tiff.TIFFField;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.SubImageNotFoundException;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.image.loader.util.SeekableStreamAdapter;
import org.apache.xmlgraphics.util.UnitConv;

public class PreloaderTIFF
extends AbstractImagePreloader {
    private static Log log = LogFactory.getLog(PreloaderTIFF.class);
    private static final int TIFF_SIG_LENGTH = 8;

    public ImageInfo preloadImage(String string, Source source, ImageContext imageContext) throws IOException, ImageException {
        if (!ImageUtil.hasImageInputStream(source)) {
            return null;
        }
        ImageInputStream imageInputStream = ImageUtil.needImageInputStream(source);
        byte[] byArray = this.getHeader(imageInputStream, 8);
        boolean bl = false;
        if (byArray[0] == 73 && byArray[1] == 73 && byArray[2] == 42 && byArray[3] == 0) {
            bl = true;
        }
        if (byArray[0] == 77 && byArray[1] == 77 && byArray[2] == 0 && byArray[3] == 42) {
            bl = true;
        }
        if (bl) {
            ImageInfo imageInfo = this.createImageInfo(string, imageInputStream, imageContext);
            return imageInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageInfo createImageInfo(String string, ImageInputStream imageInputStream, ImageContext imageContext) throws IOException, ImageException {
        ImageInfo imageInfo = null;
        imageInputStream.mark();
        try {
            TIFFDirectory tIFFDirectory;
            int n = ImageUtil.needPageIndexFromURI(string);
            SeekableStreamAdapter seekableStreamAdapter = new SeekableStreamAdapter(imageInputStream);
            try {
                tIFFDirectory = new TIFFDirectory(seekableStreamAdapter, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = MessageFormat.format("Subimage {0} does not exist.", new Integer(n));
                throw new SubImageNotFoundException(string2);
            }
            int n2 = (int)tIFFDirectory.getFieldAsLong(256);
            int n3 = (int)tIFFDirectory.getFieldAsLong(257);
            ImageSize imageSize = new ImageSize();
            imageSize.setSizeInPixels(n2, n3);
            int n4 = 2;
            if (tIFFDirectory.isTagPresent(296)) {
                n4 = (int)tIFFDirectory.getFieldAsLong(296);
            }
            if (n4 == 2 || n4 == 3) {
                float f;
                float f2;
                TIFFField tIFFField = tIFFDirectory.getField(282);
                TIFFField tIFFField2 = tIFFDirectory.getField(283);
                if (tIFFField == null || tIFFField2 == null) {
                    n4 = 2;
                    f = f2 = imageContext.getSourceResolution();
                } else {
                    f2 = tIFFField.getAsFloat(0);
                    f = tIFFField2.getAsFloat(0);
                }
                if (f2 == 0.0f || f == 0.0f) {
                    imageSize.setResolution(imageContext.getSourceResolution());
                } else if (n4 == 2) {
                    imageSize.setResolution(f2, f);
                } else {
                    imageSize.setResolution(UnitConv.in2mm(f2) / 10.0, UnitConv.in2mm(f) / 10.0);
                }
            } else {
                imageSize.setResolution(imageContext.getSourceResolution());
            }
            imageSize.calcSizeFromPixels();
            if (log.isTraceEnabled()) {
                log.trace((Object)("TIFF image detected: " + imageSize));
            }
            imageInfo = new ImageInfo(string, "image/tiff");
            imageInfo.setSize(imageSize);
            TIFFField tIFFField = tIFFDirectory.getField(259);
            if (tIFFField != null) {
                int n5 = tIFFField.getAsInt(0);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("TIFF compression: " + n5));
                }
                imageInfo.getCustomObjects().put("TIFF_COMPRESSION", new Integer(n5));
            }
            if ((tIFFField = tIFFDirectory.getField(322)) != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"TIFF is tiled");
                }
                imageInfo.getCustomObjects().put("TIFF_TILED", Boolean.TRUE);
            }
            int n6 = (tIFFField = tIFFDirectory.getField(278)) == null ? 1 : (int)Math.ceil((double)imageSize.getHeightPx() / (double)tIFFField.getAsLong(0));
            if (log.isTraceEnabled()) {
                log.trace((Object)("TIFF has " + n6 + " strips."));
            }
            imageInfo.getCustomObjects().put("TIFF_STRIP_COUNT", new Integer(n6));
            try {
                new TIFFDirectory(seekableStreamAdapter, n + 1);
                imageInfo.getCustomObjects().put(ImageInfo.HAS_MORE_IMAGES, Boolean.TRUE);
                if (log.isTraceEnabled()) {
                    log.trace((Object)"TIFF is multi-page.");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                imageInfo.getCustomObjects().put(ImageInfo.HAS_MORE_IMAGES, Boolean.FALSE);
            }
        }
        finally {
            imageInputStream.reset();
        }
        return imageInfo;
    }
}

