/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.impl.JPEGConstants;
import org.apache.xmlgraphics.image.loader.impl.JPEGFile;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;

public class PreloaderJPEG
extends AbstractImagePreloader
implements JPEGConstants {
    private static final int JPG_SIG_LENGTH = 3;

    public ImageInfo preloadImage(String string, Source source, ImageContext imageContext) throws IOException, ImageException {
        boolean bl;
        if (!ImageUtil.hasImageInputStream(source)) {
            return null;
        }
        ImageInputStream imageInputStream = ImageUtil.needImageInputStream(source);
        byte[] byArray = this.getHeader(imageInputStream, 3);
        boolean bl2 = bl = byArray[0] == -1 && byArray[1] == -40 && byArray[2] == -1;
        if (bl) {
            ImageInfo imageInfo = new ImageInfo(string, "image/jpeg");
            imageInfo.setSize(this.determineSize(imageInputStream, imageContext));
            return imageInfo;
        }
        return null;
    }

    private ImageSize determineSize(ImageInputStream imageInputStream, ImageContext imageContext) throws IOException, ImageException {
        imageInputStream.mark();
        try {
            ImageSize imageSize = new ImageSize();
            JPEGFile jPEGFile = new JPEGFile(imageInputStream);
            block12: while (true) {
                int n = jPEGFile.readMarkerSegment();
                switch (n) {
                    case 0: 
                    case 216: {
                        continue block12;
                    }
                    case 224: {
                        int n2 = jPEGFile.readSegmentLength();
                        imageInputStream.skipBytes(7);
                        int n3 = imageInputStream.read();
                        int n4 = imageInputStream.readUnsignedShort();
                        int n5 = imageInputStream.readUnsignedShort();
                        if (n3 == 2) {
                            imageSize.setResolution((float)n4 * 2.54f, (float)n5 * 2.54f);
                        } else if (n3 == 1) {
                            imageSize.setResolution(n4, n5);
                        } else {
                            imageSize.setResolution(imageContext.getSourceResolution());
                        }
                        if (imageSize.getWidthPx() != 0) {
                            imageSize.calcSizeFromPixels();
                            ImageSize imageSize2 = imageSize;
                            return imageSize2;
                        }
                        imageInputStream.skipBytes(n2 - 14);
                        continue block12;
                    }
                    case 192: 
                    case 193: 
                    case 194: 
                    case 202: {
                        int n2 = jPEGFile.readSegmentLength();
                        imageInputStream.skipBytes(1);
                        int n6 = imageInputStream.readUnsignedShort();
                        int n7 = imageInputStream.readUnsignedShort();
                        imageSize.setSizeInPixels(n7, n6);
                        if (imageSize.getDpiHorizontal() != 0.0) {
                            imageSize.calcSizeFromPixels();
                            ImageSize imageSize3 = imageSize;
                            return imageSize3;
                        }
                        imageInputStream.skipBytes(n2 - 7);
                        continue block12;
                    }
                    case 217: 
                    case 218: {
                        if (imageSize.getDpiHorizontal() == 0.0) {
                            imageSize.setResolution(imageContext.getSourceResolution());
                            imageSize.calcSizeFromPixels();
                        }
                        ImageSize imageSize4 = imageSize;
                        return imageSize4;
                    }
                }
                jPEGFile.skipCurrentMarkerSegment();
            }
        }
        finally {
            imageInputStream.reset();
        }
    }
}

