/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.tiff;

import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.Deflater;
import org.apache.xmlgraphics.image.codec.tiff.TIFFEncodeParam;
import org.apache.xmlgraphics.image.codec.tiff.TIFFField;
import org.apache.xmlgraphics.image.codec.util.ImageEncodeParam;
import org.apache.xmlgraphics.image.codec.util.ImageEncoderImpl;
import org.apache.xmlgraphics.image.codec.util.PropertyUtil;
import org.apache.xmlgraphics.image.codec.util.SeekableOutputStream;

public class TIFFImageEncoder
extends ImageEncoderImpl {
    private static final int TIFF_UNSUPPORTED = -1;
    private static final int TIFF_BILEVEL_WHITE_IS_ZERO = 0;
    private static final int TIFF_BILEVEL_BLACK_IS_ZERO = 1;
    private static final int TIFF_GRAY = 2;
    private static final int TIFF_PALETTE = 3;
    private static final int TIFF_RGB = 4;
    private static final int TIFF_CMYK = 5;
    private static final int TIFF_YCBCR = 6;
    private static final int TIFF_CIELAB = 7;
    private static final int TIFF_GENERIC = 8;
    private static final int COMP_NONE = 1;
    private static final int COMP_JPEG_TTN2 = 7;
    private static final int COMP_PACKBITS = 32773;
    private static final int COMP_DEFLATE = 32946;
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    private static final int TIFF_YCBCR_POSITIONING = 531;
    private static final int TIFF_REF_BLACK_WHITE = 532;
    private static final int EXTRA_SAMPLE_UNSPECIFIED = 0;
    private static final int EXTRA_SAMPLE_ASSOCIATED_ALPHA = 1;
    private static final int EXTRA_SAMPLE_UNASSOCIATED_ALPHA = 2;
    private static final int DEFAULT_ROWS_PER_STRIP = 8;
    private static final int[] sizeOfType = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    public TIFFImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (this.param == null) {
            this.param = new TIFFEncodeParam();
        }
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        this.writeFileHeader();
        TIFFEncodeParam tIFFEncodeParam = (TIFFEncodeParam)this.param;
        Iterator iterator = tIFFEncodeParam.getExtraImages();
        if (iterator != null) {
            boolean bl;
            int n = 8;
            RenderedImage renderedImage2 = renderedImage;
            TIFFEncodeParam tIFFEncodeParam2 = tIFFEncodeParam;
            do {
                n = this.encode(renderedImage2, tIFFEncodeParam2, n, !(bl = iterator.hasNext()));
                if (!bl) continue;
                Object e = iterator.next();
                if (e instanceof RenderedImage) {
                    renderedImage2 = (RenderedImage)e;
                    tIFFEncodeParam2 = tIFFEncodeParam;
                    continue;
                }
                if (!(e instanceof Object[])) continue;
                Object[] objectArray = (Object[])e;
                renderedImage2 = (RenderedImage)objectArray[0];
                tIFFEncodeParam2 = (TIFFEncodeParam)objectArray[1];
            } while (bl);
        } else {
            this.encode(renderedImage, tIFFEncodeParam, 8, true);
        }
    }

    public Object encodeMultiple(Object object, RenderedImage renderedImage) throws IOException {
        TIFFEncodeParam tIFFEncodeParam = (TIFFEncodeParam)this.param;
        if (tIFFEncodeParam.getExtraImages() != null) {
            throw new IllegalStateException(PropertyUtil.getString("TIFFImageEncoder11"));
        }
        Context context = (Context)object;
        if (context == null) {
            context = new Context();
            this.writeFileHeader();
        } else {
            context.ifdOffset = this.encode(context.nextImage, tIFFEncodeParam, context.ifdOffset, false);
        }
        context.nextImage = renderedImage;
        return context;
    }

    public void finishMultiple(Object object) throws IOException {
        if (object == null) {
            throw new NullPointerException();
        }
        Context context = (Context)object;
        TIFFEncodeParam tIFFEncodeParam = (TIFFEncodeParam)this.param;
        context.ifdOffset = this.encode(context.nextImage, tIFFEncodeParam, context.ifdOffset, true);
    }

    private int encode(RenderedImage renderedImage, TIFFEncodeParam tIFFEncodeParam, int n, boolean bl) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        TIFFField[] tIFFFieldArray;
        Object object;
        int n7;
        int n8;
        int n9;
        int n10;
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        int n11;
        int n12;
        int n13 = tIFFEncodeParam.getCompression();
        if (n13 == 7) {
            throw new IllegalArgumentException(PropertyUtil.getString("TIFFImageEncoder12"));
        }
        boolean bl2 = tIFFEncodeParam.getWriteTiled();
        int n14 = renderedImage.getMinX();
        int n15 = renderedImage.getMinY();
        int n16 = renderedImage.getWidth();
        int n17 = renderedImage.getHeight();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int[] nArray = sampleModel.getSampleSize();
        for (n12 = 1; n12 < nArray.length; ++n12) {
            if (nArray[n12] == nArray[0]) continue;
            throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder0"));
        }
        n12 = sampleModel.getNumBands();
        if ((nArray[0] == 1 || nArray[0] == 4) && n12 != 1) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder1"));
        }
        int n18 = sampleModel.getDataType();
        switch (n18) {
            case 0: {
                if (nArray[0] == 1 || nArray[0] != 4 || nArray[0] == 8) break;
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder2"));
            }
            case 1: 
            case 2: {
                if (nArray[0] == 16) break;
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder3"));
            }
            case 3: 
            case 4: {
                if (nArray[0] == 32) break;
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder4"));
            }
            default: {
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder5"));
            }
        }
        boolean bl3 = n18 == 2 || n18 == 1;
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel != null && colorModel instanceof IndexColorModel && n18 != 0) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder6"));
        }
        IndexColorModel indexColorModel = null;
        int n19 = 0;
        char[] cArray = null;
        int n20 = -1;
        int n21 = 0;
        int n22 = 0;
        if (colorModel instanceof IndexColorModel) {
            indexColorModel = (IndexColorModel)colorModel;
            n11 = indexColorModel.getMapSize();
            if (nArray[0] == 1 && n12 == 1) {
                if (n11 != 2) {
                    throw new IllegalArgumentException(PropertyUtil.getString("TIFFImageEncoder7"));
                }
                byArray3 = new byte[n11];
                indexColorModel.getReds(byArray3);
                byArray2 = new byte[n11];
                indexColorModel.getGreens(byArray2);
                byArray = new byte[n11];
                indexColorModel.getBlues(byArray);
                n20 = (byArray3[0] & 0xFF) == 0 && (byArray3[1] & 0xFF) == 255 && (byArray2[0] & 0xFF) == 0 && (byArray2[1] & 0xFF) == 255 && (byArray[0] & 0xFF) == 0 && (byArray[1] & 0xFF) == 255 ? 1 : ((byArray3[0] & 0xFF) == 255 && (byArray3[1] & 0xFF) == 0 && (byArray2[0] & 0xFF) == 255 && (byArray2[1] & 0xFF) == 0 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 0 ? 0 : 3);
            } else if (n12 == 1) {
                n20 = 3;
            }
        } else if (colorModel == null) {
            if (nArray[0] == 1 && n12 == 1) {
                n20 = 1;
            } else {
                n20 = 8;
                if (n12 > 1) {
                    n21 = n12 - 1;
                }
            }
        } else {
            ColorSpace colorSpace = colorModel.getColorSpace();
            switch (colorSpace.getType()) {
                case 9: {
                    n20 = 5;
                    break;
                }
                case 6: {
                    n20 = 2;
                    break;
                }
                case 1: {
                    n20 = 7;
                    break;
                }
                case 5: {
                    if (n13 == 7 && tIFFEncodeParam.getJPEGCompressRGBToYCbCr()) {
                        n20 = 6;
                        break;
                    }
                    n20 = 4;
                    break;
                }
                case 3: {
                    n20 = 6;
                    break;
                }
                default: {
                    n20 = 8;
                }
            }
            if (n20 == 8) {
                n21 = n12 - 1;
            } else if (n12 > 1) {
                n21 = n12 - colorSpace.getNumComponents();
            }
            if (n21 == 1 && colorModel.hasAlpha()) {
                int n23 = n22 = colorModel.isAlphaPremultiplied() ? 1 : 2;
            }
        }
        if (n20 == -1) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder8"));
        }
        n11 = -1;
        switch (n20) {
            case 0: {
                n11 = 0;
                break;
            }
            case 1: {
                n11 = 1;
                break;
            }
            case 2: 
            case 8: {
                n11 = 1;
                break;
            }
            case 3: {
                n11 = 3;
                indexColorModel = (IndexColorModel)colorModel;
                n19 = indexColorModel.getMapSize();
                byArray3 = new byte[n19];
                indexColorModel.getReds(byArray3);
                byArray2 = new byte[n19];
                indexColorModel.getGreens(byArray2);
                byArray = new byte[n19];
                indexColorModel.getBlues(byArray);
                int n24 = 0;
                int n25 = n19;
                int n26 = 2 * n19;
                cArray = new char[n19 * 3];
                for (int i = 0; i < n19; ++i) {
                    int n27 = 0xFF & byArray3[i];
                    cArray[n24++] = (char)(n27 << 8 | n27);
                    n27 = 0xFF & byArray2[i];
                    cArray[n25++] = (char)(n27 << 8 | n27);
                    n27 = 0xFF & byArray[i];
                    cArray[n26++] = (char)(n27 << 8 | n27);
                }
                n19 *= 3;
                break;
            }
            case 4: {
                n11 = 2;
                break;
            }
            case 5: {
                n11 = 5;
                break;
            }
            case 6: {
                n11 = 6;
                break;
            }
            case 7: {
                n11 = 8;
                break;
            }
            default: {
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder8"));
            }
        }
        if (bl2) {
            n10 = tIFFEncodeParam.getTileWidth() > 0 ? tIFFEncodeParam.getTileWidth() : renderedImage.getTileWidth();
            n9 = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : renderedImage.getTileHeight();
        } else {
            n10 = n16;
            n9 = tIFFEncodeParam.getTileHeight() > 0 ? tIFFEncodeParam.getTileHeight() : 8;
        }
        int n28 = bl2 ? (n16 + n10 - 1) / n10 * ((n17 + n9 - 1) / n9) : (int)Math.ceil((double)n17 / (double)n9);
        long[] lArray = new long[n28];
        long l = (long)Math.ceil((double)nArray[0] / 8.0 * (double)n10 * (double)n12);
        long l2 = l * (long)n9;
        for (int i = 0; i < n28; ++i) {
            lArray[i] = l2;
        }
        if (!bl2) {
            long l3 = n17 - n9 * (n28 - 1);
            lArray[n28 - 1] = l3 * l;
        }
        long l4 = l2 * (long)(n28 - 1) + lArray[n28 - 1];
        long[] lArray2 = new long[n28];
        TreeSet<TIFFField> treeSet = new TreeSet<TIFFField>();
        treeSet.add(new TIFFField(256, 4, 1, new long[]{n16}));
        treeSet.add(new TIFFField(257, 4, 1, new long[]{n17}));
        char[] cArray2 = new char[n12];
        for (n8 = 0; n8 < n12; ++n8) {
            cArray2[n8] = (char)nArray[n8];
        }
        treeSet.add(new TIFFField(258, 3, n12, cArray2));
        treeSet.add(new TIFFField(259, 3, 1, new char[]{(char)n13}));
        treeSet.add(new TIFFField(262, 3, 1, new char[]{(char)n11}));
        if (!bl2) {
            treeSet.add(new TIFFField(273, 4, n28, lArray2));
        }
        treeSet.add(new TIFFField(277, 3, 1, new char[]{(char)n12}));
        if (!bl2) {
            treeSet.add(new TIFFField(278, 4, 1, new long[]{n9}));
            treeSet.add(new TIFFField(279, 4, n28, lArray));
        }
        if (cArray != null) {
            treeSet.add(new TIFFField(320, 3, n19, cArray));
        }
        if (bl2) {
            treeSet.add(new TIFFField(322, 4, 1, new long[]{n10}));
            treeSet.add(new TIFFField(323, 4, 1, new long[]{n9}));
            treeSet.add(new TIFFField(324, 4, n28, lArray2));
            treeSet.add(new TIFFField(325, 4, n28, lArray));
        }
        if (n21 > 0) {
            char[] cArray3 = new char[n21];
            for (n7 = 0; n7 < n21; ++n7) {
                cArray3[n7] = (char)n22;
            }
            treeSet.add(new TIFFField(338, 3, n21, cArray3));
        }
        if (n18 != 0) {
            char[] cArray4 = new char[n12];
            cArray4[0] = n18 == 4 ? 3 : (n18 == 1 ? 1 : 2);
            for (n7 = 1; n7 < n12; ++n7) {
                cArray4[n7] = cArray4[0];
            }
            treeSet.add(new TIFFField(339, 3, n12, cArray4));
        }
        if (n20 == 6) {
            n8 = 1;
            n7 = 1;
            treeSet.add(new TIFFField(530, 3, 2, new char[]{n8, n7}));
            treeSet.add(new TIFFField(531, 3, 1, new char[]{(char)(n13 == 7 ? 1 : 2)}));
            object = new long[][]{{15L, 1L}, {235L, 1L}, {128L, 1L}, {240L, 1L}, {128L, 1L}, {240L, 1L}};
            treeSet.add(new TIFFField(532, 5, 6, object));
        }
        if ((tIFFFieldArray = tIFFEncodeParam.getExtraFields()) != null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(treeSet.size());
            for (TIFFField tIFFField : treeSet) {
                arrayList.add(new Integer(tIFFField.getTag()));
            }
            for (TIFFField tIFFField : tIFFFieldArray) {
                Integer n29 = new Integer(tIFFField.getTag());
                if (arrayList.contains(n29)) continue;
                treeSet.add(tIFFField);
                arrayList.add(n29);
            }
        }
        int n30 = this.getDirectorySize(treeSet);
        lArray2[0] = n + n30;
        object = null;
        byte[] byArray4 = null;
        File file = null;
        int n31 = 0;
        boolean bl4 = false;
        Deflater deflater = null;
        boolean bl5 = false;
        if (n13 == 1) {
            int n32;
            n6 = 0;
            if (nArray[0] == 16 && lArray2[0] % 2L != 0L) {
                n6 = 1;
                lArray2[0] = lArray2[0] + 1L;
            } else if (nArray[0] == 32 && lArray2[0] % 4L != 0L) {
                n6 = (int)(4L - lArray2[0] % 4L);
                lArray2[0] = lArray2[0] + (long)n6;
            }
            for (n32 = 1; n32 < n28; ++n32) {
                lArray2[n32] = lArray2[n32 - 1] + lArray[n32 - 1];
            }
            if (!bl && ((n31 = (int)(lArray2[0] + l4)) & 1) != 0) {
                ++n31;
                bl4 = true;
            }
            this.writeDirectory(n, treeSet, n31);
            if (n6 != 0) {
                for (n32 = 0; n32 < n6; ++n32) {
                    this.output.write(0);
                }
            }
        } else {
            if (this.output instanceof SeekableOutputStream) {
                ((SeekableOutputStream)this.output).seek(lArray2[0]);
            } else {
                object = this.output;
                try {
                    file = File.createTempFile("jai-SOS-", ".tmp");
                    file.deleteOnExit();
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    this.output = new SeekableOutputStream(randomAccessFile);
                }
                catch (Exception exception) {
                    this.output = new ByteArrayOutputStream((int)l4);
                }
            }
            n6 = 0;
            switch (n13) {
                case 32773: {
                    n6 = (int)(l2 + (l + 127L) / 128L * (long)n9);
                    break;
                }
                case 32946: {
                    n6 = (int)l2;
                    deflater = new Deflater(tIFFEncodeParam.getDeflateLevel());
                    break;
                }
                default: {
                    n6 = 0;
                }
            }
            if (n6 != 0) {
                byArray4 = new byte[n6];
            }
        }
        int[] nArray2 = null;
        float[] fArray = null;
        boolean bl6 = nArray[0] == 1 && sampleModel instanceof MultiPixelPackedSampleModel && n18 == 0 || nArray[0] == 8 && sampleModel instanceof ComponentSampleModel;
        byte[] byArray5 = null;
        if (n13 != 7) {
            if (n18 == 0) {
                byArray5 = new byte[n9 * n10 * n12];
            } else if (bl3) {
                byArray5 = new byte[2 * n9 * n10 * n12];
            } else if (n18 == 3 || n18 == 4) {
                byArray5 = new byte[4 * n9 * n10 * n12];
            }
        }
        int n33 = n15 + n17;
        int n34 = n14 + n16;
        int n35 = 0;
        for (n5 = n15; n5 < n33; n5 += n9) {
            n4 = bl2 ? n9 : Math.min(n9, n33 - n5);
            n3 = n4 * n10 * n12;
            block46: for (n2 = n14; n2 < n34; n2 += n10) {
                int n36;
                int n37;
                int n38;
                Raster raster = renderedImage.getData(new Rectangle(n2, n5, n10, n4));
                boolean bl7 = false;
                if (n13 != 7) {
                    if (bl6) {
                        if (nArray[0] == 8) {
                            ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                            int[] nArray3 = componentSampleModel.getBankIndices();
                            int[] nArray4 = componentSampleModel.getBandOffsets();
                            n38 = componentSampleModel.getPixelStride();
                            n37 = componentSampleModel.getScanlineStride();
                            if (n38 != n12 || (long)n37 != l) {
                                bl7 = false;
                            } else {
                                bl7 = true;
                                for (n36 = 0; bl7 && n36 < n12; ++n36) {
                                    if (nArray3[n36] == 0 && nArray4[n36] == n36) continue;
                                    bl7 = false;
                                }
                            }
                        } else {
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            if (multiPixelPackedSampleModel.getNumBands() == 1 && multiPixelPackedSampleModel.getDataBitOffset() == 0 && multiPixelPackedSampleModel.getPixelBitStride() == 1) {
                                bl7 = true;
                            }
                        }
                    }
                    if (!bl7) {
                        if (n18 == 4) {
                            fArray = raster.getPixels(n2, n5, n10, n4, fArray);
                        } else {
                            nArray2 = raster.getPixels(n2, n5, n10, n4, nArray2);
                        }
                    }
                }
                int n39 = 0;
                int n40 = 0;
                switch (nArray[0]) {
                    case 1: {
                        int n41;
                        int n42;
                        int n43;
                        if (bl7) {
                            byte[] byArray6 = ((DataBufferByte)raster.getDataBuffer()).getData();
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            n36 = multiPixelPackedSampleModel.getScanlineStride();
                            n43 = multiPixelPackedSampleModel.getOffset(n2 - raster.getSampleModelTranslateX(), n5 - raster.getSampleModelTranslateY());
                            if (n36 == (int)l) {
                                System.arraycopy(byArray6, n43, byArray5, 0, (int)l * n4);
                            } else {
                                n42 = 0;
                                for (n41 = 0; n41 < n4; ++n41) {
                                    System.arraycopy(byArray6, n43, byArray5, n42, (int)l);
                                    n43 += n36;
                                    n42 += (int)l;
                                }
                            }
                        } else {
                            int n44 = 0;
                            for (n38 = 0; n38 < n4; ++n38) {
                                for (n37 = 0; n37 < n10 / 8; ++n37) {
                                    n39 = nArray2[n44++] << 7 | nArray2[n44++] << 6 | nArray2[n44++] << 5 | nArray2[n44++] << 4 | nArray2[n44++] << 3 | nArray2[n44++] << 2 | nArray2[n44++] << 1 | nArray2[n44++];
                                    byArray5[n40++] = (byte)n39;
                                }
                                if (n10 % 8 <= 0) continue;
                                n39 = 0;
                                for (n37 = 0; n37 < n10 % 8; ++n37) {
                                    n39 |= nArray2[n44++] << 7 - n37;
                                }
                                byArray5[n40++] = (byte)n39;
                            }
                        }
                        if (n13 == 1) {
                            this.output.write(byArray5, 0, n4 * ((n10 + 7) / 8));
                            continue block46;
                        }
                        if (n13 == 32773) {
                            int n45 = TIFFImageEncoder.compressPackBits(byArray5, n4, (int)l, byArray4);
                            lArray[n35++] = n45;
                            this.output.write(byArray4, 0, n45);
                            continue block46;
                        }
                        if (n13 != 32946) continue block46;
                        int n46 = TIFFImageEncoder.deflate(deflater, byArray5, byArray4);
                        lArray[n35++] = n46;
                        this.output.write(byArray4, 0, n46);
                        continue block46;
                    }
                    case 4: {
                        int n47 = 0;
                        for (n38 = 0; n38 < n4; ++n38) {
                            for (n37 = 0; n37 < n10 / 2; ++n37) {
                                n39 = nArray2[n47++] << 4 | nArray2[n47++];
                                byArray5[n40++] = (byte)n39;
                            }
                            if ((n10 & 1) != 1) continue;
                            n39 = nArray2[n47++] << 4;
                            byArray5[n40++] = (byte)n39;
                        }
                        if (n13 == 1) {
                            this.output.write(byArray5, 0, n4 * ((n10 + 1) / 2));
                            continue block46;
                        }
                        if (n13 == 32773) {
                            n38 = TIFFImageEncoder.compressPackBits(byArray5, n4, (int)l, byArray4);
                            lArray[n35++] = n38;
                            this.output.write(byArray4, 0, n38);
                            continue block46;
                        }
                        if (n13 != 32946) continue block46;
                        n38 = TIFFImageEncoder.deflate(deflater, byArray5, byArray4);
                        lArray[n35++] = n38;
                        this.output.write(byArray4, 0, n38);
                        continue block46;
                    }
                    case 8: {
                        int n41;
                        int n42;
                        int n43;
                        if (n13 != 7) {
                            if (bl7) {
                                byte[] byArray7 = ((DataBufferByte)raster.getDataBuffer()).getData();
                                ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                                n36 = componentSampleModel.getOffset(n2 - raster.getSampleModelTranslateX(), n5 - raster.getSampleModelTranslateY());
                                n43 = componentSampleModel.getScanlineStride();
                                if (n43 == (int)l) {
                                    System.arraycopy(byArray7, n36, byArray5, 0, (int)l * n4);
                                } else {
                                    n42 = 0;
                                    for (n41 = 0; n41 < n4; ++n41) {
                                        System.arraycopy(byArray7, n36, byArray5, n42, (int)l);
                                        n36 += n43;
                                        n42 += (int)l;
                                    }
                                }
                            } else {
                                for (n38 = 0; n38 < n3; ++n38) {
                                    byArray5[n38] = (byte)nArray2[n38];
                                }
                            }
                        }
                        if (n13 == 1) {
                            this.output.write(byArray5, 0, n3);
                            continue block46;
                        }
                        if (n13 == 32773) {
                            n38 = TIFFImageEncoder.compressPackBits(byArray5, n4, (int)l, byArray4);
                            lArray[n35++] = n38;
                            this.output.write(byArray4, 0, n38);
                            continue block46;
                        }
                        if (n13 != 32946) continue block46;
                        n38 = TIFFImageEncoder.deflate(deflater, byArray5, byArray4);
                        lArray[n35++] = n38;
                        this.output.write(byArray4, 0, n38);
                        continue block46;
                    }
                    case 16: {
                        n38 = 0;
                        for (n37 = 0; n37 < n3; ++n37) {
                            n36 = nArray2[n37];
                            byArray5[n38++] = (byte)((n36 & 0xFF00) >> 8);
                            byArray5[n38++] = (byte)(n36 & 0xFF);
                        }
                        if (n13 == 1) {
                            this.output.write(byArray5, 0, n3 * 2);
                            continue block46;
                        }
                        if (n13 == 32773) {
                            n37 = TIFFImageEncoder.compressPackBits(byArray5, n4, (int)l, byArray4);
                            lArray[n35++] = n37;
                            this.output.write(byArray4, 0, n37);
                            continue block46;
                        }
                        if (n13 != 32946) continue block46;
                        n37 = TIFFImageEncoder.deflate(deflater, byArray5, byArray4);
                        lArray[n35++] = n37;
                        this.output.write(byArray4, 0, n37);
                        continue block46;
                    }
                    case 32: {
                        int n43;
                        if (n18 == 3) {
                            n37 = 0;
                            for (n36 = 0; n36 < n3; ++n36) {
                                n43 = nArray2[n36];
                                byArray5[n37++] = (byte)((n43 & 0xFF000000) >>> 24);
                                byArray5[n37++] = (byte)((n43 & 0xFF0000) >>> 16);
                                byArray5[n37++] = (byte)((n43 & 0xFF00) >>> 8);
                                byArray5[n37++] = (byte)(n43 & 0xFF);
                            }
                        } else {
                            n37 = 0;
                            for (n36 = 0; n36 < n3; ++n36) {
                                n43 = Float.floatToIntBits(fArray[n36]);
                                byArray5[n37++] = (byte)((n43 & 0xFF000000) >>> 24);
                                byArray5[n37++] = (byte)((n43 & 0xFF0000) >>> 16);
                                byArray5[n37++] = (byte)((n43 & 0xFF00) >>> 8);
                                byArray5[n37++] = (byte)(n43 & 0xFF);
                            }
                        }
                        if (n13 == 1) {
                            this.output.write(byArray5, 0, n3 * 4);
                            continue block46;
                        }
                        if (n13 == 32773) {
                            n37 = TIFFImageEncoder.compressPackBits(byArray5, n4, (int)l, byArray4);
                            lArray[n35++] = n37;
                            this.output.write(byArray4, 0, n37);
                            continue block46;
                        }
                        if (n13 != 32946) continue block46;
                        n37 = TIFFImageEncoder.deflate(deflater, byArray5, byArray4);
                        lArray[n35++] = n37;
                        this.output.write(byArray4, 0, n37);
                    }
                }
            }
        }
        if (n13 == 1) {
            if (bl4) {
                this.output.write(0);
            }
        } else {
            n5 = 0;
            for (n4 = 1; n4 < n28; ++n4) {
                n3 = (int)lArray[n4 - 1];
                n5 += n3;
                lArray2[n4] = lArray2[n4 - 1] + (long)n3;
            }
            int n48 = n31 = bl ? 0 : n + n30 + (n5 += (int)lArray[n28 - 1]);
            if ((n31 & 1) != 0) {
                ++n31;
                bl4 = true;
            }
            if (object == null) {
                if (bl4) {
                    this.output.write(0);
                }
                SeekableOutputStream seekableOutputStream = (SeekableOutputStream)this.output;
                long l5 = seekableOutputStream.getFilePointer();
                seekableOutputStream.seek(n);
                this.writeDirectory(n, treeSet, n31);
                seekableOutputStream.seek(l5);
            } else if (file != null) {
                int n49;
                FileInputStream fileInputStream = new FileInputStream(file);
                this.output.close();
                this.output = object;
                this.writeDirectory(n, treeSet, n31);
                byte[] byArray8 = new byte[8192];
                for (n2 = 0; n2 < n5 && (n49 = fileInputStream.read(byArray8)) != -1; n2 += n49) {
                    this.output.write(byArray8, 0, n49);
                }
                fileInputStream.close();
                file.delete();
                if (bl4) {
                    this.output.write(0);
                }
            } else if (this.output instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.output;
                this.output = object;
                this.writeDirectory(n, treeSet, n31);
                byteArrayOutputStream.writeTo(this.output);
                if (bl4) {
                    this.output.write(0);
                }
            } else {
                throw new IllegalStateException(PropertyUtil.getString("TIFFImageEncoder13"));
            }
        }
        return n31;
    }

    private int getDirectorySize(SortedSet sortedSet) {
        int n = sortedSet.size();
        int n2 = 2 + n * 12 + 4;
        for (TIFFField tIFFField : sortedSet) {
            int n3 = tIFFField.getCount() * sizeOfType[tIFFField.getType()];
            if (n3 <= 4) continue;
            n2 += n3;
        }
        return n2;
    }

    private void writeFileHeader() throws IOException {
        this.output.write(77);
        this.output.write(77);
        this.output.write(0);
        this.output.write(42);
        this.writeLong(8L);
    }

    private void writeDirectory(int n, SortedSet sortedSet, int n2) throws IOException {
        int n3 = sortedSet.size();
        long l = n + 12 * n3 + 4 + 2;
        ArrayList<TIFFField> arrayList = new ArrayList<TIFFField>();
        this.writeUnsignedShort(n3);
        for (TIFFField tIFFField : sortedSet) {
            int n4 = tIFFField.getTag();
            this.writeUnsignedShort(n4);
            int n5 = tIFFField.getType();
            this.writeUnsignedShort(n5);
            int n6 = tIFFField.getCount();
            int n7 = TIFFImageEncoder.getValueSize(tIFFField);
            this.writeLong(n5 == 2 ? (long)n7 : (long)n6);
            if (n7 > 4) {
                this.writeLong(l);
                l += (long)n7;
                arrayList.add(tIFFField);
                continue;
            }
            this.writeValuesAsFourBytes(tIFFField);
        }
        this.writeLong(n2);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.writeValues((TIFFField)arrayList.get(i));
        }
    }

    private static int getValueSize(TIFFField tIFFField) {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        int n3 = 0;
        if (n == 2) {
            for (int i = 0; i < n2; ++i) {
                byte[] byArray = tIFFField.getAsString(i).getBytes();
                n3 += byArray.length;
                if (byArray[byArray.length - 1] == 0) continue;
                ++n3;
            }
        } else {
            n3 = n2 * sizeOfType[n];
        }
        return n3;
    }

    private void writeValuesAsFourBytes(TIFFField tIFFField) throws IOException {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        switch (n) {
            case 1: {
                int n3;
                byte[] byArray = tIFFField.getAsBytes();
                if (n2 > 4) {
                    n2 = 4;
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    this.output.write(byArray[n3]);
                }
                for (n3 = 0; n3 < 4 - n2; ++n3) {
                    this.output.write(0);
                }
                break;
            }
            case 3: {
                int n4;
                char[] cArray = tIFFField.getAsChars();
                if (n2 > 2) {
                    n2 = 2;
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    this.writeUnsignedShort(cArray[n4]);
                }
                for (n4 = 0; n4 < 2 - n2; ++n4) {
                    this.writeUnsignedShort(0);
                }
                break;
            }
            case 4: {
                long[] lArray = tIFFField.getAsLongs();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(lArray[i]);
                }
                break;
            }
        }
    }

    private void writeValues(TIFFField tIFFField) throws IOException {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        switch (n) {
            case 1: 
            case 6: 
            case 7: {
                byte[] byArray = tIFFField.getAsBytes();
                for (int i = 0; i < n2; ++i) {
                    this.output.write(byArray[i]);
                }
                break;
            }
            case 3: {
                char[] cArray = tIFFField.getAsChars();
                for (int i = 0; i < n2; ++i) {
                    this.writeUnsignedShort(cArray[i]);
                }
                break;
            }
            case 8: {
                short[] sArray = tIFFField.getAsShorts();
                for (int i = 0; i < n2; ++i) {
                    this.writeUnsignedShort(sArray[i]);
                }
                break;
            }
            case 4: 
            case 9: {
                long[] lArray = tIFFField.getAsLongs();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(lArray[i]);
                }
                break;
            }
            case 11: {
                float[] fArray = tIFFField.getAsFloats();
                for (int i = 0; i < n2; ++i) {
                    int n3 = Float.floatToIntBits(fArray[i]);
                    this.writeLong(n3);
                }
                break;
            }
            case 12: {
                double[] dArray = tIFFField.getAsDoubles();
                for (int i = 0; i < n2; ++i) {
                    long l = Double.doubleToLongBits(dArray[i]);
                    this.writeLong(l >>> 32);
                    this.writeLong(l & 0xFFFFFFFFL);
                }
                break;
            }
            case 5: 
            case 10: {
                long[][] lArray = tIFFField.getAsRationals();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(lArray[i][0]);
                    this.writeLong(lArray[i][1]);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    byte[] byArray = tIFFField.getAsString(i).getBytes();
                    this.output.write(byArray);
                    if (byArray[byArray.length - 1] == 0) continue;
                    this.output.write(0);
                }
                break;
            }
            default: {
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder10"));
            }
        }
    }

    private void writeUnsignedShort(int n) throws IOException {
        this.output.write((n & 0xFF00) >>> 8);
        this.output.write(n & 0xFF);
    }

    private void writeLong(long l) throws IOException {
        this.output.write((int)((l & 0xFFFFFFFFFF000000L) >>> 24));
        this.output.write((int)((l & 0xFF0000L) >>> 16));
        this.output.write((int)((l & 0xFF00L) >>> 8));
        this.output.write((int)(l & 0xFFL));
    }

    private long getOffset(OutputStream outputStream) throws IOException {
        if (outputStream instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)outputStream).size();
        }
        if (outputStream instanceof SeekableOutputStream) {
            return ((SeekableOutputStream)outputStream).getFilePointer();
        }
        throw new IllegalStateException(PropertyUtil.getString("TIFFImageEncoder13"));
    }

    private static int compressPackBits(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            n4 = TIFFImageEncoder.packBits(byArray, n3, n2, byArray2, n4);
            n3 += n2;
        }
        return n4;
    }

    private static int packBits(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n + n2 - 1;
        int n5 = n4 - 1;
        while (n <= n4) {
            int n6;
            byte by = byArray[n];
            for (n6 = 1; n6 < 127 && n < n4 && byArray[n] == byArray[n + 1]; ++n6, ++n) {
            }
            if (n6 > 1) {
                ++n;
                byArray2[n3++] = (byte)(-(n6 - 1));
                byArray2[n3++] = by;
            }
            int n7 = n3;
            for (n6 = 0; n6 < 128 && (n < n4 && byArray[n] != byArray[n + 1] || n < n5 && byArray[n] != byArray[n + 2]); ++n6) {
                byArray2[++n3] = byArray[n++];
            }
            if (n6 > 0) {
                byArray2[n7] = (byte)(n6 - 1);
                ++n3;
            }
            if (n != n4) continue;
            if (n6 > 0 && n6 < 128) {
                int n8 = n7;
                byArray2[n8] = (byte)(byArray2[n8] + 1);
                byArray2[n3++] = byArray[n++];
                continue;
            }
            byArray2[n3++] = 0;
            byArray2[n3++] = byArray[n++];
        }
        return n3;
    }

    private static int deflate(Deflater deflater, byte[] byArray, byte[] byArray2) {
        deflater.setInput(byArray);
        deflater.finish();
        int n = deflater.deflate(byArray2);
        deflater.reset();
        return n;
    }

    private class Context {
        private RenderedImage nextImage;
        private int ifdOffset = 8;

        private Context() {
        }
    }
}

