/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.mathworks.hg.peer.FigurePanelContainer;
import com.mathworks.hg.print.CMYKColorConverter;
import com.mathworks.hg.print.ColorConvertingGraphics2D;
import com.mathworks.hg.print.GrayColorConverter;
import com.mathworks.hg.print.HGOutputFlags;
import com.mathworks.hg.print.OpaqueAlphaRemover;
import com.mathworks.hg.print.OutputProcessingException;
import com.mathworks.hg.print.VectorHelperDefinition;
import com.mathworks.hg.print.VectorStrategy;
import com.mathworks.hg.uij.ExportClipboardHelper;
import com.mathworks.hg.util.MPrintJob;
import com.mathworks.hg.util.OutputHelper;
import com.mathworks.hg.util.OutputHelperProcessingException;
import com.mathworks.jmi.AWTUtilities;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HGVectorOutputHelper
extends OutputHelper {
    private String fCurrentLog;
    private VectorHelperDefinition fCreatorInfo;
    private VectorStrategy fOutputGenerator;
    private Graphics fGraphics;
    private Graphics fStrategyGraphics;
    private OutputStream fStream;
    private boolean fToClipboard = false;
    private String fClipboardFormat = "";

    public HGVectorOutputHelper(MPrintJob mPrintJob, VectorHelperDefinition vectorHelperDefinition, VectorStrategy vectorStrategy) {
        super(mPrintJob);
        this.fPrintJob = mPrintJob;
        this.fCreatorInfo = vectorHelperDefinition;
        this.fOutputGenerator = vectorStrategy;
    }

    @Override
    public void open(FigurePanelContainer figurePanelContainer) throws OutputHelperProcessingException {
        String string = this.fPrintJob.getFilename();
        if (string.length() == 0 && this.fCreatorInfo.supportsClipboard()) {
            this.fStream = new ByteArrayOutputStream();
            this.fToClipboard = true;
            this.fClipboardFormat = HGVectorOutputHelper.driverToClipboardFormat(this.fPrintJob.getDriver());
        } else {
            try {
                this.fStream = new FileOutputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new OutputHelperProcessingException(fileNotFoundException.getMessage());
            }
            this.fToClipboard = false;
            this.fClipboardFormat = "";
            this.fStream = new BufferedOutputStream(this.fStream);
        }
        try {
            this.fCurrentLog = HGVectorOutputHelper.setApacheLogLevel("error");
            this.fStrategyGraphics = this.fOutputGenerator.startJob(this.fPrintJob, this.fStream, figurePanelContainer);
        }
        catch (OutputProcessingException outputProcessingException) {
            throw new OutputHelperProcessingException(outputProcessingException);
        }
        this.fGraphics = this.fStrategyGraphics;
        if (this.fPrintJob.isUseCMYKColorspace()) {
            this.fGraphics = new ColorConvertingGraphics2D(this.fGraphics, new CMYKColorConverter());
        }
        if (this.fPrintJob.isGrayscale()) {
            this.fGraphics = new ColorConvertingGraphics2D(this.fGraphics, new GrayColorConverter());
        }
        this.fGraphics = new ColorConvertingGraphics2D(this.fGraphics, new OpaqueAlphaRemover());
    }

    private static String setApacheLogLevel(String string) {
        String string2 = System.getProperty("org.apache.commons.logging.simplelog.defaultlog");
        if (string2 == null) {
            string2 = "info";
        }
        System.setProperty("org.apache.commons.logging.simplelog.defaultlog", string);
        return string2;
    }

    private static String driverToClipboardFormat(String string) {
        if (string.startsWith("pdfwrite")) {
            return "pdf";
        }
        if (string.startsWith("meta")) {
            return "emf";
        }
        return "";
    }

    @Override
    public void beginPage() throws OutputHelperProcessingException {
        try {
            this.fOutputGenerator.startPage(this.fPrintJob, this.fStrategyGraphics, this.fStream);
        }
        catch (OutputProcessingException outputProcessingException) {
            throw new OutputHelperProcessingException(outputProcessingException);
        }
    }

    @Override
    public void generateOutput(final FigurePanelContainer figurePanelContainer) throws OutputHelperProcessingException {
        this.validateContainerState(figurePanelContainer.getTargetContainer());
        final Graphics2D graphics2D = (Graphics2D)this.fGraphics.create(0, 0, this.fPrintJob.getDesired_Width(), this.fPrintJob.getDesired_Height());
        final Exception[] exceptionArray = new Exception[1];
        Throwable throwable = null;
        try {
            AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    assert (GraphicsEnvironment.isHeadless() || figurePanelContainer.getTargetContainer().isDisplayable()) : "Expected the container to be displayable before generating output.";
                    HGVectorOutputHelper.this.validateContainerSize(figurePanelContainer.getTargetContainer());
                    HGVectorOutputHelper.this.prePrint(figurePanelContainer.getTargetContainer());
                    try {
                        HGOutputFlags hGOutputFlags = HGVectorOutputHelper.this.setFlagsFromPrintjob(HGVectorOutputHelper.this.fPrintJob);
                        exceptionArray[0] = figurePanelContainer.printFigurePanel(graphics2D, hGOutputFlags);
                    }
                    finally {
                        HGVectorOutputHelper.this.postPrint();
                    }
                }
            });
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (exceptionArray[0] != null) {
            throw new OutputHelperProcessingException(exceptionArray[0]);
        }
        if (throwable != null) {
            throw new OutputHelperProcessingException(throwable);
        }
    }

    @Override
    public void endPage() throws OutputHelperProcessingException {
        try {
            this.fOutputGenerator.endPage(this.fStrategyGraphics, this.fStream);
        }
        catch (OutputProcessingException outputProcessingException) {
            throw new OutputHelperProcessingException(outputProcessingException);
        }
    }

    @Override
    public void close() throws OutputHelperProcessingException {
        try {
            this.fOutputGenerator.endJob(this.fStrategyGraphics, this.fStream);
            HGVectorOutputHelper.setApacheLogLevel(this.fCurrentLog);
        }
        catch (OutputProcessingException outputProcessingException) {
            throw new OutputHelperProcessingException(outputProcessingException);
        }
        try {
            this.fStream.close();
        }
        catch (IOException iOException) {
            throw new OutputHelperProcessingException(iOException);
        }
        if (this.fToClipboard) {
            try {
                ExportClipboardHelper exportClipboardHelper = new ExportClipboardHelper(this.fClipboardFormat, (ByteArrayOutputStream)this.fStream);
                exportClipboardHelper.copyToClipboard();
            }
            catch (UnsupportedFlavorException | IOException exception) {
                throw new OutputHelperProcessingException(exception);
            }
        }
    }

    @Override
    public boolean supportsGettingCDataFromBufferedImage() {
        return this.fCreatorInfo.supportsCData();
    }

    @Override
    public BufferedImage getBufferedImage() throws OutputHelperProcessingException {
        return null;
    }

    @Override
    public boolean supportsMultiplePages() {
        return this.fCreatorInfo.supportsMultipage();
    }

    @Override
    public boolean supportsGettingDataForClipboard() {
        return this.fCreatorInfo.supportsClipboard();
    }

    @Override
    public ByteArrayOutputStream getDataForClipboard() throws OutputHelperProcessingException {
        if (this.fToClipboard) {
            return (ByteArrayOutputStream)this.fStream;
        }
        return null;
    }

    @Override
    public void release() throws OutputHelperProcessingException {
    }
}

