/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.mathworks.hg.peer.FigureValidator;
import com.mathworks.hg.util.HGPeerQueueUser;
import com.mathworks.hg.util.HGPeerReplaceRunnable;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.jmi.AWTUtilities;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class HGPeerQueue {
    private Vector<HGPeerRunnable> fHGPeerRunnables;
    private Hashtable<HGPeerQueueUser, Integer> fHGPeerRemoveRunnables;
    private Map<Object, Integer> fCoalescingTable = null;
    private boolean fNeedEcho = false;
    private int fModalPeerIndex = -1;
    private static Hashtable<Long, HGPeerQueue> sInstanceTable = new Hashtable();
    private final Object fPeerQueueLock = new Object();
    private static Method sGetMCRIDMethod;

    private HGPeerQueue() {
        this.allocateQueue();
    }

    private static long getMCRID() {
        return -1L;
    }

    private static long getMCRID_NEW() {
        Class<?> clazz;
        long l = -1L;
        if (sGetMCRIDMethod == null) {
            Method[] methodArray;
            try {
                clazz = Class.forName("com.mathworks.jmi.NativeMatlab");
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                return l;
            }
            for (Method method : methodArray = clazz.getDeclaredMethods()) {
                if (!method.getName().equals("retrieveMCRID")) continue;
                sGetMCRIDMethod = method;
                method.setAccessible(true);
            }
        }
        try {
            if (sGetMCRIDMethod != null) {
                clazz = null;
                l = (Long)sGetMCRIDMethod.invoke(null, clazz);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return l;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            return l;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocateQueue() {
        Object object = this.fPeerQueueLock;
        synchronized (object) {
            this.fHGPeerRunnables = new Vector(1000);
            this.fHGPeerRemoveRunnables = new Hashtable(397);
            if (this.fCoalescingTable == null) {
                this.fCoalescingTable = new Hashtable<Object, Integer>(997);
            } else {
                this.fCoalescingTable.clear();
            }
            this.fModalPeerIndex = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush(boolean bl) {
        HGPeerRunnablesRunner hGPeerRunnablesRunner = null;
        Object object = this.fPeerQueueLock;
        synchronized (object) {
            if (!this.fHGPeerRunnables.isEmpty()) {
                hGPeerRunnablesRunner = new HGPeerRunnablesRunner(this.fHGPeerRunnables, this.fHGPeerRemoveRunnables);
                this.allocateQueue();
            }
        }
        if (hGPeerRunnablesRunner != null) {
            this.fNeedEcho = true;
            if (bl) {
                try {
                    AWTUtilities.invokeAndWait((Runnable)hGPeerRunnablesRunner);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            } else {
                EventQueue.invokeLater(hGPeerRunnablesRunner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(HGPeerRunnable hGPeerRunnable) {
        Object object = this.fPeerQueueLock;
        synchronized (object) {
            boolean bl;
            int n = this.fHGPeerRunnables.size();
            boolean bl2 = bl = n == 0;
            if (hGPeerRunnable.isCoalescable()) {
                HGPeerReplaceRunnable hGPeerReplaceRunnable = null;
                if (hGPeerRunnable.getMethodType() == 6 && hGPeerRunnable instanceof HGPeerReplaceRunnable) {
                    hGPeerReplaceRunnable = (HGPeerReplaceRunnable)hGPeerRunnable;
                }
                if (this.fCoalescingTable.containsKey(hGPeerRunnable.getKey())) {
                    n = this.fCoalescingTable.get(hGPeerRunnable.getKey());
                    if (null != hGPeerReplaceRunnable) {
                        HGPeerReplaceRunnable hGPeerReplaceRunnable2 = (HGPeerReplaceRunnable)this.fHGPeerRunnables.elementAt(n);
                        hGPeerReplaceRunnable.setSourcePeer(hGPeerReplaceRunnable2.getSourcePeer());
                        this.fCoalescingTable.put(hGPeerReplaceRunnable.getTargetKey(), n);
                    }
                    if (hGPeerRunnable.getMethodType() == 9 || hGPeerRunnable.getMethodType() == 12 || hGPeerRunnable.getMethodType() == 10) {
                        if (n > this.fModalPeerIndex || hGPeerRunnable.getMethodType() == 10) {
                            this.fHGPeerRunnables.setElementAt(null, n);
                            this.fCoalescingTable.put(hGPeerRunnable.getKey(), this.fHGPeerRunnables.size());
                        }
                        this.fHGPeerRunnables.addElement(hGPeerRunnable);
                    } else {
                        this.fHGPeerRunnables.setElementAt(hGPeerRunnable, n);
                    }
                } else {
                    this.fHGPeerRunnables.addElement(hGPeerRunnable);
                    if (null != hGPeerReplaceRunnable) {
                        this.fCoalescingTable.put(hGPeerReplaceRunnable.getTargetKey(), n);
                    } else {
                        this.fCoalescingTable.put(hGPeerRunnable.getKey(), n);
                    }
                }
            } else {
                this.fHGPeerRunnables.addElement(hGPeerRunnable);
            }
            if (hGPeerRunnable.getMethodType() == 1 || hGPeerRunnable.getMethodType() == 6) {
                this.fHGPeerRemoveRunnables.put(hGPeerRunnable.getHGPeer(), n);
            }
            if (hGPeerRunnable.getMethodType() == 12) {
                this.fModalPeerIndex = this.fCoalescingTable.get(hGPeerRunnable.getKey());
            }
            if (bl && !this.fHGPeerRunnables.isEmpty()) {
                HGPeerQueue.setRootUpdatesPendingFlag();
            }
        }
    }

    static HGPeerQueue getInstance() {
        long l = HGPeerQueue.getMCRID();
        if (sInstanceTable.get(l) == null) {
            sInstanceTable.put(l, new HGPeerQueue());
        }
        return sInstanceTable.get(l);
    }

    public boolean isEchoNeeded() {
        return this.fNeedEcho;
    }

    public void clearEchoNeeded() {
        this.fNeedEcho = false;
    }

    private static native void SetRootUpdatesPendingFlag();

    public static void setRootUpdatesPendingFlag() {
        HGPeerQueue.SetRootUpdatesPendingFlag();
    }

    static {
        System.loadLibrary("nativehg");
        sGetMCRIDMethod = null;
    }

    private static class HGPeerRunnablesRunner
    implements Runnable {
        private Vector<HGPeerRunnable> fHGPeerRunnables = null;
        private Map<HGPeerQueueUser, Integer> fHGPeerRemoveRunnables = null;
        private Hashtable<FigureValidator, FigureValidator> fFiguresInFlushing;
        private Vector<Exception> exceptions = null;

        public HGPeerRunnablesRunner(Vector<HGPeerRunnable> vector, Map<HGPeerQueueUser, Integer> map) {
            this.fHGPeerRunnables = new Vector<HGPeerRunnable>(vector);
            this.fHGPeerRemoveRunnables = new Hashtable<HGPeerQueueUser, Integer>(map);
            this.fFiguresInFlushing = new Hashtable(57);
        }

        /*
         * WARNING - void declaration
         */
        private void runit(boolean bl, int[] nArray) {
            int n;
            Vector<Integer> vector = new Vector<Integer>(nArray.length);
            int[] object = nArray;
            int n2 = object.length;
            for (int i = 0; i < n2; ++i) {
                n = object[i];
                vector.add(n);
            }
            Object var4_5 = null;
            for (n2 = 0; n2 < this.fHGPeerRunnables.size(); ++n2) {
                void var4_6;
                HGPeerRunnable hGPeerRunnable = this.fHGPeerRunnables.elementAt(n2);
                if (hGPeerRunnable == null) continue;
                n = vector.contains(hGPeerRunnable.getMethodType()) ? 1 : 0;
                if (!bl ? n != 0 : n == 0) continue;
                if (this.fHGPeerRemoveRunnables.containsKey(hGPeerRunnable.getHGPeer()) && hGPeerRunnable.getMethodType() != 1 && hGPeerRunnable.getMethodType() != 6) continue;
                try {
                    HGPeerQueueUser hGPeerQueueUser;
                    if (hGPeerRunnable.getMethodType() == 1) {
                        hGPeerQueueUser = hGPeerRunnable.getHGPeer();
                        FigureValidator figureValidator = hGPeerQueueUser.getParentFigureValidator();
                        hGPeerRunnable.run();
                    } else {
                        hGPeerRunnable.run();
                        hGPeerQueueUser = hGPeerRunnable.getMethodType() == 6 ? ((HGPeerReplaceRunnable)hGPeerRunnable).getTargetPeer() : hGPeerRunnable.getHGPeer();
                        FigureValidator figureValidator = hGPeerQueueUser.getParentFigureValidator();
                    }
                    this.fHGPeerRunnables.setElementAt(null, n2);
                }
                catch (Exception exception) {
                    if (this.exceptions == null) {
                        this.exceptions = new Vector(10);
                    }
                    this.exceptions.add(exception);
                }
                if (var4_6 == null) continue;
                this.fFiguresInFlushing.put((FigureValidator)var4_6, (FigureValidator)var4_6);
            }
        }

        private void runThese(int[] nArray) {
            this.runit(true, nArray);
        }

        private void runNotThese(int[] nArray) {
            this.runit(false, nArray);
        }

        @Override
        public void run() {
            this.runThese(new int[]{10});
            this.runThese(new int[]{1});
            this.runThese(new int[]{2});
            this.runNotThese(new int[]{9, 12, 11});
            Enumeration<FigureValidator> enumeration = this.fFiguresInFlushing.keys();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement().validateFigure();
            }
            this.runThese(new int[]{9, 12});
            this.runThese(new int[]{11});
            if (this.exceptions != null) {
                for (int i = 0; i < this.exceptions.size(); ++i) {
                    Exception exception = this.exceptions.elementAt(i);
                    if (exception == null) continue;
                    exception.printStackTrace();
                }
            }
        }
    }
}

