/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import java.awt.Font;
import java.io.FileInputStream;
import java.util.Vector;

public final class FontNameTranslator {
    private static FontNameTranslator theTranslator = new FontNameTranslator();
    private Vector fTable = new Vector(5, 5);
    static final String pathToTrueTypeFonts = "/usr/X11R6/lib/X11/fonts/TrueType/";

    public static FontNameTranslator getTranslator() {
        return theTranslator;
    }

    private FontNameTranslator() {
        this.addDefaultTranslations();
    }

    private void addDefaultTranslations() {
        this.addFontTranslation("MS Sans Serif", "SansSerif", null);
        this.addFontTranslation("courier", "Courier New", null);
        this.addFontTranslation("times", "Times New Roman", null);
        this.addFontTranslation("comic", "Comic Sans MS", null);
        this.addFontTranslation("trebuchet", "Trebuchet MS", null);
    }

    private void addFontTranslation(String string, String string2, String string3) {
        if (!this.isFontAvailable(string2)) {
            return;
        }
        FontNameTable fontNameTable = new FontNameTable(string, string2, string3);
        this.fTable.add(fontNameTable);
    }

    private boolean isFontAvailable(String string) {
        Font font = new Font(string, 0, 10);
        return !font.getFamily().equals("Dialog");
    }

    public void reset() {
        this.fTable.clear();
        this.addDefaultTranslations();
    }

    public String translateFontName(String string) {
        for (int i = 0; i < this.fTable.size(); ++i) {
            FontNameTable fontNameTable = (FontNameTable)this.fTable.elementAt(i);
            if (fontNameTable.fMatlabName.compareToIgnoreCase(string) != 0) continue;
            this.loadFontIfNeeded(fontNameTable);
            return fontNameTable.fJavaName;
        }
        return string;
    }

    public Font getFontFromName(String string) {
        for (int i = 0; i < this.fTable.size(); ++i) {
            FontNameTable fontNameTable = (FontNameTable)this.fTable.elementAt(i);
            if (fontNameTable.fMatlabName.compareToIgnoreCase(string) != 0) continue;
            this.loadFontIfNeeded(fontNameTable);
            return fontNameTable.fNormal;
        }
        return null;
    }

    private void loadFontIfNeeded(FontNameTable fontNameTable) {
        if (!fontNameTable.loaded && fontNameTable.fFileName != null) {
            String string = fontNameTable.fFileName;
            String string2 = string + ".ttf";
            try {
                FileInputStream fileInputStream = new FileInputStream(string2);
                fontNameTable.fNormal = Font.createFont(0, fileInputStream);
                fileInputStream.close();
                fontNameTable.loaded = true;
            }
            catch (Exception exception) {
                String string3 = pathToTrueTypeFonts;
                string2 = string3 + string + ".ttf";
                try {
                    FileInputStream fileInputStream = new FileInputStream(string2);
                    fontNameTable.fNormal = Font.createFont(0, fileInputStream);
                    fileInputStream.close();
                    fontNameTable.loaded = true;
                }
                catch (Exception exception2) {
                    return;
                }
            }
        }
    }

    class FontNameTable {
        public String fMatlabName;
        public String fJavaName;
        public String fFileName;
        public boolean loaded = false;
        public Font fNormal = null;

        FontNameTable(String string, String string2, String string3) {
            this.fMatlabName = string;
            this.fJavaName = string2;
            this.fFileName = string3;
        }
    }
}

