/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.uij;

import com.mathworks.hg.uij.RenderingHintsHelper;
import com.mathworks.hg.util.FontConverter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

class TextRasterizer {
    public static final int MODE_BINARY = 1;
    public static final int MODE_GRAY_8 = 3;
    public static final int MODE_TRUE_COLOR = 4;
    public static final int ML_FONT_WEIGHT_LIGHT = 0;
    public static final int ML_FONT_WEIGHT_NORMAL = 1;
    public static final int ML_FONT_WEIGHT_DEMI = 2;
    public static final int ML_FONT_WEIGHT_BOLD = 3;
    public static final int ML_FONT_ANGLE_NORMAL = 0;
    public static final int ML_FONT_ANGLE_ITALIC = 1;
    public static final int ML_FONT_ANGLE_OBLIQUE = 2;
    public static boolean sDebugOutline = false;
    public static boolean sDebugFill = false;
    private RenderingHintsHelper fHintsHelper = new RenderingHintsHelper();
    private Graphics2D fG2D = null;
    private AffineTransform fSavedTransform = null;
    private Font fFont = null;
    private FontRenderContext fFRC = null;
    private AffineTransform fTextXform = null;
    private BufferedImage fImage = null;
    private Graphics2D fSavedG2D = null;
    private byte[] fPixels = null;
    private int fMode = 3;
    private Color fColor = null;
    private LineMetrics fLineMetrics = null;
    private boolean fSmoothing = true;

    TextRasterizer() {
    }

    public static Font createFont(String string, int n, int n2, float f) {
        if (string.length() > 4 && (string.substring(0, 4).equals("mwa_") || string.substring(0, 4).equals("mwb_"))) {
            return FontConverter.convertToJavaFont(string, f, n2, n, 1);
        }
        return FontConverter.convertToJavaFont(string, f, n2, n);
    }

    public void setGraphics2D(Graphics2D graphics2D) {
        this.fG2D = graphics2D;
        if (this.fFont != null) {
            this.fG2D.setFont(this.fFont);
        }
        this.fLineMetrics = null;
    }

    private LineMetrics getLineMetrics() {
        if (this.fLineMetrics == null && this.fFont != null) {
            if (this.fFRC == null) {
                this.createFRC();
            }
            this.fLineMetrics = this.fFont.getLineMetrics("X", this.fFRC);
        }
        return this.fLineMetrics;
    }

    public void setColor(int n) {
        this.fColor = new Color(n);
    }

    public void setFont(Font font) {
        this.fFont = font;
        if (this.fG2D != null) {
            this.fG2D.setFont(font);
        }
        this.fLineMetrics = null;
    }

    public void setMode(int n) {
        this.fMode = n;
    }

    public void setSmoothing(boolean bl) {
        this.fSmoothing = bl;
    }

    public void saveTransform() {
        this.fSavedTransform = this.fG2D.getTransform();
    }

    public void restoreTransform() {
        this.fG2D.setTransform(this.fSavedTransform);
    }

    public void applyTransform(float f, float f2, float f3) {
        this.fG2D.translate(f2, f3);
        this.fG2D.rotate(-f);
    }

    public void drawString(String string, float f, float f2) {
        if (this.fColor == null) {
            this.fG2D.setColor(Color.white);
        } else {
            this.fG2D.setPaint(this.fColor);
        }
        this.applyRenderingHints();
        this.fG2D.drawString(string, f, f2);
    }

    public void drawFilledRectangle(float f, float f2, float f3, float f4) {
        if (this.fColor == null) {
            this.fG2D.setColor(Color.white);
        } else {
            this.fG2D.setPaint(this.fColor);
        }
        this.applyRenderingHints();
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, f3, f4);
        this.fG2D.fill(float_);
    }

    public void createImage(int n, int n2) {
        this.fPixels = null;
        this.fImage = new BufferedImage(n, n2, this.mode_to_type(this.fMode));
        this.fSavedG2D = this.fG2D;
        this.fG2D = (Graphics2D)this.fImage.getGraphics();
        if (sDebugFill) {
            this.fG2D.setColor(new Color(0.7f, 0.7f, 0.7f, 0.5f));
            this.fG2D.fillRect(0, 0, n, n2);
        } else {
            this.fG2D.setColor(new Color(0, true));
            this.fG2D.fillRect(0, 0, n, n2);
        }
        if (sDebugOutline) {
            this.fG2D.setColor(Color.white);
            this.fG2D.draw(new Rectangle(0, 0, n - 1, n2 - 1));
        }
        this.fG2D.setFont(this.fFont);
        this.applyRenderingHints();
    }

    public void tearDownImage() {
        this.fImage = null;
        this.fPixels = null;
        this.fG2D.dispose();
        this.fG2D = this.fSavedG2D;
        this.fSavedG2D = null;
    }

    public byte[] getPixels() {
        if (this.fPixels == null) {
            AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0, -1.0);
            affineTransform.translate(0.0, -this.fImage.getHeight());
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
            BufferedImage bufferedImage = affineTransformOp.filter(this.fImage, null);
            int n = this.fImage.getWidth();
            int n2 = this.fImage.getHeight();
            if (n != bufferedImage.getWidth() || n2 != bufferedImage.getHeight()) {
                System.err.println("Flipping image changed bounds!");
            }
            WritableRaster writableRaster = bufferedImage.getRaster();
            try {
                this.fPixels = (byte[])writableRaster.getDataElements(0, 0, n, n2, null);
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }
        return this.fPixels;
    }

    private void createFRC() {
        this.fFRC = this.createFRC(null);
    }

    private FontRenderContext createFRC(AffineTransform affineTransform) {
        boolean bl = this.fSmoothing && this.fMode != 1;
        boolean bl2 = this.fSmoothing && this.fMode != 1;
        return new FontRenderContext(affineTransform, bl, bl2);
    }

    public void setupForLogicalBounds() {
        if (this.fFRC == null) {
            this.createFRC();
        }
    }

    public void setupForPixelBounds(float f) {
        if (this.fFRC == null) {
            this.createFRC();
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(-f);
        this.fTextXform = affineTransform;
    }

    private int mode_to_type(int n) {
        int n2 = 12;
        switch (n) {
            case 1: {
                n2 = 12;
                break;
            }
            case 3: {
                n2 = 10;
                break;
            }
            case 4: {
                n2 = 6;
            }
        }
        return n2;
    }

    private void applyRenderingHints() {
        this.fHintsHelper.setRenderingHints(this.fG2D, this.fSmoothing && this.fMode != 1);
    }

    public int getAscent() {
        LineMetrics lineMetrics = this.getLineMetrics();
        if (lineMetrics == null) {
            return 0;
        }
        return (int)lineMetrics.getAscent();
    }

    public int getDescent() {
        LineMetrics lineMetrics = this.getLineMetrics();
        if (lineMetrics == null) {
            return 0;
        }
        return (int)lineMetrics.getDescent();
    }

    public int getWidth(String string) {
        return 0;
    }

    public int getHeight() {
        LineMetrics lineMetrics = this.getLineMetrics();
        if (lineMetrics == null) {
            return 0;
        }
        return (int)lineMetrics.getHeight();
    }

    public int getLineSpacing() {
        LineMetrics lineMetrics = this.getLineMetrics();
        if (lineMetrics == null) {
            return 0;
        }
        return (int)lineMetrics.getHeight();
    }

    public double getCapHeight() {
        TextLayout textLayout = new TextLayout("ABCDEFGHIJKLMNOPQRSTUVWXYZ", this.fFont, this.fFRC);
        Rectangle2D rectangle2D = textLayout.getBounds();
        return rectangle2D.getHeight();
    }

    public Rectangle getPixelBounds(String string, float f, float f2) {
        TextLayout textLayout = new TextLayout(string, this.fFont, this.fFRC);
        Rectangle2D rectangle2D = textLayout.getBounds();
        rectangle2D.setRect(rectangle2D.getX() + (double)f, rectangle2D.getY() + (double)f2, rectangle2D.getWidth(), rectangle2D.getHeight());
        return this.computeTransformedPixelBounds(this.fTextXform, rectangle2D);
    }

    private Rectangle computeTransformedPixelBounds(AffineTransform affineTransform, Rectangle2D rectangle2D) {
        int n;
        double[] dArray = new double[]{rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getMaxX(), rectangle2D.getMinY(), rectangle2D.getMaxX(), rectangle2D.getMaxY(), rectangle2D.getMinX(), rectangle2D.getMaxY()};
        double[] dArray2 = new double[8];
        try {
            affineTransform.transform(dArray, 0, dArray2, 0, 4);
        }
        catch (Throwable throwable) {
            System.err.println("caught " + throwable);
        }
        double d = dArray2[0];
        double d2 = dArray2[0];
        double d3 = dArray2[1];
        double d4 = dArray2[1];
        for (n = 1; n < 4; ++n) {
            double d5 = dArray2[2 * n + 0];
            double d6 = dArray2[2 * n + 1];
            if (d5 < d) {
                d = d5;
            } else if (d5 > d2) {
                d2 = d5;
            }
            if (d6 < d3) {
                d3 = d6;
                continue;
            }
            if (!(d6 > d4)) continue;
            d4 = d6;
        }
        n = (int)Math.floor(d);
        int n2 = (int)Math.floor(d3);
        int n3 = (int)Math.ceil(d2);
        int n4 = (int)Math.ceil(d4);
        return new Rectangle(n - 1, n2 - 1, n3 - n + 2, n4 - n2 + 2);
    }

    public Rectangle2D getLogicalBounds(String string) {
        if (this.fFRC == null) {
            this.createFRC();
        }
        return this.fFont.getStringBounds(string, this.fFRC);
    }
}

