/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.table.panel;

import com.mathworks.hg.types.table.panel.AbstractEditorPanel;
import java.util.ArrayList;
import java.util.List;

public enum PropertyPanelEnum {
    TABLE("panels.table", new String[]{"Sortable", "RearrangeableColumns"}),
    COLUMNS("panels.columns", new String[]{"ColumnEditable", "ColumnName", "ColumnFormat", "ColumnWidth", "PropertyMetaData"}),
    ROW_HEADER("panels.rownames", new String[]{"RowName", "PropertyMetaData"}),
    DATA("panels.data", new String[]{"Data", "PropertyMetaData"}),
    ROW_STRIPING("panels.striping", new String[]{"BackgroundColor", "ForegroundColor", "RowStriping"});

    private final String shortDesc;
    private final String longDesc;
    private List<String> propertyList;

    private PropertyPanelEnum(String string2, String[] stringArray) {
        String string3;
        this.shortDesc = string3 = AbstractEditorPanel.EDITOR_RESOURCES.getString(string2);
        this.longDesc = string3;
        this.propertyList = new ArrayList<String>();
        for (String string4 : stringArray) {
            this.propertyList.add(string4);
        }
    }

    private PropertyPanelEnum(String string2, String string3, String[] stringArray) {
        this.shortDesc = AbstractEditorPanel.EDITOR_RESOURCES.getString(string2);
        this.longDesc = AbstractEditorPanel.EDITOR_RESOURCES.getString(string3);
        this.propertyList = new ArrayList<String>();
        for (String string4 : stringArray) {
            this.propertyList.add(string4);
        }
    }

    public String getShortDescription() {
        return this.shortDesc;
    }

    public String getLongDescription() {
        return this.longDesc;
    }

    public String[] getNamesOfCoveredProperties() {
        if (this.propertyList != null) {
            return this.propertyList.toArray(new String[0]);
        }
        return new String[0];
    }

    public static PropertyPanelEnum parseString(String string) {
        for (PropertyPanelEnum propertyPanelEnum : PropertyPanelEnum.values()) {
            if (!propertyPanelEnum.getShortDescription().equals(string)) continue;
            return propertyPanelEnum;
        }
        return null;
    }

    public static PropertyPanelEnum parsePropertyName(String string) {
        PropertyPanelEnum propertyPanelEnum = null;
        for (PropertyPanelEnum propertyPanelEnum2 : PropertyPanelEnum.values()) {
            if (!propertyPanelEnum2.propertyList.contains(string)) continue;
            propertyPanelEnum = propertyPanelEnum2;
            break;
        }
        return propertyPanelEnum;
    }

    public String toString() {
        return this.getShortDescription();
    }
}

