/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types;

import com.mathworks.hg.types.EditPanelWithTable;
import com.mathworks.hg.types.HGLineStyleEnum;
import com.mathworks.hg.types.HGLineStyles;
import com.mathworks.hg.types.HGMarkerStyleEnum;
import com.mathworks.mwt.table.Style;
import com.mathworks.util.IntBuffer;

public class HGLineStylesEditPanel
extends EditPanelWithTable {
    private IntBuffer fLines = new IntBuffer(15, 20);
    private IntBuffer fMarkers = new IntBuffer(15, 20);
    private static final int LINE_COL = 0;
    private static final int MARKER_COL = 2;
    private static final int SEL_COL = 1;
    private static final int NUM_COL = 3;

    public HGLineStylesEditPanel(HGLineStyles hGLineStyles) {
        super(10, 3);
        int n;
        Style style = new Style(256);
        style.setHAlignment(1);
        for (n = 0; n < 3; ++n) {
            this.getTable().setColumnStyle(n, style);
        }
        this.getTable().getColumnOptions().setDefaultWidth(120);
        this.getTable().setColumnWidth(2, 50);
        this.getTable().setColumnWidth(1, 15);
        this.getTable().getColumnOptions().setHeaderVisible(true);
        this.getTable().getColumnOptions().setResizable(false);
        this.getTable().setColumnHeaderData(0, (Object)"Line Style");
        this.getTable().setColumnHeaderData(2, (Object)"Marker Style");
        if (hGLineStyles != null) {
            int n2;
            int[] nArray = hGLineStyles.getLineStyles();
            if (nArray != null) {
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    this.fLines.append(nArray[n2]);
                }
            }
            if ((nArray = hGLineStyles.getMarkers()) != null) {
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    this.fMarkers.append(nArray[n2]);
                }
            }
        }
        n = Math.max(this.fLines.length(), this.fMarkers.length());
        Object[] objectArray = new Object[3];
        for (int i = 0; i < n; ++i) {
            objectArray[0] = i < this.fLines.length() ? new HGLineStyleEnum(this.fLines.getAt(i)) : new HGLineStyleEnum();
            objectArray[2] = i < this.fMarkers.length() ? new HGMarkerStyleEnum(this.fMarkers.getAt(i)) : new HGMarkerStyleEnum();
            this.addDataRow(i, objectArray);
        }
    }

    public HGLineStyles getData() {
        int[] nArray = new int[this.fLines.length()];
        this.fLines.copyInto(0, nArray.length, nArray, 0);
        int[] nArray2 = new int[this.fMarkers.length()];
        this.fMarkers.copyInto(0, nArray2.length, nArray2, 0);
        return new HGLineStyles(nArray, nArray2);
    }

    @Override
    public void doAppend() {
        if (this.fLines.length() == 0) {
            this.fLines.append(0);
            this.fMarkers.append(13);
        } else {
            this.fLines.append(this.fLines.getAt(this.fLines.length() - 1));
            this.fMarkers.append(this.fMarkers.getAt(this.fMarkers.length() - 1));
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = new HGLineStyleEnum(this.fLines.getAt(this.fLines.length() - 1));
        objectArray[2] = new HGMarkerStyleEnum(this.fMarkers.getAt(this.fMarkers.length() - 1));
        this.addDataRow(this.getLastRowIndex() + 1, objectArray);
    }

    @Override
    public void doInsert(int n) {
        this.fLines.insert(n, this.fLines.getAt(n));
        this.fMarkers.insert(n, this.fMarkers.getAt(n));
        Object[] objectArray = new Object[3];
        objectArray[0] = new HGLineStyleEnum(this.fLines.getAt(n));
        objectArray[2] = new HGMarkerStyleEnum(this.fMarkers.getAt(n));
        this.addDataRow(n, objectArray);
    }

    @Override
    public void doDelete(int n) {
        this.fLines.delete(n, n + 1);
        this.fMarkers.delete(n, n + 1);
    }

    @Override
    public boolean valueChanged(int n, int n2, Object object) {
        if (n2 == 0) {
            this.fLines.setAt(n, ((HGLineStyleEnum)((Object)object)).getCurrentValue());
        } else if (n2 == 2) {
            this.fMarkers.setAt(n, ((HGMarkerStyleEnum)((Object)object)).getCurrentValue());
        }
        return true;
    }
}

