/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types;

import com.mathworks.hg.types.HGColorArrayEditor;
import java.awt.Color;
import java.beans.PropertyEditorManager;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class HGColor {
    private volatile double fRed;
    private volatile double fGreen;
    private volatile double fBlue;
    private volatile double alpha;

    public HGColor(double d, double d2, double d3) {
        this(d, d2, d3, 1.0);
    }

    public HGColor(double d, double d2, double d3, double d4) {
        this.fRed = d;
        this.fGreen = d2;
        this.fBlue = d3;
        this.alpha = d4;
    }

    public double getRed() {
        return this.fRed;
    }

    public void setRed(double d) {
        this.fRed = d;
    }

    public double getGreen() {
        return this.fGreen;
    }

    public void setGreen(double d) {
        this.fGreen = d;
    }

    public double getBlue() {
        return this.fBlue;
    }

    public void setBlue(double d) {
        this.fBlue = d;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double d) {
        this.alpha = d;
    }

    private double[] getComponents() {
        return new double[]{this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha()};
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof HGColor) {
            HGColor hGColor = (HGColor)object;
            bl = hGColor.getRed() == this.getRed() && hGColor.getGreen() == this.getGreen() && hGColor.getBlue() == this.getBlue() && hGColor.getAlpha() == this.getAlpha();
        }
        return bl;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.fRed).append(this.fGreen).append(this.fBlue).append(this.alpha).toHashCode();
    }

    public static final Color getColor(HGColor hGColor) {
        Color color = null;
        if (hGColor != null) {
            int n = (int)(hGColor.getRed() * 255.0);
            int n2 = (int)(hGColor.getGreen() * 255.0);
            int n3 = (int)(hGColor.getBlue() * 255.0);
            int n4 = (int)(hGColor.getAlpha() * 255.0);
            if (n < 0) {
                n = 0;
            } else if (n > 255) {
                n = 255;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > 255) {
                n2 = 255;
            }
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 > 255) {
                n3 = 255;
            }
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 > 255) {
                n4 = 255;
            }
            color = new Color(n, n2, n3, n4);
        }
        return color;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    static {
        PropertyEditorManager.registerEditor(HGColor[].class, HGColorArrayEditor.class);
    }
}

