/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print.metafile;

import com.mathworks.hg.print.metafile.AWTToEMFConverter;
import com.mathworks.hg.print.metafile.DefaultEMFWriter;
import com.mathworks.hg.print.metafile.EMFDevice;
import com.mathworks.hg.print.metafile.EMFGraphics2D;
import com.mathworks.hg.print.metafile.EMFState;
import com.mathworks.hg.print.metafile.EMFWriter;
import com.mathworks.hg.print.metafile.GraphicsState;
import com.mathworks.hg.print.metafile.LogicalFontResolver;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EMFDocument {
    private static BufferedImage fFontMetricsImage = null;
    private static final GraphicsState sDefaultState = new GraphicsState();
    private EMFWriter fEMFWriter;
    private EMFWriter.Metafile fMetafile = null;
    private EMFState fWrittenState = null;
    private EMFDevice fDevice = null;
    private boolean fDefaultTextAsShapes = false;
    private Map<String, Boolean> fFontTextAsShapes = new HashMap<String, Boolean>();

    public EMFDocument() {
        this(new DefaultEMFWriter());
    }

    public EMFDocument(EMFWriter eMFWriter) {
        this.fEMFWriter = eMFWriter;
    }

    public Graphics2D createGraphics() {
        return new EMFGraphics2D(this, new GraphicsState());
    }

    public boolean open(int n, float f, float f2) {
        return this.doOpen("", n, f, f2);
    }

    public boolean open(String string, int n, float f, float f2) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Metafile filename must be non-empty");
        }
        return this.doOpen(string, n, f, f2);
    }

    private boolean doOpen(String string, int n, float f, float f2) {
        if (!this.isOpen()) {
            this.fDevice = new EMFDevice(f, f2, n);
            EMFWriter.Size size = this.fEMFWriter.createSize(f, f2);
            this.fMetafile = this.fEMFWriter.createMetafile(string, n, size);
            this.fWrittenState = new EMFState();
            boolean bl = this.fMetafile.begin();
            if (bl) {
                this.fMetafile.setCompositingMode(EMFWriter.Metafile.CompositingMode.SRC_OVER);
            } else {
                this.clear();
            }
            return bl;
        }
        return true;
    }

    public boolean close() {
        if (this.isOpen()) {
            boolean bl = this.fMetafile.end();
            this.clear();
            return bl;
        }
        return false;
    }

    private void clear() {
        this.fMetafile.dispose();
        this.fMetafile = null;
        this.fWrittenState = null;
        this.fDevice = null;
    }

    public boolean isOpen() {
        return this.fMetafile != null;
    }

    public EMFWriter getWriter() {
        return this.fEMFWriter;
    }

    public EMFDevice getDevice() {
        return this.fDevice;
    }

    public String getPath() {
        if (this.isOpen()) {
            return this.fMetafile.getPath();
        }
        return null;
    }

    public void setTextAsShapes(boolean bl) {
        this.fDefaultTextAsShapes = bl;
    }

    public void setTextAsShapes(String string, boolean bl) {
        this.fFontTextAsShapes.put(string, bl);
    }

    public boolean isTextAsShapes() {
        return this.fDefaultTextAsShapes;
    }

    public boolean isTextAsShapes(String string) {
        Boolean bl = this.fFontTextAsShapes.get(string);
        if (bl == null) {
            return this.fDefaultTextAsShapes;
        }
        return bl;
    }

    public void fill(Shape shape, GraphicsState graphicsState) {
        if (!this.isOpen()) {
            return;
        }
        Paint paint = graphicsState.getPaint();
        if (paint instanceof TexturePaint) {
            Object object;
            this.writeTransform(graphicsState.getTransform());
            Shape shape2 = shape;
            if (graphicsState.getClip() != null) {
                object = new Area(shape2);
                ((Area)object).intersect(new Area(graphicsState.getClip()));
                shape2 = object;
            }
            this.writeClip(shape2);
            this.writeSmoothing(graphicsState.getRenderingHint(RenderingHints.KEY_ANTIALIASING));
            this.writeImageSmoothing(graphicsState.getRenderingHint(RenderingHints.KEY_INTERPOLATION));
            object = (TexturePaint)paint;
            BufferedImage bufferedImage = ((TexturePaint)object).getImage();
            Rectangle2D rectangle2D = ((TexturePaint)object).getAnchorRect();
            this.tileImage(bufferedImage, rectangle2D, shape2);
        } else {
            this.writeTransform(graphicsState.getTransform());
            this.writeClip(graphicsState.getClip());
            this.writeSmoothing(graphicsState.getRenderingHint(RenderingHints.KEY_ANTIALIASING));
            this.writeBrush(graphicsState.getPaint());
            PathIterator pathIterator = shape.getPathIterator(null);
            this.writePath(pathIterator);
            this.writeFillMode(pathIterator);
            this.fMetafile.fillPath();
        }
    }

    public void draw(Shape shape, GraphicsState graphicsState) {
        if (!this.isOpen()) {
            return;
        }
        Stroke stroke = graphicsState.getStroke();
        Paint paint = graphicsState.getPaint();
        if (stroke == null || stroke instanceof BasicStroke && !this.hasDashArray((BasicStroke)stroke) && (paint == null || paint instanceof Color || paint instanceof GradientPaint)) {
            this.writeTransform(graphicsState.getTransform());
            this.writeClip(graphicsState.getClip());
            this.writeSmoothing(graphicsState.getRenderingHint(RenderingHints.KEY_ANTIALIASING));
            this.writePen((BasicStroke)stroke, graphicsState.getPaint());
            this.writePath(shape.getPathIterator(null));
            this.fMetafile.strokePath();
        } else {
            shape = stroke.createStrokedShape(shape);
            this.fill(shape, graphicsState);
        }
    }

    private boolean hasDashArray(BasicStroke basicStroke) {
        float[] fArray = basicStroke.getDashArray();
        return fArray != null && fArray.length > 0;
    }

    public void clear(int n, int n2, int n3, int n4, GraphicsState graphicsState) {
        if (!this.isOpen()) {
            return;
        }
        this.writeTransform(graphicsState.getTransform());
        this.writeClip(graphicsState.getClip());
        this.writeBrush(graphicsState.getBackground());
        Path2D.Float float_ = new Path2D.Float();
        ((Path2D)float_).moveTo(n, n2);
        ((Path2D)float_).lineTo(n + n3, n2);
        ((Path2D)float_).lineTo(n + n3, n2 + n4);
        ((Path2D)float_).lineTo(n, n2 + n4);
        float_.closePath();
        PathIterator pathIterator = float_.getPathIterator(null);
        this.writePath(pathIterator);
        this.writeFillMode(pathIterator);
        this.fMetafile.fillPath();
    }

    public FontRenderContext getFontRenderContext(RenderingHints renderingHints) {
        Object object;
        if (!this.isOpen()) {
            return null;
        }
        Object object2 = renderingHints.get(RenderingHints.KEY_TEXT_ANTIALIASING);
        if (object2 == null) {
            object2 = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
        }
        if ((object = renderingHints.get(RenderingHints.KEY_FRACTIONALMETRICS)) == null) {
            object = RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT;
        }
        AffineTransform affineTransform = this.getDevice().getDefaultConfiguration().getNormalizingTransform();
        return new FontRenderContext(affineTransform, object2, object);
    }

    public FontMetrics getFontMetrics(Font font, RenderingHints renderingHints) {
        if (!this.isOpen()) {
            return null;
        }
        if (fFontMetricsImage == null) {
            fFontMetricsImage = new BufferedImage(1, 1, 2);
        }
        Graphics2D graphics2D = fFontMetricsImage.createGraphics();
        FontRenderContext fontRenderContext = this.getFontRenderContext(renderingHints);
        graphics2D.setTransform(fontRenderContext.getTransform());
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        graphics2D.dispose();
        return fontMetrics;
    }

    public void drawString(String string, float f, float f2, GraphicsState graphicsState) {
        if (!this.isOpen() || string == null || string.length() == 0) {
            return;
        }
        if (this.isTextAsShapes(graphicsState.getFont().getFamily()) || graphicsState.getPaint() != null && !(graphicsState.getPaint() instanceof Color)) {
            TextLayout textLayout = new TextLayout(string, graphicsState.getFont(), this.getFontRenderContext(graphicsState.getRenderingHints()));
            Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(f, f2));
            RenderingHints renderingHints = graphicsState.getRenderingHints();
            Object object = this.textAAHintToSmoothing(graphicsState.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING));
            graphicsState.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            this.fill(shape, graphicsState);
            graphicsState.setRenderingHints(renderingHints);
        } else {
            this.writeTransform(graphicsState.getTransform());
            this.writeClip(graphicsState.getClip());
            this.writeTextColor(graphicsState.getPaint());
            List<LogicalFontResolver.FontStringPair> list = LogicalFontResolver.resolveFonts(graphicsState.getFont(), string);
            LogicalFontResolver.FontStringPair fontStringPair = null;
            for (LogicalFontResolver.FontStringPair fontStringPair2 : list) {
                if (fontStringPair != null) {
                    FontMetrics fontMetrics = this.getFontMetrics(fontStringPair.getFont(), graphicsState.getRenderingHints());
                    f += (float)fontMetrics.stringWidth(fontStringPair.getString());
                }
                this.drawSingleString(fontStringPair2.getString(), f, f2, fontStringPair2.getFont());
                fontStringPair = fontStringPair2;
            }
        }
    }

    private void drawSingleString(String string, float f, float f2, Font font) {
        if (string == null) {
            return;
        }
        this.writeFont(font);
        EMFWriter.Point point = AWTToEMFConverter.createPoint(this.fEMFWriter, new Point2D.Float(f, f2));
        this.fMetafile.drawText(point, string);
        point.dispose();
    }

    private Object textAAHintToSmoothing(Object object) {
        if (object == null) {
            return RenderingHints.VALUE_ANTIALIAS_DEFAULT;
        }
        if (object == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
            return RenderingHints.VALUE_ANTIALIAS_OFF;
        }
        if (object == RenderingHints.VALUE_TEXT_ANTIALIAS_ON) {
            return RenderingHints.VALUE_ANTIALIAS_ON;
        }
        return RenderingHints.VALUE_ANTIALIAS_DEFAULT;
    }

    public void drawImage(RenderedImage renderedImage, AffineTransform affineTransform, GraphicsState graphicsState) {
        BufferedImage bufferedImage;
        Object object;
        if (!this.isOpen() || renderedImage == null) {
            return;
        }
        AffineTransform affineTransform2 = graphicsState.getTransform();
        this.writeTransform(affineTransform2);
        this.writeClip(graphicsState.getClip());
        float f = 0.0f;
        float f2 = 0.0f;
        if (affineTransform != null && !affineTransform.isIdentity()) {
            int n = affineTransform.getType();
            if (n != 0 && (n & 1) == n) {
                f = (float)affineTransform.getTranslateX();
                f2 = (float)affineTransform.getTranslateY();
            } else if (affineTransform2 == null) {
                this.writeTransform(affineTransform);
            } else {
                object = (AffineTransform)affineTransform2.clone();
                ((AffineTransform)object).concatenate(affineTransform);
                this.writeTransform((AffineTransform)object);
            }
        }
        if (!(renderedImage instanceof BufferedImage)) {
            bufferedImage = new BufferedImage(renderedImage.getWidth(), renderedImage.getHeight(), 2);
            object = bufferedImage.createGraphics();
            ((Graphics2D)object).drawRenderedImage(renderedImage, new AffineTransform());
            ((Graphics)object).dispose();
        } else {
            bufferedImage = (BufferedImage)renderedImage;
        }
        this.writeSmoothing(graphicsState.getRenderingHint(RenderingHints.KEY_ANTIALIASING));
        this.writeImageSmoothing(graphicsState.getRenderingHint(RenderingHints.KEY_INTERPOLATION));
        object = AWTToEMFConverter.createImage(this.fEMFWriter, bufferedImage);
        EMFWriter.Rect rect = AWTToEMFConverter.createRect(this.fEMFWriter, f, f2, f + (float)bufferedImage.getWidth(), f2 + (float)bufferedImage.getHeight());
        this.fMetafile.drawImage((EMFWriter.Image)object, rect);
        object.dispose();
        rect.dispose();
    }

    private void tileImage(BufferedImage bufferedImage, Rectangle2D rectangle2D, Shape shape) {
        EMFWriter.Image image = AWTToEMFConverter.createImage(this.fEMFWriter, bufferedImage);
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        Rectangle2D rectangle2D2 = shape.getBounds2D();
        double d3 = this.moveBefore(rectangle2D.getMinX(), d, rectangle2D2.getMinX());
        double d4 = this.moveBefore(rectangle2D.getMinY(), d2, rectangle2D2.getMinY());
        double d5 = d3;
        double d6 = 0.0;
        while (d5 < rectangle2D2.getMaxX()) {
            d5 = d3 + d6 * rectangle2D.getWidth();
            double d7 = d4;
            double d8 = 0.0;
            while (d7 < rectangle2D2.getMaxY()) {
                d7 = d4 + d8 * rectangle2D.getHeight();
                if (shape.intersects(d5, d7, d, d2)) {
                    EMFWriter.Rect rect = AWTToEMFConverter.createRect(this.fEMFWriter, (float)d5, (float)d7, (float)(d5 + d), (float)(d7 + d2));
                    this.fMetafile.drawImage(image, rect);
                    rect.dispose();
                }
                d8 += 1.0;
            }
            d6 += 1.0;
        }
        image.dispose();
    }

    private double moveBefore(double d, double d2, double d3) {
        if (d > d3) {
            double d4 = Math.ceil((d - d3) / d2);
            d -= d4 * d2;
        }
        return d;
    }

    private void writePath(PathIterator pathIterator) {
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        this.fMetafile.beginPath();
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    f = fArray[0];
                    f2 = fArray[1];
                    this.fMetafile.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    f = fArray[0];
                    f2 = fArray[1];
                    this.fMetafile.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    fArray[4] = fArray[2];
                    fArray[5] = fArray[3];
                    fArray[2] = (2.0f * fArray[0] + fArray[4]) / 3.0f;
                    fArray[3] = (2.0f * fArray[1] + fArray[5]) / 3.0f;
                    fArray[0] = (f + 2.0f * fArray[0]) / 3.0f;
                    fArray[1] = (f2 + 2.0f * fArray[1]) / 3.0f;
                }
                case 3: {
                    f = fArray[4];
                    f2 = fArray[5];
                    EMFWriter.Point[] pointArray = new EMFWriter.Point[]{this.fEMFWriter.createPoint(fArray[0], fArray[1]), this.fEMFWriter.createPoint(fArray[2], fArray[3]), this.fEMFWriter.createPoint(fArray[4], fArray[5])};
                    this.fMetafile.polyBezierTo(pointArray);
                    pointArray[0].dispose();
                    pointArray[1].dispose();
                    pointArray[2].dispose();
                    break;
                }
                case 4: {
                    this.fMetafile.closeFigure();
                    break;
                }
            }
            pathIterator.next();
        }
        this.fMetafile.endPath();
    }

    private void writeImageSmoothing(Object object) {
        Object object2;
        if (object == null) {
            object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        }
        if (this.equalsWithNull(object, object2 = this.fWrittenState.getImageSmoothingHint())) {
            return;
        }
        boolean bl = object != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        this.fMetafile.setImageSmoothing(bl);
        this.fWrittenState.setImageSmoothingHint(object);
    }

    private void writeSmoothing(Object object) {
        Object object2;
        if (object == null) {
            object = RenderingHints.VALUE_ANTIALIAS_DEFAULT;
        }
        if (this.equalsWithNull(object, object2 = this.fWrittenState.getSmoothingHint())) {
            return;
        }
        if (object == RenderingHints.VALUE_ANTIALIAS_OFF) {
            this.fMetafile.setSmoothingMode(EMFWriter.Metafile.SmoothingMode.NONE);
        } else if (object == RenderingHints.VALUE_ANTIALIAS_ON) {
            this.fMetafile.setSmoothingMode(EMFWriter.Metafile.SmoothingMode.ANTIALIAS);
        } else {
            this.fMetafile.setSmoothingMode(EMFWriter.Metafile.SmoothingMode.DEFAULT);
        }
        this.fWrittenState.setSmoothingHint(object);
    }

    private void writeFillMode(PathIterator pathIterator) {
        if (pathIterator.getWindingRule() == 0) {
            this.fMetafile.setPolygonFillMode(EMFWriter.Metafile.PolygonFillMode.ALTERNATE);
        } else {
            this.fMetafile.setPolygonFillMode(EMFWriter.Metafile.PolygonFillMode.WINDING);
        }
    }

    private void writeTransform(AffineTransform affineTransform) {
        AffineTransform affineTransform2;
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        if ((affineTransform2 = this.fWrittenState.getTransform()) == null) {
            affineTransform2 = new AffineTransform();
        }
        if (affineTransform.equals(affineTransform2)) {
            return;
        }
        this.fMetafile.setXForm((float)affineTransform.getScaleX(), (float)affineTransform.getShearY(), (float)affineTransform.getShearX(), (float)affineTransform.getScaleY(), (float)affineTransform.getTranslateX(), (float)affineTransform.getTranslateY());
        this.fWrittenState.setTransform(affineTransform);
    }

    private void writeClip(Shape shape) {
        if (this.equalsWithNull(shape, this.fWrittenState.getClip()) && (shape == null || this.equalsWithNull(this.fWrittenState.getTransform(), this.fWrittenState.getClipTransform()))) {
            return;
        }
        if (shape == null) {
            this.fMetafile.resetClip();
        } else if (shape instanceof Rectangle2D) {
            EMFWriter.Rect rect = AWTToEMFConverter.createRect(this.fEMFWriter, (Rectangle2D)shape);
            this.fMetafile.selectClipRegion(new EMFWriter.Rect[]{rect}, EMFWriter.Metafile.ClipOp.REPLACE);
            rect.dispose();
        } else {
            this.writePath(shape.getPathIterator(null));
            this.fMetafile.selectClipPath(EMFWriter.Metafile.ClipOp.REPLACE);
        }
        this.fWrittenState.setClip(shape);
        this.fWrittenState.setClipTransform(this.fWrittenState.getTransform());
    }

    private void writeFont(Font font) {
        if (font == null) {
            font = sDefaultState.getFont();
        }
        if (font.equals(this.fWrittenState.getFont())) {
            return;
        }
        EMFWriter.Font font2 = AWTToEMFConverter.createFont(this.fEMFWriter, font, this.fDevice.getDPI());
        this.fMetafile.setFont(font2);
        font2.dispose();
        this.fWrittenState.setFont(font);
    }

    private void writeBrush(Paint paint) {
        if (paint == null) {
            paint = sDefaultState.getPaint();
        }
        if (paint.equals(this.fWrittenState.getPaint())) {
            return;
        }
        EMFWriter.Brush brush = AWTToEMFConverter.createBrush(this.fEMFWriter, paint);
        this.fMetafile.setBrush(brush);
        brush.dispose();
        this.fWrittenState.setPaint(paint);
    }

    private void writePen(BasicStroke basicStroke, Paint paint) {
        if (paint == null) {
            paint = sDefaultState.getPaint();
        }
        if (basicStroke == null) {
            basicStroke = new BasicStroke();
        }
        if (basicStroke.equals(this.fWrittenState.getPenStroke()) && paint.equals(this.fWrittenState.getPenPaint())) {
            return;
        }
        EMFWriter.Pen pen = AWTToEMFConverter.createPen(this.fEMFWriter, basicStroke, paint);
        this.fMetafile.setPen(pen);
        pen.dispose();
        this.fWrittenState.setPenStroke(basicStroke);
        this.fWrittenState.setPenPaint(paint);
    }

    private void writeTextColor(Paint paint) {
        if (paint == null) {
            paint = sDefaultState.getPaint();
        }
        Color color = Color.BLACK;
        if (paint != null && paint instanceof Color) {
            color = (Color)paint;
        }
        if (color.equals(this.fWrittenState.getTextColor())) {
            return;
        }
        EMFWriter.Color color2 = AWTToEMFConverter.createColor(this.fEMFWriter, color);
        this.fMetafile.setTextColor(color2);
        color2.dispose();
        this.fWrittenState.setTextColor(color);
    }

    private boolean equalsWithNull(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object != null) {
            return object.equals(object2);
        }
        return false;
    }
}

