/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print.metafile;

import com.mathworks.hg.print.metafile.EMFWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public abstract class AWTToEMFConverter {
    public static EMFWriter.Color createColor(EMFWriter eMFWriter, Color color) {
        return eMFWriter.createColor(color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue());
    }

    public static EMFWriter.Point createPoint(EMFWriter eMFWriter, Point2D point2D) {
        return eMFWriter.createPoint((float)point2D.getX(), (float)point2D.getY());
    }

    public static EMFWriter.Rect createRect(EMFWriter eMFWriter, Rectangle2D rectangle2D) {
        return AWTToEMFConverter.createRect(eMFWriter, (float)rectangle2D.getMinX(), (float)rectangle2D.getMinY(), (float)rectangle2D.getMaxX(), (float)rectangle2D.getMaxY());
    }

    public static EMFWriter.Rect createRect(EMFWriter eMFWriter, float f, float f2, float f3, float f4) {
        return eMFWriter.createRect(f, f2, f3, f4);
    }

    public static EMFWriter.Image createImage(EMFWriter eMFWriter, BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = bufferedImage.getRGB(0, 0, n, n2, null, 0, n);
        return eMFWriter.createImage(nArray, n, n2);
    }

    public static EMFWriter.Brush createBrush(EMFWriter eMFWriter, Paint paint) {
        EMFWriter.Brush brush;
        if (paint instanceof Color) {
            brush = AWTToEMFConverter.createBrush(eMFWriter, (Color)paint);
        } else if (paint instanceof GradientPaint) {
            brush = AWTToEMFConverter.createBrush(eMFWriter, (GradientPaint)paint);
        } else {
            EMFWriter.Color color = eMFWriter.createColor(0, 0, 0);
            brush = eMFWriter.createBrush(color);
            color.dispose();
        }
        return brush;
    }

    private static EMFWriter.Brush createBrush(EMFWriter eMFWriter, Color color) {
        EMFWriter.Color color2 = AWTToEMFConverter.createColor(eMFWriter, color);
        EMFWriter.Brush brush = eMFWriter.createBrush(color2);
        color2.dispose();
        return brush;
    }

    private static EMFWriter.Brush createBrush(EMFWriter eMFWriter, GradientPaint gradientPaint) {
        EMFWriter.Gradient gradient = eMFWriter.createGradient(AWTToEMFConverter.createPoint(eMFWriter, gradientPaint.getPoint1()), AWTToEMFConverter.createPoint(eMFWriter, gradientPaint.getPoint2()), AWTToEMFConverter.createColor(eMFWriter, gradientPaint.getColor1()), AWTToEMFConverter.createColor(eMFWriter, gradientPaint.getColor2()));
        EMFWriter.Brush brush = eMFWriter.createBrush(gradient);
        gradient.dispose();
        return brush;
    }

    public static EMFWriter.Pen createPen(EMFWriter eMFWriter, BasicStroke basicStroke, Paint paint) {
        EMFWriter.Brush brush = AWTToEMFConverter.createBrush(eMFWriter, paint);
        EMFWriter.Pen pen = eMFWriter.createPen(brush, basicStroke.getLineWidth());
        brush.dispose();
        pen.setEndCap(AWTToEMFConverter.javaToEMFEndCap(basicStroke.getEndCap()));
        pen.setLineJoin(AWTToEMFConverter.javaToEMFLineJoin(basicStroke.getLineJoin()));
        return pen;
    }

    private static EMFWriter.Pen.EndCap javaToEMFEndCap(int n) {
        switch (n) {
            case 2: {
                return EMFWriter.Pen.EndCap.SQUARE;
            }
            case 1: {
                return EMFWriter.Pen.EndCap.ROUND;
            }
        }
        return EMFWriter.Pen.EndCap.FLAT;
    }

    private static EMFWriter.Pen.LineJoin javaToEMFLineJoin(int n) {
        switch (n) {
            case 2: {
                return EMFWriter.Pen.LineJoin.BEVEL;
            }
            case 1: {
                return EMFWriter.Pen.LineJoin.ROUND;
            }
        }
        return EMFWriter.Pen.LineJoin.MITER;
    }

    public static EMFWriter.Font createFont(EMFWriter eMFWriter, Font font, float f) {
        float f2 = font.getSize2D();
        EMFWriter.Font font2 = eMFWriter.createFont(font.getFamily(), f2 *= 72.0f / f);
        switch (font.getStyle()) {
            case 1: {
                font2.setTypeStyle(EMFWriter.Font.TypeStyle.BOLD);
                break;
            }
            case 2: {
                font2.setTypeStyle(EMFWriter.Font.TypeStyle.ITALIC);
                break;
            }
            case 3: {
                font2.setTypeStyle(EMFWriter.Font.TypeStyle.BOLD_ITALIC);
                break;
            }
            default: {
                font2.setTypeStyle(EMFWriter.Font.TypeStyle.REGULAR);
            }
        }
        return font2;
    }
}

