/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import com.mathworks.hg.peer.FigurePanelContainer;
import com.mathworks.hg.print.FOPFontConfigurator;
import com.mathworks.hg.print.Graphics2DDecorator;
import com.mathworks.hg.print.OutputProcessingException;
import com.mathworks.hg.print.PaintConvertingGraphics2D;
import com.mathworks.hg.print.VectorStrategy;
import com.mathworks.hg.print.metafile.EMFDocument;
import com.mathworks.hg.print.metafile.EMFGraphics2D;
import com.mathworks.hg.print.metafile.EMFWriter;
import com.mathworks.hg.print.metafile.LogEMFWriter;
import com.mathworks.hg.util.MPrintJob;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Vector;

public class MWEMFVectorStrategy
implements VectorStrategy {
    @Override
    public Graphics startJob(MPrintJob mPrintJob, OutputStream outputStream, FigurePanelContainer figurePanelContainer) throws OutputProcessingException {
        Object object;
        Serializable serializable;
        EMFDocument eMFDocument = this.createDocument();
        if (mPrintJob.isOpenGLRenderer()) {
            eMFDocument.setTextAsShapes(true);
        } else {
            eMFDocument.setTextAsShapes(false);
            serializable = FOPFontConfigurator.getCMFontNames();
            Iterator<String> iterator = ((Vector)serializable).iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                eMFDocument.setTextAsShapes((String)object, true);
            }
        }
        serializable = null;
        try {
            serializable = File.createTempFile("emf", null, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (serializable == null) {
            throw new OutputProcessingException("Unable to create temp file");
        }
        int n = Math.round((float)mPrintJob.getDesired_Width() / mPrintJob.getPaperPosition_Width());
        object = mPrintJob.getSourceSize();
        eMFDocument.open(((File)serializable).getAbsolutePath(), n, (float)((Dimension)object).getWidth(), (float)((Dimension)object).getHeight());
        Graphics2D graphics2D = eMFDocument.createGraphics();
        graphics2D = new PaintConvertingGraphics2D((Graphics)graphics2D);
        return graphics2D;
    }

    protected EMFDocument createDocument() {
        return new EMFDocument();
    }

    @Override
    public void startPage(MPrintJob mPrintJob, Graphics graphics, OutputStream outputStream) throws OutputProcessingException {
    }

    @Override
    public void endPage(Graphics graphics, OutputStream outputStream) throws OutputProcessingException {
    }

    @Override
    public void endJob(Graphics graphics, OutputStream outputStream) throws OutputProcessingException {
        if (graphics instanceof Graphics2DDecorator && (graphics = ((Graphics2DDecorator)graphics).getUndecoratedGraphics()) instanceof EMFGraphics2D) {
            Object object;
            EMFDocument eMFDocument = ((EMFGraphics2D)graphics).getDocument();
            String string = eMFDocument.getPath();
            eMFDocument.close();
            EMFWriter eMFWriter = eMFDocument.getWriter();
            if (eMFWriter instanceof LogEMFWriter) {
                object = new PrintStream(outputStream);
                Vector<String> vector = ((LogEMFWriter)eMFWriter).getActions();
                for (String string2 : vector) {
                    ((PrintStream)object).println(string2);
                }
            } else {
                try {
                    Files.copy(Paths.get(string, new String[0]), outputStream);
                }
                catch (IOException iOException) {
                    throw new OutputProcessingException("Unable to copy temporary file to output stream");
                }
            }
            object = new File(string);
            ((File)object).delete();
        }
    }
}

