/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

public class FontSubstitutionMap {
    private static FontSubstitutionMap sDefaultMap = new FontSubstitutionMap();
    private List<FontSubstitution> fFontSubstitutions = new ArrayList<FontSubstitution>();

    private FontSubstitutionMap() {
        this.addFontSubstitution("Arial", "(?i)Arial.*", "Helvetica");
        this.addFontSubstitution("Tahoma", "(?i)Tahoma.*", "Helvetica");
        this.addFontSubstitution("MS UI Gothic", "(?i)MS UI Gothic", "Helvetica");
        this.addFontSubstitution("MS Gothic", "(?i)MS Gothic", "Helvetica");
        this.addFontSubstitution("New Century Schoolbook", "(?i)New[ -]*Century[ -]*Schoolbook", "Helvetica");
        this.addFontSubstitution("Sans Serif", "(?i)Sans[ -]*Serif", "Helvetica");
        this.addFontSubstitution("Times New Roman", "(?i)Times[ -]*New[ -]*Roman", "Times-Roman");
        this.addFontSubstitution("Times Roman", "(?i)Times[ -]*Roman", "Times-Roman");
        this.addFontSubstitution("Zapf Dingbats", "(?i)Zapf[ -]*Dingbats", "ZapfDingbats");
        this.addFontSubstitution("Courier New", "(?i)Courier[ -]*New", "Courier");
    }

    public List<FontSubstitution> getFontSubstitutions() {
        return this.fFontSubstitutions;
    }

    public static List<FontSubstitution> getDefaultFontSubstitutions() {
        return sDefaultMap.getFontSubstitutions();
    }

    public static FontSubstitutionMap getDefaultMapping() {
        return sDefaultMap;
    }

    public static void addDefaultFontSubstitution(String string, String string2, String string3) {
        sDefaultMap.addFontSubstitution(string, string2, string3);
    }

    public void addFontSubstitution(String string, String string2, String string3) {
        boolean bl = false;
        for (FontSubstitution fontSubstitution : this.fFontSubstitutions) {
            if (!fontSubstitution.getFontName().equals(string)) continue;
            fontSubstitution.setFontRegex(string2);
            fontSubstitution.setSubstitutionFontName(string3);
            bl = true;
        }
        if (!bl) {
            this.fFontSubstitutions.add(new FontSubstitution(string, string2, string3));
        }
    }

    public static void removeDefaultFontSubstitution(String string) {
        sDefaultMap.removeFontSubstitution(string);
    }

    public void removeFontSubstitution(String string) {
        FontSubstitution fontSubstitution = null;
        for (FontSubstitution fontSubstitution2 : this.fFontSubstitutions) {
            if (!fontSubstitution2.getFontName().equals(string)) continue;
            fontSubstitution = fontSubstitution2;
        }
        if (fontSubstitution != null) {
            this.fFontSubstitutions.remove(fontSubstitution);
        }
    }

    public static Font getFontSubstitution(Font font) {
        String string = FontSubstitutionMap.getFontNameSubstitution(font.getName());
        if (string.equalsIgnoreCase(font.getName())) {
            return font;
        }
        Font font2 = new Font(string, font.getStyle(), font.getSize());
        return font2;
    }

    public static String getFontNameSubstitution(String string) {
        if (string.equalsIgnoreCase("helvetica") || string.equalsIgnoreCase("times") || string.matches("(?i)times[-]*roman") || string.equalsIgnoreCase("courier") || string.equalsIgnoreCase("symbol") || string.matches("(?i)zapf[-]*dingbats") || string.startsWith("mwa_") || string.startsWith("mwb_")) {
            return string;
        }
        for (FontSubstitution fontSubstitution : FontSubstitutionMap.sDefaultMap.fFontSubstitutions) {
            if (!string.matches(fontSubstitution.getFontRegex())) continue;
            return fontSubstitution.getSubstitutionFontName();
        }
        return "Courier";
    }

    public class FontSubstitution {
        private String fFontName;
        private String fFontRegex;
        private String fSubstitutionFontName;

        public FontSubstitution(String string, String string2, String string3) {
            this.fFontName = string;
            this.fFontRegex = string2;
            this.fSubstitutionFontName = string3;
        }

        public String getFontName() {
            return this.fFontName;
        }

        public void setFontName(String string) {
            this.fFontName = string;
        }

        public String getFontRegex() {
            return this.fFontRegex;
        }

        public void setFontRegex(String string) {
            this.fFontRegex = string;
        }

        public String getSubstitutionFontName() {
            return this.fSubstitutionFontName;
        }

        public void setSubstitutionFontName(String string) {
            this.fSubstitutionFontName = string;
        }
    }
}

