/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import com.mathworks.hg.peer.FigurePanelContainer;
import com.mathworks.hg.print.AlphaCompositer;
import com.mathworks.hg.print.BoundingBoxCaptureGraphics;
import com.mathworks.hg.print.ColorConvertingGraphics2D;
import com.mathworks.hg.print.FOPFontConfigurator;
import com.mathworks.hg.print.Graphics2DDecorator;
import com.mathworks.hg.print.ImageScalingGraphics2D;
import com.mathworks.hg.print.MWPSGraphics2D;
import com.mathworks.hg.print.OutputProcessingException;
import com.mathworks.hg.print.PaintConvertingGraphics2D;
import com.mathworks.hg.print.PenOffsetGraphics2D;
import com.mathworks.hg.print.PrintUtilities;
import com.mathworks.hg.print.RenderedImageDrawingGraphics2D;
import com.mathworks.hg.print.StringReplaceOutputStream;
import com.mathworks.hg.print.TextRenderingGraphics2D;
import com.mathworks.hg.print.TextureLimitingGraphics2D;
import com.mathworks.hg.print.VectorStrategy;
import com.mathworks.hg.print.ZeroSizeFontGraphics2D;
import com.mathworks.hg.util.MPrintJob;
import com.mathworks.jmi.NativeMatlab;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.apps.FOPException;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.AbstractPSDocumentGraphics2D;
import org.apache.xmlgraphics.java2d.ps.PSDocumentGraphics2D;
import org.apache.xmlgraphics.ps.DSCConstants;
import org.apache.xmlgraphics.ps.PSGenerator;

public class FOPPSVectorStrategy
implements VectorStrategy {
    private int fLanguageLevel = 3;
    protected BoundingBoxCaptureGraphics bboxCapture = null;
    private String fFilename = null;

    public FOPPSVectorStrategy(int n) {
        this.fLanguageLevel = n;
    }

    public int getLanguageLevel() {
        return this.fLanguageLevel;
    }

    protected AbstractPSDocumentGraphics2D createGraphics(boolean bl, int n, boolean bl2) {
        return new MWPSDocumentGraphics2D(bl, n, bl2);
    }

    protected Dimension getDocumentSize(MPrintJob mPrintJob) {
        return mPrintJob.getRoundedPaperSizeInPoints();
    }

    protected Point2D getOutputOrigin(MPrintJob mPrintJob) {
        Rectangle2D rectangle2D = mPrintJob.getPaperPositionInPoints();
        return new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
    }

    @Override
    public Graphics startJob(MPrintJob mPrintJob, OutputStream outputStream, FigurePanelContainer figurePanelContainer) throws OutputProcessingException {
        boolean bl = !FOPFontConfigurator.canLoadTexFonts();
        this.fFilename = mPrintJob.getFilename();
        bl = bl || mPrintJob.isOpenGLRenderer();
        AbstractPSDocumentGraphics2D abstractPSDocumentGraphics2D = this.createGraphics(bl, this.fLanguageLevel, mPrintJob.getPostScriptTightBBox());
        if (!bl) {
            try {
                FOPFontConfigurator.configurePSFonts(abstractPSDocumentGraphics2D, figurePanelContainer);
            }
            catch (FOPException fOPException) {
                throw new OutputProcessingException(fOPException);
            }
        }
        StringReplaceOutputStream stringReplaceOutputStream = new StringReplaceOutputStream(outputStream);
        outputStream = stringReplaceOutputStream;
        Dimension dimension = this.getDocumentSize(mPrintJob);
        try {
            abstractPSDocumentGraphics2D.setupDocument(outputStream, dimension.width, dimension.height);
        }
        catch (IOException iOException) {
            throw new OutputProcessingException(iOException);
        }
        GraphicContext graphicContext = new GraphicContext();
        abstractPSDocumentGraphics2D.setGraphicContext(graphicContext);
        Point2D point2D = this.getOutputOrigin(mPrintJob);
        Rectangle2D rectangle2D = mPrintJob.getPaperPositionInPoints();
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX(), point2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        Rectangle2D rectangle2D2 = PrintUtilities.pagePositionToJavaPosition(dimension, double_);
        PrintUtilities.setGraphicsPosition((Graphics2D)abstractPSDocumentGraphics2D, mPrintJob.getSourceSize(), rectangle2D2);
        Object object = abstractPSDocumentGraphics2D;
        object = object.create();
        if (object instanceof MWPSGraphics2D) {
            ((MWPSGraphics2D)((Object)object)).setCMYKStreamFixer(stringReplaceOutputStream);
        }
        object = new TextRenderingGraphics2D((Graphics)object);
        object = new RenderedImageDrawingGraphics2D((Graphics)object);
        object = new ImageScalingGraphics2D((Graphics)object);
        object = new PenOffsetGraphics2D((Graphics)object);
        object = new TextureLimitingGraphics2D((Graphics)object);
        object = new ColorConvertingGraphics2D((Graphics)object, new AlphaCompositer());
        object = new PaintConvertingGraphics2D((Graphics)object);
        object = new ZeroSizeFontGraphics2D((Graphics)object);
        if (mPrintJob.getPostScriptTightBBox()) {
            object = new BoundingBoxCaptureGraphics((Graphics)object, this.getDocumentSize(mPrintJob), !mPrintJob.getTransparent(), mPrintJob.getDesired_Width(), mPrintJob.getDesired_Height());
            this.bboxCapture = (BoundingBoxCaptureGraphics)object;
        } else {
            this.bboxCapture = null;
        }
        return object;
    }

    @Override
    public void startPage(MPrintJob mPrintJob, Graphics graphics, OutputStream outputStream) throws OutputProcessingException {
    }

    @Override
    public void endPage(Graphics graphics, OutputStream outputStream) throws OutputProcessingException {
        Graphics2DDecorator graphics2DDecorator = (Graphics2DDecorator)graphics;
        try {
            ((MWPSGraphics2D)((Object)graphics2DDecorator.getUndecoratedGraphics())).getRootDocument().nextPage();
        }
        catch (IOException iOException) {
            throw new OutputProcessingException(iOException);
        }
    }

    @Override
    public void endJob(Graphics graphics, OutputStream outputStream) throws OutputProcessingException {
        Graphics2DDecorator graphics2DDecorator = (Graphics2DDecorator)graphics;
        try {
            ((MWPSGraphics2D)((Object)graphics2DDecorator.getUndecoratedGraphics())).getRootDocument().finish();
        }
        catch (IOException iOException) {
            throw new OutputProcessingException(iOException);
        }
    }

    protected class BBoxPSGenerator
    extends CustomPSGenerator {
        BBoxPSGenerator(OutputStream outputStream) {
            super(outputStream);
        }

        public void writeDSCComment(String string) throws IOException {
            Object[] objectArray;
            super.writeDSCComment(string);
            if (string.equals("Trailer") && (objectArray = FOPPSVectorStrategy.this.bboxCapture.getBBoxArray()) != null) {
                super.writeDSCComment("BoundingBox", objectArray);
            }
        }

        @Override
        public void writeDSCComment(String string, Object[] objectArray) throws IOException {
            if (string.equals("BoundingBox")) {
                super.writeDSCComment("BoundingBox", new Object[]{DSCConstants.ATEND});
            } else {
                super.writeDSCComment(string, objectArray);
            }
        }
    }

    protected class CustomPSGenerator
    extends PSGenerator {
        CustomPSGenerator(OutputStream outputStream) {
            super(outputStream);
        }

        public void writeDSCComment(String string, Object[] objectArray) throws IOException {
            if (string.equals("Creator")) {
                super.writeDSCComment("Creator", new Object[]{"MATLAB, The Mathworks, Inc. Version " + NativeMatlab.GetMatlabVersion() + ". Operating System: " + System.getProperty("os.name")});
                super.writeDSCComment("Title", new Object[]{FOPPSVectorStrategy.this.fFilename.replace("\\", "/")});
            } else if (!string.equals("Title")) {
                super.writeDSCComment(string, objectArray);
            }
        }
    }

    private class MWPSDocumentGraphics2D
    extends PSDocumentGraphics2D {
        private int fLanguageLevel;
        private boolean fTightBBox;

        public MWPSDocumentGraphics2D(boolean bl, int n, boolean bl2) {
            super(bl);
            this.fLanguageLevel = 3;
            this.fTightBBox = true;
            this.fLanguageLevel = n;
            this.fTightBBox = bl2;
        }

        public void setupDocument(OutputStream outputStream, int n, int n2) throws IOException {
            this.width = n;
            this.height = n2;
            this.pagecount = 0;
            this.pagePending = false;
            if (this.fTightBBox) {
                this.setPSGenerator(new BBoxPSGenerator(outputStream));
            } else {
                this.setPSGenerator(new CustomPSGenerator(outputStream));
            }
            this.writeFileHeader();
        }

        public void setPSGenerator(PSGenerator pSGenerator) {
            pSGenerator.setPSLevel(this.fLanguageLevel);
            super.setPSGenerator(pSGenerator);
        }

        public Graphics create() {
            Graphics graphics = super.create();
            return MWPSGraphics2D.createFromGraphics(graphics, (AbstractPSDocumentGraphics2D)this);
        }
    }
}

