/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import com.mathworks.hg.peer.FigurePanelContainer;
import com.mathworks.hg.print.FOPFontConfigurator;
import com.mathworks.hg.print.Graphics2DDecorator;
import com.mathworks.hg.print.ImageScalingGraphics2D;
import com.mathworks.hg.print.OutputProcessingException;
import com.mathworks.hg.print.PenOffsetGraphics2D;
import com.mathworks.hg.print.PrintUtilities;
import com.mathworks.hg.print.RenderedImageDrawingGraphics2D;
import com.mathworks.hg.print.TextRenderingGraphics2D;
import com.mathworks.hg.print.VectorStrategy;
import com.mathworks.hg.util.MPrintJob;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.svg.PDFContext;
import org.apache.fop.svg.PDFDocumentGraphics2D;
import org.apache.xmlgraphics.java2d.GraphicContext;

public class FOPPDFVectorStrategy
implements VectorStrategy {
    private boolean fDontCompressPDF = false;

    public FOPPDFVectorStrategy() {
        this(false);
    }

    private FOPPDFVectorStrategy(boolean bl) {
        this.fDontCompressPDF = bl;
    }

    @Override
    public Graphics startJob(MPrintJob mPrintJob, OutputStream outputStream, FigurePanelContainer figurePanelContainer) throws OutputProcessingException {
        Object object;
        MWPDFGraphics2D mWPDFGraphics2D = null;
        Dimension dimension = mPrintJob.getRoundedPaperSizeInPoints();
        boolean bl = mPrintJob.isOpenGLRenderer();
        try {
            mWPDFGraphics2D = new MWPDFGraphics2D(bl, outputStream, dimension.width, dimension.height);
        }
        catch (IOException iOException) {
            throw new OutputProcessingException(iOException);
        }
        if (!bl) {
            try {
                FOPFontConfigurator.configurePDFFonts(mWPDFGraphics2D, figurePanelContainer);
            }
            catch (ConfigurationException configurationException) {
                if (mWPDFGraphics2D != null) {
                    mWPDFGraphics2D.dispose();
                }
                throw new OutputProcessingException(configurationException);
            }
        }
        GraphicContext graphicContext = new GraphicContext();
        mWPDFGraphics2D.setGraphicContext(graphicContext);
        Rectangle2D rectangle2D = PrintUtilities.pagePositionToJavaPosition(mPrintJob.getPaperSize(), mPrintJob.getPaperPosition());
        mWPDFGraphics2D.translate(rectangle2D.getX() * (double)mWPDFGraphics2D.getDeviceDPI(), rectangle2D.getY() * (double)mWPDFGraphics2D.getDeviceDPI());
        Rectangle2D rectangle2D2 = mPrintJob.getPaperPositionInPoints();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, rectangle2D2.getWidth(), rectangle2D2.getHeight());
        PrintUtilities.setGraphicsPosition((Graphics2D)((Object)mWPDFGraphics2D), mPrintJob.getSourceSize(), double_);
        if (this.fDontCompressPDF) {
            object = mWPDFGraphics2D.getPDFDocument();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("null");
            object.getFilterMap().put("default", arrayList);
            object.getFilterMap().put("font", arrayList);
            object.getFilterMap().put("content", arrayList);
            object.getFilterMap().put("metadata", arrayList);
            object.getFilterMap().put("image", arrayList);
        }
        object = mWPDFGraphics2D;
        object = new RenderedImageDrawingGraphics2D((Graphics)object);
        object = new ImageScalingGraphics2D((Graphics)object);
        object = new PenOffsetGraphics2D((Graphics)object);
        object = new TextRenderingGraphics2D((Graphics)object);
        return object;
    }

    @Override
    public void startPage(MPrintJob mPrintJob, Graphics graphics, OutputStream outputStream) {
        Graphics2DDecorator graphics2DDecorator = (Graphics2DDecorator)graphics;
        ((PDFDocumentGraphics2D)graphics2DDecorator.getUndecoratedGraphics()).nextPage();
    }

    @Override
    public void endPage(Graphics graphics, OutputStream outputStream) {
    }

    @Override
    public void endJob(Graphics graphics, OutputStream outputStream) throws OutputProcessingException {
        try {
            Graphics2DDecorator graphics2DDecorator = (Graphics2DDecorator)graphics;
            ((PDFDocumentGraphics2D)graphics2DDecorator.getUndecoratedGraphics()).finish();
        }
        catch (IOException iOException) {
            throw new OutputProcessingException(iOException);
        }
    }

    private static class GraphicsState {
        private PDFArray fPageContents = null;
        private OutputStream fOutput = null;
        public IOException fStreamWriteIOError = null;

        private GraphicsState() {
        }
    }

    private static class MWPDFGraphics2D
    extends PDFDocumentGraphics2D {
        private GraphicsState fGraphicsState;
        private static final int sSingleStreamLimit = 1000000;

        public MWPDFGraphics2D(boolean bl, OutputStream outputStream, int n, int n2) throws IOException {
            super(bl, outputStream, n, n2);
            this.fGraphicsState = new GraphicsState();
            this.fGraphicsState.fOutput = outputStream;
        }

        public MWPDFGraphics2D(MWPDFGraphics2D mWPDFGraphics2D) {
            super((PDFDocumentGraphics2D)mWPDFGraphics2D);
            this.fGraphicsState = mWPDFGraphics2D.fGraphicsState;
        }

        public Graphics create() {
            this.preparePainting();
            return new MWPDFGraphics2D(this);
        }

        protected void startPage() throws IOException {
            super.startPage();
            this.fGraphicsState.fPageContents = new PDFArray();
        }

        protected void closePage() {
            PDFContext pDFContext = this.getPDFContext();
            if (!pDFContext.isPagePending()) {
                return;
            }
            this.getBuffer().append("Q\n");
            this.captureContentStream();
            this.getPDFDocument().registerObject((PDFObject)this.fGraphicsState.fPageContents);
            pDFContext.getCurrentPage().put("Contents", (Object)this.fGraphicsState.fPageContents);
            PDFAnnotList pDFAnnotList = pDFContext.getCurrentPage().getAnnotations();
            if (pDFAnnotList != null) {
                this.getPDFDocument().addObject((PDFObject)pDFAnnotList);
            }
            this.getPDFDocument().addObject((PDFObject)pDFContext.getCurrentPage());
            pDFContext.clearCurrentPage();
        }

        public void finish() throws IOException {
            super.finish();
            if (this.fGraphicsState.fStreamWriteIOError != null) {
                throw this.fGraphicsState.fStreamWriteIOError;
            }
        }

        protected void preparePainting() {
            super.preparePainting();
            if (this.getBuffer().length() > 1000000) {
                this.captureContentStream();
            }
        }

        private void captureContentStream() {
            PDFStream pDFStream = this.getPDFDocument().getFactory().makeStream("content", false);
            pDFStream.add(this.getString());
            this.getBuffer().setLength(0);
            this.getPDFDocument().registerObject((PDFObject)pDFStream);
            this.fGraphicsState.fPageContents.add((Object)new PDFReference((PDFObject)pDFStream));
            try {
                this.getPDFDocument().output(this.fGraphicsState.fOutput);
            }
            catch (IOException iOException) {
                this.fGraphicsState.fStreamWriteIOError = iOException;
            }
        }
    }
}

