/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import com.mathworks.hg.print.FOPEPSVectorStrategy;
import com.mathworks.hg.print.FOPPDFVectorStrategy;
import com.mathworks.hg.print.FOPPSVectorStrategy;
import com.mathworks.hg.print.OutputHelperDefinition;
import com.mathworks.hg.print.VectorHelperDefinition;
import com.mathworks.hg.print.VectorStrategy;
import com.mathworks.hg.util.MPrintJob;

public class FOPDefinitions {
    private static OutputHelperDefinition sPDF = new FOPPDFDefinition();
    private static OutputHelperDefinition sPS3 = new FOPPSDefinition(3);
    private static OutputHelperDefinition sPS2 = new FOPPSDefinition(2);
    private static OutputHelperDefinition sEPS3 = new FOPEPSDefinition(3);
    private static OutputHelperDefinition sEPS2 = new FOPEPSDefinition(2);

    public static OutputHelperDefinition PDF() {
        return sPDF;
    }

    public static OutputHelperDefinition PS3() {
        return sPS3;
    }

    public static OutputHelperDefinition PS2() {
        return sPS2;
    }

    public static OutputHelperDefinition EPS3() {
        return sEPS3;
    }

    public static OutputHelperDefinition EPS2() {
        return sEPS2;
    }

    private static class FOPEPSDefinition
    extends VectorHelperDefinition {
        int fLanguageLevel = 3;

        public FOPEPSDefinition(int n) {
            super(true, false, false);
            this.fLanguageLevel = n;
        }

        @Override
        public VectorStrategy createStrategy(MPrintJob mPrintJob) {
            return new FOPEPSVectorStrategy(this.fLanguageLevel);
        }
    }

    private static class FOPPSDefinition
    extends VectorHelperDefinition {
        int fLanguageLevel = 3;

        public FOPPSDefinition(int n) {
            super(false, true, false);
            this.fLanguageLevel = n;
        }

        @Override
        public VectorStrategy createStrategy(MPrintJob mPrintJob) {
            return new FOPPSVectorStrategy(this.fLanguageLevel);
        }
    }

    private static class FOPPDFDefinition
    extends VectorHelperDefinition {
        public FOPPDFDefinition() {
            super(true, true, false);
        }

        @Override
        public VectorStrategy createStrategy(MPrintJob mPrintJob) {
            return new FOPPDFVectorStrategy();
        }
    }
}

