/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import com.mathworks.hg.print.ColorConverter;
import com.mathworks.hg.print.TextureInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class AlphaCompositer
implements ColorConverter {
    private static final Color PAGE_COLOR = Color.WHITE;

    @Override
    public Color convert(Graphics2D graphics2D, Color color) {
        float f;
        if (color.getTransparency() != 1 && (f = (float)color.getAlpha() / 255.0f) > 0.0f) {
            float[] fArray = this.getBackgroundComponents(graphics2D.getBackground());
            float[] fArray2 = color.getColorComponents(null);
            this.compositeComponents(fArray2, fArray, f, fArray2.length);
            return new Color(color.getColorSpace(), fArray2, 1.0f);
        }
        return color;
    }

    @Override
    public Paint convertPaint(Graphics2D graphics2D, Paint paint) {
        return new AlphaCompositingPaint(paint, graphics2D.getBackground());
    }

    @Override
    public BufferedImage convertImage(Graphics2D graphics2D, BufferedImage bufferedImage) {
        if (this.hasAlpha(bufferedImage)) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            ColorModel colorModel = bufferedImage.getColorModel();
            float[] fArray = this.getBackgroundComponents(PAGE_COLOR, graphics2D.getBackground(), colorModel.getColorSpace());
            WritableRaster writableRaster2 = this.convertRaster(writableRaster, colorModel, fArray);
            return new BufferedImage(colorModel, writableRaster2, bufferedImage.isAlphaPremultiplied(), null);
        }
        return bufferedImage;
    }

    private WritableRaster convertRaster(Raster raster, ColorModel colorModel, float[] fArray) {
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        int n3 = writableRaster.getNumBands() - 1;
        int[] nArray = new int[writableRaster.getNumBands()];
        float[] fArray2 = new float[writableRaster.getNumBands()];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                nArray = raster.getPixel(i, j, nArray);
                fArray2 = colorModel.getNormalizedComponents(nArray, 0, fArray2, 0);
                float f = fArray2[n3];
                this.compositeComponents(fArray2, fArray, f, writableRaster.getNumBands() - 1);
                fArray2[n3] = 1.0f;
                nArray = colorModel.getUnnormalizedComponents(fArray2, 0, nArray, 0);
                writableRaster.setPixel(i, j, nArray);
            }
        }
        return writableRaster;
    }

    private boolean hasAlpha(BufferedImage bufferedImage) {
        if (bufferedImage.getTransparency() != 1) {
            WritableRaster writableRaster = bufferedImage.getAlphaRaster();
            if (writableRaster == null || writableRaster.getNumBands() != 1) {
                return false;
            }
            int n = writableRaster.getSampleModel().getSampleSize(0);
            int n2 = (1 << n) - 1;
            for (int i = 0; i < bufferedImage.getWidth(); ++i) {
                for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                    int n3 = writableRaster.getSample(i, j, 0);
                    if (n3 >= n2) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private float[] getColorComponents(Color color, ColorSpace colorSpace) {
        if (color.getColorSpace().equals(colorSpace)) {
            return color.getColorComponents(null);
        }
        return color.getColorComponents(colorSpace, null);
    }

    private void compositeComponents(float[] fArray, float[] fArray2, float f, int n) {
        if (f < 1.0f) {
            for (int i = 0; i < n; ++i) {
                fArray[i] = fArray[i] * f + fArray2[i] * (1.0f - f);
            }
        }
    }

    private float[] getBackgroundComponents(Color color) {
        return this.getBackgroundComponents(PAGE_COLOR, color, color.getColorSpace());
    }

    private float[] getBackgroundComponents(Color color, Color color2, ColorSpace colorSpace) {
        float[] fArray = this.getColorComponents(color, colorSpace);
        float[] fArray2 = this.getColorComponents(color2, colorSpace);
        float f = (float)color2.getAlpha() / 255.0f;
        this.compositeComponents(fArray2, fArray, f, fArray2.length);
        return fArray2;
    }

    private class AlphaCompositingPaint
    implements Paint,
    TextureInfo {
        private Paint fRealPaint;
        private Color fBackground;

        public AlphaCompositingPaint(Paint paint, Color color) {
            this.fRealPaint = paint;
            this.fBackground = color;
        }

        @Override
        public Dimension getBestTextureSize() {
            if (this.fRealPaint instanceof TextureInfo) {
                return ((TextureInfo)((Object)this.fRealPaint)).getBestTextureSize();
            }
            return new Dimension(-1, -1);
        }

        @Override
        public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
            PaintContext paintContext = this.fRealPaint.createContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
            if (paintContext.getColorModel().getTransparency() != 1) {
                return new AlphaCompositingPaintContext(paintContext);
            }
            return paintContext;
        }

        @Override
        public int getTransparency() {
            return this.fRealPaint.getTransparency();
        }

        private class AlphaCompositingPaintContext
        implements PaintContext {
            private PaintContext fRealContext;

            public AlphaCompositingPaintContext(PaintContext paintContext) {
                this.fRealContext = paintContext;
            }

            @Override
            public void dispose() {
                this.fRealContext.dispose();
            }

            @Override
            public ColorModel getColorModel() {
                return this.fRealContext.getColorModel();
            }

            @Override
            public Raster getRaster(int n, int n2, int n3, int n4) {
                Raster raster = this.fRealContext.getRaster(n, n2, n3, n4);
                ColorModel colorModel = this.fRealContext.getColorModel();
                float[] fArray = AlphaCompositer.this.getBackgroundComponents(AlphaCompositingPaint.this.fBackground);
                return AlphaCompositer.this.convertRaster(raster, colorModel, fArray);
            }
        }
    }
}

