/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.utils;

import com.mathworks.hg.peer.UITreePeerRenderer;
import com.mathworks.mwswing.MJTree;
import com.mathworks.util.PlatformInfo;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class UIMJTree
extends MJTree
implements Autoscroll,
DragGestureListener,
DragSourceListener {
    private TreePath fpathSrc;
    private BufferedImage fDragImage;
    private Point fOffset = new Point();
    private TreePath fLastPath = null;
    private Rectangle2D fRectDrag = new Rectangle2D.Float();
    private Point fLastPt = new Point();
    public int SCROLLING_MARGIN = 20;

    public UIMJTree() {
        if (!GraphicsEnvironment.isHeadless()) {
            DragSource dragSource = DragSource.getDefaultDragSource();
            dragSource.createDefaultDragGestureRecognizer((Component)((Object)this), 3, this);
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Serializable serializable;
        Object object;
        Point point = dragGestureEvent.getDragOrigin();
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            return;
        }
        if (this.isRootVisible() && this.getRowForPath(treePath) == 0) {
            return;
        }
        if (this.getSelectionModel().getSelectionMode() == 1) {
            object = this.getPathBounds(treePath);
            this.fOffset.setLocation(point.x - ((Rectangle)object).x, point.y - ((Rectangle)object).y);
            serializable = (JLabel)this.getCellRenderer().getTreeCellRendererComponent((JTree)((Object)this), treePath.getLastPathComponent(), false, this.isExpanded(treePath), this.getModel().isLeaf(treePath.getLastPathComponent()), 0, false);
            ((Component)serializable).setSize((int)((Rectangle)object).getWidth(), (int)((Rectangle)object).getHeight());
            this.fDragImage = new BufferedImage((int)((Rectangle)object).getWidth(), (int)((Rectangle)object).getHeight(), 3);
            Graphics2D graphics2D = this.fDragImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.getInstance(2, 0.5f));
            ((JComponent)serializable).paint(graphics2D);
            graphics2D.dispose();
            this.setSelectionPath(treePath);
        }
        object = new CTransferableTreePath(treePath);
        this.fpathSrc = treePath;
        serializable = new Point(5, 5);
        if (PlatformInfo.isMacintosh()) {
            serializable = new Point(-20, -20);
        }
        dragGestureEvent.startDrag(null, this.fDragImage, (Point)serializable, (Transferable)object, this);
    }

    public void drawDragImage(Point point, boolean bl) {
        if (point.equals(this.fLastPt) || this.fDragImage == null) {
            return;
        }
        int n = ((UITreePeerRenderer)this.getCellRenderer()).getDraggingRow();
        int n2 = bl ? this.getRowForLocation(point.x, point.y) : -1;
        ((UITreePeerRenderer)this.getCellRenderer()).setDraggingRow(n2);
        if (n >= 0) {
            this.paintImmediately(this.getRowBounds(n));
        } else if (this.getSelectionCount() > 0 && bl) {
            this.repaint();
        }
        if (n2 >= 0) {
            this.paintImmediately(this.getRowBounds(n2));
        }
        if (!DragSource.isDragImageSupported()) {
            this.fLastPt = point;
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            this.paintImmediately(this.fRectDrag.getBounds());
            this.fRectDrag.setRect(point.x, point.y - this.fOffset.y, this.fDragImage.getWidth(), this.fDragImage.getHeight());
            graphics2D.drawImage(this.fDragImage, AffineTransform.getTranslateInstance(this.fRectDrag.getX(), this.fRectDrag.getY()), null);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
        ((UITreePeerRenderer)this.getCellRenderer()).setDraggingRow(-1);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        int n;
        if (dragSourceDropEvent.getDropSuccess() && (n = dragSourceDropEvent.getDropAction()) == 2) {
            this.fpathSrc = null;
        }
        this.fDragImage = null;
        ((UITreePeerRenderer)this.getCellRenderer()).setDraggingRow(-1);
        this.repaint();
    }

    @Override
    public void autoscroll(Point point) {
        int n = this.getClosestRowForLocation(point.x, point.y);
        if (n < 0) {
            return;
        }
        n = point.y + this.getBounds().y < this.SCROLLING_MARGIN ? --n : ++n;
        if (n >= 0 && n < this.getRowCount()) {
            this.scrollRowToVisible(n);
        }
        this.repaint();
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle rectangle = this.getParent().getBounds();
        Rectangle rectangle2 = this.getBounds();
        return new Insets(rectangle.y - rectangle2.y + this.SCROLLING_MARGIN, rectangle.x - rectangle2.x + this.SCROLLING_MARGIN, rectangle2.y + rectangle2.height - rectangle.y - rectangle.height + this.SCROLLING_MARGIN, rectangle2.x + rectangle2.width - rectangle.x - rectangle.width + this.SCROLLING_MARGIN);
    }

    class CTransferableTreePath
    implements Transferable {
        public final DataFlavor TREEPATH_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "TreePath");
        private TreePath _path;
        private DataFlavor[] _flavors = new DataFlavor[]{this.TREEPATH_FLAVOR};

        public CTransferableTreePath(TreePath treePath) {
            this._path = treePath;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this._flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return Arrays.asList(this._flavors).contains(dataFlavor);
        }

        @Override
        public synchronized Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (dataFlavor.isMimeTypeEqual(this.TREEPATH_FLAVOR.getMimeType())) {
                return this._path;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }
}

