/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.utils;

import com.mathworks.hg.peer.WindowsTextMetric;
import com.mathworks.mwswing.MJTextPane;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class MJMultilineText
extends MJTextPane {
    Style fTextStyle = null;
    DefaultStyledDocument doc = null;
    Color fFgColor;

    public MJMultilineText(String string, boolean bl) {
        assert (SwingUtilities.isEventDispatchThread());
        StyleContext styleContext = new StyleContext();
        this.doc = new DefaultStyledDocument(styleContext);
        this.setDocument(this.doc);
        Style style = styleContext.getStyle("default");
        this.fTextStyle = styleContext.addStyle("MultilineLabelStyle", style);
        StyleConstants.setAlignment(this.fTextStyle, 1);
        this.doc.setLogicalStyle(0, this.fTextStyle);
        this.setText(string);
        this.setWrapping(bl);
        this.fFgColor = this.getForeground();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.makeLeadingMatchNative(font);
    }

    private void makeLeadingMatchNative(Font font) {
        if (PlatformInfo.isWindows() && this.fTextStyle != null && font != null) {
            try {
                WindowsTextMetric windowsTextMetric = new WindowsTextMetric(NativeJava.hWndFromComponent((Component)((Object)this)), font);
                FontMetrics fontMetrics = this.getFontMetrics(font);
                int n = fontMetrics.getMaxAscent();
                int n2 = fontMetrics.getMaxDescent();
                int n3 = fontMetrics.getLeading();
                int n4 = n + n2 + n3 - windowsTextMetric.tmHeight();
                StyleConstants.setSpaceBelow(this.fTextStyle, -n4);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        this.makeLeadingMatchNative(this.getFont());
    }

    public MJMultilineText(String string) {
        this(string, true);
    }

    public MJMultilineText(boolean bl) {
        this("", bl);
    }

    public MJMultilineText() {
        this("", true);
    }

    public void setHorizontalAlignment(int n) {
        StyleConstants.setAlignment(this.fTextStyle, n);
        this.doc.setLogicalStyle(0, this.fTextStyle);
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            super.setForeground(this.fFgColor);
        } else {
            this.fFgColor = this.getForeground();
            super.setForeground(this.getDisabledTextColor());
        }
        super.setEnabled(bl);
    }

    public void setForeground(Color color) {
        if (this.isEnabled()) {
            super.setForeground(color);
        } else {
            this.fFgColor = color;
        }
    }
}

